/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueGroupNodeImpl
extends XValueContainerNode<XValueGroup>
implements RestorableStateNode {
    public XValueGroupNodeImpl(XDebuggerTree tree, XDebuggerTreeNode parent, @NotNull XValueGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueGroupNodeImpl", "<init>"));
        }
        super(tree, parent, group);
        this.setLeaf(false);
        this.myText.append(group.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String comment = group.getComment();
        if (comment != null) {
            XValuePresentationUtil.appendSeparator((ColoredTextContainer)this.myText, group.getSeparator());
            this.myText.append(comment, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (group.isAutoExpand()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!XValueGroupNodeImpl.this.isObsolete()) {
                        XValueGroupNodeImpl.this.myTree.expandPath(XValueGroupNodeImpl.this.getPath());
                    }
                }
            });
        }
        this.myTree.nodeLoaded(this, group.getName());
    }

    public String toString() {
        return "Group:" + ((XValueGroup)this.myValueContainer).getName();
    }

    @Override
    @Nullable
    public String getName() {
        return ((XValueGroup)this.myValueContainer).getName();
    }

    @Override
    @Nullable
    public String getRawValue() {
        return null;
    }

    @Override
    public boolean isComputed() {
        return true;
    }

    @Override
    public void markChanged() {
    }
}

