/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class MissingDeprecatedAnnotationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("missing.deprecated.annotation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/MissingDeprecatedAnnotationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("missing.deprecated.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/MissingDeprecatedAnnotationInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MissingDeprecatedAnnotationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MissingDeprecatedAnnotationVisitor();
    }

    private static class MissingDeprecatedAnnotationVisitor
    extends BaseInspectionVisitor {
        private MissingDeprecatedAnnotationVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationVisitor", "visitClass"));
            }
            super.visitClass(aClass);
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)aClass)) {
                return;
            }
            if (!MissingDeprecatedAnnotationVisitor.hasDeprecatedComment((PsiDocCommentOwner)aClass) || MissingDeprecatedAnnotationVisitor.hasDeprecatedAnnotation((PsiModifierListOwner)aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/classlayout/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationVisitor", "visitMethod"));
            }
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)method)) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (!MissingDeprecatedAnnotationVisitor.hasDeprecatedComment((PsiDocCommentOwner)method) || MissingDeprecatedAnnotationVisitor.hasDeprecatedAnnotation((PsiModifierListOwner)method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/classlayout/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationVisitor", "visitField"));
            }
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)field)) {
                return;
            }
            if (!MissingDeprecatedAnnotationVisitor.hasDeprecatedComment((PsiDocCommentOwner)field) || MissingDeprecatedAnnotationVisitor.hasDeprecatedAnnotation((PsiModifierListOwner)field)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private static boolean hasDeprecatedAnnotation(PsiModifierListOwner element) {
            PsiModifierList modifierList = element.getModifierList();
            if (modifierList == null) {
                return false;
            }
            PsiAnnotation annotation = modifierList.findAnnotation("java.lang.Deprecated");
            return annotation != null;
        }

        private static boolean hasDeprecatedComment(PsiDocCommentOwner element) {
            PsiDocComment comment = element.getDocComment();
            if (comment == null) {
                return false;
            }
            PsiDocTag deprecatedTag = comment.findTagByName("deprecated");
            return deprecatedTag != null;
        }
    }

    private static class MissingDeprecatedAnnotationFix
    extends InspectionGadgetsFix {
        private MissingDeprecatedAnnotationFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("missing.deprecated.annotation.add.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement identifier = descriptor.getPsiElement();
            PsiModifierListOwner parent = (PsiModifierListOwner)identifier.getParent();
            if (parent == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiAnnotation annotation = factory.createAnnotationFromText("@java.lang.Deprecated", (PsiElement)parent);
            PsiModifierList modifierList = parent.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.addAfter((PsiElement)annotation, null);
        }
    }
}

