/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoUnboxingInspection
extends BaseInspection {
    @NonNls
    static final Map<String, String> s_unboxingMethods = new HashMap<String, String>(8);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("auto.unboxing.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AutoUnboxingInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("auto.unboxing.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AutoUnboxingInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    public InspectionGadgetsFix buildFix(Object ... infos) {
        if (!AutoUnboxingInspection.isFixApplicable((PsiExpression)infos[0])) {
            return null;
        }
        return new AutoUnboxingFix();
    }

    private static boolean isFixApplicable(PsiExpression location) {
        PsiReferenceExpression reference;
        PsiElement parent = location.getParent();
        if (!(parent instanceof PsiPostfixExpression)) {
            return true;
        }
        if (location instanceof PsiReferenceExpression) {
            reference = (PsiReferenceExpression)location;
        } else if (location instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)location;
            PsiExpression expression = arrayAccessExpression.getArrayExpression();
            if (!(expression instanceof PsiReferenceExpression)) {
                return true;
            }
            reference = (PsiReferenceExpression)expression;
        } else {
            return true;
        }
        PsiElement element = reference.resolve();
        if (element == null) {
            return true;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiStatement.class);
        LocalSearchScope scope = new LocalSearchScope((PsiElement)statement);
        Query query = ReferencesSearch.search((PsiElement)element, (SearchScope)scope);
        Collection references = query.findAll();
        return references.size() <= 1;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AutoUnboxingVisitor();
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/siyeh/ig/jdk/AutoUnboxingInspection", "buildVisitor"));
        }
        PsiFile psiFile = holder.getFile();
        if (psiFile.getLanguage() != JavaLanguage.INSTANCE || !PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiFile)) {
            PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){};
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AutoUnboxingInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AutoUnboxingInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    static {
        s_unboxingMethods.put("byte", "byteValue");
        s_unboxingMethods.put("short", "shortValue");
        s_unboxingMethods.put("int", "intValue");
        s_unboxingMethods.put("long", "longValue");
        s_unboxingMethods.put("float", "floatValue");
        s_unboxingMethods.put("double", "doubleValue");
        s_unboxingMethods.put("boolean", "booleanValue");
        s_unboxingMethods.put("char", "charValue");
    }

    private static class AutoUnboxingVisitor
    extends BaseInspectionVisitor {
        private AutoUnboxingVisitor() {
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
            super.visitArrayAccessExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            super.visitTypeCastExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            super.visitAssignmentExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            super.visitParenthesizedExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        private void checkExpression(PsiExpression expression) {
            if (expression.getParent() instanceof PsiParenthesizedExpression) {
                return;
            }
            PsiType expressionType = expression.getType();
            if (expressionType == null) {
                return;
            }
            if (expressionType.getArrayDimensions() > 0) {
                return;
            }
            if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expressionType)) {
                return;
            }
            if (!TypeConversionUtil.isAssignableFromPrimitiveWrapper((PsiType)expressionType)) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, false, true);
            if (expectedType == null || !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }
    }

    private static class AutoUnboxingFix
    extends InspectionGadgetsFix {
        private AutoUnboxingFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("auto.unboxing.make.unboxing.explicit.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AutoUnboxingInspection$AutoUnboxingFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AutoUnboxingInspection$AutoUnboxingFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression expression = (PsiExpression)descriptor.getPsiElement();
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            PsiPrimitiveType unboxedType = (PsiPrimitiveType)ExpectedTypeUtils.findExpectedType(expression, false, true);
            if (unboxedType == null) {
                return;
            }
            String newExpressionText = AutoUnboxingFix.buildNewExpressionText(expression, unboxedType);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiElement parent = expression.getParent();
            String expressionText = expression.getText();
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
                PsiReplacementUtil.replaceExpression((PsiExpression)typeCastExpression, newExpressionText);
            } else if (parent instanceof PsiPrefixExpression && !unboxedType.equalsToText("boolean")) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
                IElementType tokenType = prefixExpression.getOperationTokenType();
                if (JavaTokenType.PLUSPLUS.equals(tokenType)) {
                    PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, expressionText + '=' + newExpressionText + "+1");
                } else if (JavaTokenType.MINUSMINUS.equals(tokenType)) {
                    PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, expressionText + '=' + newExpressionText + "-1");
                } else {
                    PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, prefixExpression.getOperationSign().getText() + newExpressionText);
                }
            } else if (parent instanceof PsiPostfixExpression) {
                PsiPostfixExpression postfixExpression = (PsiPostfixExpression)parent;
                IElementType tokenType = postfixExpression.getOperationTokenType();
                PsiElement grandParent = postfixExpression.getParent();
                if (grandParent instanceof PsiExpressionStatement) {
                    if (JavaTokenType.PLUSPLUS.equals(tokenType)) {
                        PsiReplacementUtil.replaceExpression((PsiExpression)postfixExpression, expressionText + '=' + newExpressionText + "+1");
                    } else if (JavaTokenType.MINUSMINUS.equals(tokenType)) {
                        PsiReplacementUtil.replaceExpression((PsiExpression)postfixExpression, expressionText + '=' + newExpressionText + "-1");
                    }
                } else {
                    PsiElement element = postfixExpression.replace((PsiElement)postfixExpression.getOperand());
                    PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
                    if (statement == null) {
                        return;
                    }
                    PsiStatement newStatement = JavaTokenType.PLUSPLUS.equals(tokenType) ? factory.createStatementFromText(expressionText + '=' + newExpressionText + "+1;", (PsiElement)statement) : factory.createStatementFromText(expressionText + '=' + newExpressionText + "-1;", (PsiElement)statement);
                    PsiElement greatGrandParent = statement.getParent();
                    greatGrandParent.addAfter((PsiElement)newStatement, (PsiElement)statement);
                }
            } else if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression lExpression = assignmentExpression.getLExpression();
                if (expression.equals(lExpression)) {
                    PsiJavaToken operationSign = assignmentExpression.getOperationSign();
                    String operationSignText = operationSign.getText();
                    char sign = operationSignText.charAt(0);
                    PsiExpression rExpression = assignmentExpression.getRExpression();
                    if (rExpression == null) {
                        return;
                    }
                    String text = lExpression.getText() + '=' + newExpressionText + sign + rExpression.getText();
                    PsiExpression newExpression = factory.createExpressionFromText(text, (PsiElement)assignmentExpression);
                    assignmentExpression.replace((PsiElement)newExpression);
                } else {
                    PsiReplacementUtil.replaceExpression(expression, newExpressionText);
                }
            } else {
                PsiReplacementUtil.replaceExpression(expression, newExpressionText);
            }
        }

        private static String buildNewExpressionText(PsiExpression expression, PsiPrimitiveType unboxedType) {
            PsiMethodCallExpression methodCallExpression;
            String unboxedTypeText = unboxedType.getCanonicalText();
            String expressionText = expression.getText();
            String boxMethodName = s_unboxingMethods.get(unboxedTypeText);
            if (expression instanceof PsiTypeCastExpression) {
                return '(' + expressionText + ")." + boxMethodName + "()";
            }
            String constantText = AutoUnboxingFix.computeConstantBooleanText(expression);
            if (constantText != null) {
                return constantText;
            }
            if (expression instanceof PsiMethodCallExpression && AutoUnboxingFix.isValueOfCall(methodCallExpression = (PsiMethodCallExpression)expression)) {
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                PsiExpression argument = arguments[0];
                return argument.getText();
            }
            PsiType type = expression.getType();
            if (type != null && type.equalsToText("java.lang.Object")) {
                return "((" + unboxedType.getBoxedTypeName() + ')' + expressionText + ")." + boxMethodName + "()";
            }
            return expressionText + '.' + boxMethodName + "()";
        }

        private static boolean isValueOfCall(PsiMethodCallExpression methodCallExpression) {
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiExpression argument = arguments[0];
            PsiType type = argument.getType();
            return MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Integer", null, "valueOf", new PsiType[]{PsiType.INT}) && PsiType.INT.equals((Object)type) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Short", null, "valueOf", new PsiType[]{PsiType.SHORT}) && PsiType.SHORT.equals((Object)type) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Byte", null, "valueOf", new PsiType[]{PsiType.BYTE}) && PsiType.BYTE.equals((Object)type) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Long", null, "valueOf", new PsiType[]{PsiType.LONG}) && PsiType.LONG.equals((Object)type) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Character", null, "valueOf", new PsiType[]{PsiType.CHAR}) && PsiType.CHAR.equals((Object)type) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Double", null, "valueOf", new PsiType[]{PsiType.DOUBLE}) && PsiType.DOUBLE.equals((Object)type) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Float", null, "valueOf", new PsiType[]{PsiType.FLOAT}) && PsiType.FLOAT.equals((Object)type);
        }

        @NonNls
        private static String computeConstantBooleanText(PsiExpression expression) {
            if (!(expression instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)target;
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (!"java.lang.Boolean".equals(qualifiedName)) {
                return null;
            }
            String name = field.getName();
            if ("TRUE".equals(name)) {
                return "true";
            }
            if ("FALSE".equals(name)) {
                return "false";
            }
            return null;
        }
    }
}

