/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.template;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Comparing;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.generate.tostring.template.TemplateResource;
import org.jetbrains.generate.tostring.template.TemplateResourceLocator;
import org.jetbrains.generate.tostring.template.TemplatesState;

@State(name="ToStringTemplates", storages={@Storage(file="$APP_CONFIG$/toStringTemplates.xml")})
public class TemplatesManager
implements PersistentStateComponent<TemplatesState> {
    private TemplatesState myState = new TemplatesState();

    public static TemplatesManager getInstance() {
        return (TemplatesManager)ServiceManager.getService(TemplatesManager.class);
    }

    public TemplatesManager() {
        for (TemplateResource o : TemplateResourceLocator.getDefaultTemplates()) {
            this.addTemplate(o);
        }
    }

    public TemplatesState getState() {
        return this.myState;
    }

    public void loadState(TemplatesState state) {
        this.myState = state;
    }

    public void addTemplate(TemplateResource template) {
        this.myState.templates.add(template);
    }

    public void removeTemplate(TemplateResource template) {
        Iterator<TemplateResource> it = this.myState.templates.iterator();
        while (it.hasNext()) {
            TemplateResource resource = it.next();
            if (!Comparing.equal((String)resource.getFileName(), (String)template.getFileName())) continue;
            it.remove();
        }
    }

    public Collection<TemplateResource> getAllTemplates() {
        TemplateResource[] defaultTemplates = TemplateResourceLocator.getDefaultTemplates();
        HashSet<String> names = new HashSet<String>();
        for (TemplateResource defaultTemplate : defaultTemplates) {
            names.add(defaultTemplate.getFileName());
        }
        LinkedHashSet<TemplateResource> templates = new LinkedHashSet<TemplateResource>(Arrays.asList(defaultTemplates));
        for (TemplateResource template : this.myState.templates) {
            if (names.contains(template.getFileName())) continue;
            templates.add(template);
        }
        return templates;
    }

    public TemplateResource getDefaultTemplate() {
        for (TemplateResource template : this.getAllTemplates()) {
            if (!Comparing.equal((String)template.getFileName(), (String)this.myState.defaultTempalteName)) continue;
            return template;
        }
        return this.getAllTemplates().iterator().next();
    }

    public void setDefaultTemplate(TemplateResource res) {
        this.myState.defaultTempalteName = res.getFileName();
    }

    public void setTemplates(List<TemplateResource> items) {
        this.myState.templates.clear();
        for (TemplateResource item : items) {
            if (item.isDefault()) continue;
            this.myState.templates.add(item);
        }
    }
}

