/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.socksx.v5.Socks5AuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5AuthStatus;
import io.netty.handler.codec.socksx.v5.Socks5Response;
import io.netty.handler.codec.socksx.v5.Socks5SubnegotiationVersion;
import io.netty.handler.codec.socksx.v5.UnknownSocks5Response;
import java.util.List;

public class Socks5AuthResponseDecoder
extends ReplayingDecoder<State> {
    private Socks5SubnegotiationVersion version;
    private Socks5AuthStatus authStatus;
    private Socks5Response msg = UnknownSocks5Response.INSTANCE;

    public Socks5AuthResponseDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = Socks5SubnegotiationVersion.valueOf(byteBuf.readByte());
                if (this.version != Socks5SubnegotiationVersion.AUTH_PASSWORD) break;
                this.checkpoint(State.READ_AUTH_RESPONSE);
            }
            case READ_AUTH_RESPONSE: {
                this.authStatus = Socks5AuthStatus.valueOf(byteBuf.readByte());
                this.msg = new Socks5AuthResponse(this.authStatus);
            }
        }
        channelHandlerContext.pipeline().remove(this);
        out.add(this.msg);
    }

    static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_AUTH_RESPONSE;

    }
}

