/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class InitializerProcessor {
    public static void extractInitializers(ClassWrapper wrapper) {
        MethodWrapper meth = wrapper.getMethodWrapper("<clinit>", "()V");
        if (meth != null && meth.root != null) {
            InitializerProcessor.extractStaticInitializers(wrapper, meth);
        }
        InitializerProcessor.extractDynamicInitializers(wrapper);
        InitializerProcessor.liftConstructor(wrapper);
        if (DecompilerContext.getOption("hes")) {
            InitializerProcessor.hideEmptySuper(wrapper);
        }
    }

    private static void liftConstructor(ClassWrapper wrapper) {
        block0: for (MethodWrapper meth : wrapper.getMethods()) {
            if (!"<init>".equals(meth.methodStruct.getName()) || meth.root == null) continue;
            Statement firstdata = InitializerProcessor.findFirstData(meth.root);
            if (firstdata == null) {
                return;
            }
            int index = 0;
            List<Exprent> lstExprents = firstdata.getExprents();
            for (Exprent exprent : lstExprents) {
                int action = 0;
                if (exprent.type == 2) {
                    StructField structField;
                    FieldExprent fexpr;
                    AssignmentExprent asexpr = (AssignmentExprent)exprent;
                    if (asexpr.getLeft().type == 5 && asexpr.getRight().type == 12 && (fexpr = (FieldExprent)asexpr.getLeft()).getClassname().equals(wrapper.getClassStruct().qualifiedName) && (structField = wrapper.getClassStruct().getField(fexpr.getName(), fexpr.getDescriptor().descriptorString)) != null && structField.hasModifier(16)) {
                        action = 1;
                    }
                } else if (index > 0 && exprent.type == 8 && InitializerProcessor.isInvocationInitConstructor((InvocationExprent)exprent, meth, wrapper, true)) {
                    lstExprents.add(0, lstExprents.remove(index));
                    action = 2;
                }
                if (action != 1) continue block0;
                ++index;
            }
        }
    }

    private static void hideEmptySuper(ClassWrapper wrapper) {
        for (MethodWrapper meth : wrapper.getMethods()) {
            InvocationExprent invexpr;
            if (!"<init>".equals(meth.methodStruct.getName()) || meth.root == null) continue;
            Statement firstdata = InitializerProcessor.findFirstData(meth.root);
            if (firstdata == null || firstdata.getExprents().isEmpty()) {
                return;
            }
            Exprent exprent = firstdata.getExprents().get(0);
            if (exprent.type != 8 || !InitializerProcessor.isInvocationInitConstructor(invexpr = (InvocationExprent)exprent, meth, wrapper, false) || !invexpr.getLstParameters().isEmpty()) continue;
            firstdata.getExprents().remove(0);
        }
    }

    private static void extractStaticInitializers(ClassWrapper wrapper, MethodWrapper meth) {
        RootStatement root = meth.root;
        StructClass cl = wrapper.getClassStruct();
        Statement firstdata = InitializerProcessor.findFirstData(root);
        if (firstdata != null) {
            while (!firstdata.getExprents().isEmpty()) {
                Exprent exprent = firstdata.getExprents().get(0);
                boolean found = false;
                if (exprent.type == 2) {
                    FieldExprent fexpr;
                    AssignmentExprent asexpr = (AssignmentExprent)exprent;
                    if (asexpr.getLeft().type == 5 && (fexpr = (FieldExprent)asexpr.getLeft()).isStatic() && fexpr.getClassname().equals(cl.qualifiedName) && cl.hasField(fexpr.getName(), fexpr.getDescriptor().descriptorString) && InitializerProcessor.isExprentIndependent(asexpr.getRight(), meth)) {
                        String keyField = InterpreterUtil.makeUniqueKey(fexpr.getName(), fexpr.getDescriptor().descriptorString);
                        if (!wrapper.getStaticFieldInitializers().containsKey(keyField)) {
                            wrapper.getStaticFieldInitializers().addWithKey(asexpr.getRight(), keyField);
                            firstdata.getExprents().remove(0);
                            found = true;
                        }
                    }
                }
                if (found) continue;
                break;
            }
        }
    }

    private static void extractDynamicInitializers(ClassWrapper wrapper) {
        StructClass cl = wrapper.getClassStruct();
        boolean isAnonymous = DecompilerContext.getClassProcessor().getMapRootClasses().get((Object)cl.qualifiedName).type == 2;
        ArrayList<List<Exprent>> lstFirst = new ArrayList<List<Exprent>>();
        ArrayList<MethodWrapper> lstMethWrappers = new ArrayList<MethodWrapper>();
        for (MethodWrapper meth : wrapper.getMethods()) {
            if (!"<init>".equals(meth.methodStruct.getName()) || meth.root == null) continue;
            Statement firstdata = InitializerProcessor.findFirstData(meth.root);
            if (firstdata == null || firstdata.getExprents().isEmpty()) {
                return;
            }
            lstFirst.add(firstdata.getExprents());
            lstMethWrappers.add(meth);
            Exprent exprent = firstdata.getExprents().get(0);
            if (isAnonymous || exprent.type == 8 && InitializerProcessor.isInvocationInitConstructor((InvocationExprent)exprent, meth, wrapper, false)) continue;
            return;
        }
        if (lstFirst.isEmpty()) {
            return;
        }
        block1: while (true) {
            List lst;
            String fieldWithDescr = null;
            Exprent value = null;
            for (int i = 0; i < lstFirst.size(); ++i) {
                lst = (List)lstFirst.get(i);
                if (lst.size() < (isAnonymous ? 1 : 2)) {
                    return;
                }
                Exprent exprent = (Exprent)lst.get(isAnonymous ? 0 : 1);
                boolean found = false;
                if (exprent.type == 2) {
                    FieldExprent fexpr;
                    AssignmentExprent asexpr = (AssignmentExprent)exprent;
                    if (asexpr.getLeft().type == 5 && !(fexpr = (FieldExprent)asexpr.getLeft()).isStatic() && fexpr.getClassname().equals(cl.qualifiedName) && cl.hasField(fexpr.getName(), fexpr.getDescriptor().descriptorString) && InitializerProcessor.isExprentIndependent(asexpr.getRight(), (MethodWrapper)lstMethWrappers.get(i))) {
                        String fieldKey = InterpreterUtil.makeUniqueKey(fexpr.getName(), fexpr.getDescriptor().descriptorString);
                        if (fieldWithDescr == null) {
                            fieldWithDescr = fieldKey;
                            value = asexpr.getRight();
                        } else if (!fieldWithDescr.equals(fieldKey) || !value.equals(asexpr.getRight())) {
                            return;
                        }
                        found = true;
                    }
                }
                if (found) continue;
                return;
            }
            if (wrapper.getDynamicFieldInitializers().containsKey(fieldWithDescr)) break;
            wrapper.getDynamicFieldInitializers().addWithKey(value, fieldWithDescr);
            Iterator i$ = lstFirst.iterator();
            while (true) {
                if (!i$.hasNext()) continue block1;
                lst = (List)i$.next();
                lst.remove(isAnonymous ? 0 : 1);
            }
            break;
        }
    }

    private static boolean isExprentIndependent(Exprent exprent, MethodWrapper meth) {
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        block4: for (Exprent expr : lst) {
            switch (expr.type) {
                case 12: {
                    VarVersionPaar varpaar = new VarVersionPaar((VarExprent)expr);
                    if (meth.varproc.getExternvars().contains(varpaar)) break;
                    String varname = meth.varproc.getVarName(varpaar);
                    if (varname.equals("this") || varname.endsWith(".this")) continue block4;
                    return false;
                }
                case 5: {
                    return false;
                }
            }
        }
        return true;
    }

    private static Statement findFirstData(Statement stat) {
        if (stat.getExprents() != null) {
            return stat;
        }
        if (stat.isLabeled()) {
            return null;
        }
        switch (stat.type) {
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: {
                return InitializerProcessor.findFirstData(stat.getFirst());
            }
        }
        return null;
    }

    private static boolean isInvocationInitConstructor(InvocationExprent inv, MethodWrapper meth, ClassWrapper wrapper, boolean withThis) {
        if (inv.getFunctype() == 2 && inv.getInstance().type == 12) {
            VarExprent instvar = (VarExprent)inv.getInstance();
            VarVersionPaar varpaar = new VarVersionPaar(instvar);
            String classname = meth.varproc.getThisvars().get(varpaar);
            if (classname != null && (withThis || !wrapper.getClassStruct().qualifiedName.equals(inv.getClassname()))) {
                return true;
            }
        }
        return false;
    }
}

