/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class ConstExprent
extends Exprent {
    private static final HashMap<Integer, String> escapes = new HashMap();
    private VarType consttype;
    private Object value;
    private boolean boolPermitted;

    public ConstExprent(int val, boolean boolPermitted) {
        this.type = 3;
        this.boolPermitted = boolPermitted;
        if (boolPermitted) {
            this.consttype = VarType.VARTYPE_BOOLEAN;
            if (val != 0 && val != 1) {
                this.consttype = this.consttype.copy();
                this.consttype.convinfo |= 1;
            }
        } else {
            this.consttype = 0 <= val && val <= 127 ? VarType.VARTYPE_BYTECHAR : (-128 <= val && val <= 127 ? VarType.VARTYPE_BYTE : (0 <= val && val <= Short.MAX_VALUE ? VarType.VARTYPE_SHORTCHAR : (Short.MIN_VALUE <= val && val <= Short.MAX_VALUE ? VarType.VARTYPE_SHORT : (0 <= val && val <= 65535 ? VarType.VARTYPE_CHAR : VarType.VARTYPE_INT))));
        }
        this.value = new Integer(val);
    }

    public ConstExprent(VarType consttype, Object value) {
        this.type = 3;
        this.consttype = consttype;
        this.value = value;
    }

    @Override
    public Exprent copy() {
        return new ConstExprent(this.consttype, this.value);
    }

    @Override
    public VarType getExprType() {
        return this.consttype;
    }

    @Override
    public int getExprentUse() {
        return 3;
    }

    @Override
    public List<Exprent> getAllExprents() {
        return new ArrayList<Exprent>();
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        boolean literal = DecompilerContext.getOption("lit");
        boolean ascii = DecompilerContext.getOption("asc");
        tracer.addMapping(this.bytecode);
        if (this.consttype.type != 13 && this.value == null) {
            return ExprProcessor.getCastTypeName(this.consttype);
        }
        switch (this.consttype.type) {
            case 7: {
                return Boolean.toString((Integer)this.value != 0);
            }
            case 1: {
                Integer val = (Integer)this.value;
                String ret = escapes.get(val);
                if (ret == null) {
                    char c = (char)val.intValue();
                    ret = c >= ' ' && c < '\u007f' || !ascii && InterpreterUtil.isPrintableUnicode(c) ? String.valueOf(c) : InterpreterUtil.charToUnicodeLiteral(c);
                }
                return "'" + ret + "'";
            }
            case 0: 
            case 4: 
            case 6: 
            case 15: 
            case 16: {
                String intfield;
                int ival = (Integer)this.value;
                if (literal) {
                    return this.value.toString();
                }
                if (ival == Integer.MAX_VALUE) {
                    intfield = "MAX_VALUE";
                } else if (ival == Integer.MIN_VALUE) {
                    intfield = "MIN_VALUE";
                } else {
                    return this.value.toString();
                }
                return new FieldExprent(intfield, "java/lang/Integer", true, null, FieldDescriptor.INTEGER_DESCRIPTOR).toJava(0, tracer);
            }
            case 5: {
                String longfield;
                long lval = (Long)this.value;
                if (literal) {
                    return this.value.toString() + "L";
                }
                if (lval == Long.MAX_VALUE) {
                    longfield = "MAX_VALUE";
                } else if (lval == Long.MIN_VALUE) {
                    longfield = "MIN_VALUE";
                } else {
                    return this.value.toString() + "L";
                }
                return new FieldExprent(longfield, "java/lang/Long", true, null, FieldDescriptor.LONG_DESCRIPTOR).toJava(0, tracer);
            }
            case 2: {
                String doublefield;
                double dval = (Double)this.value;
                if (literal) {
                    if (Double.isNaN(dval)) {
                        return "0.0D / 0.0";
                    }
                    if (dval == Double.POSITIVE_INFINITY) {
                        return "1.0D / 0.0";
                    }
                    if (dval == Double.NEGATIVE_INFINITY) {
                        return "-1.0D / 0.0";
                    }
                    return this.value.toString() + "D";
                }
                if (Double.isNaN(dval)) {
                    doublefield = "NaN";
                } else if (dval == Double.POSITIVE_INFINITY) {
                    doublefield = "POSITIVE_INFINITY";
                } else if (dval == Double.NEGATIVE_INFINITY) {
                    doublefield = "NEGATIVE_INFINITY";
                } else if (dval == Double.MAX_VALUE) {
                    doublefield = "MAX_VALUE";
                } else if (dval == Double.MIN_VALUE) {
                    doublefield = "MIN_VALUE";
                } else {
                    return this.value.toString() + "D";
                }
                return new FieldExprent(doublefield, "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR).toJava(0, tracer);
            }
            case 3: {
                String floatfield;
                float fval = ((Float)this.value).floatValue();
                if (literal) {
                    if (Double.isNaN(fval)) {
                        return "0.0F / 0.0";
                    }
                    if ((double)fval == Double.POSITIVE_INFINITY) {
                        return "1.0F / 0.0";
                    }
                    if ((double)fval == Double.NEGATIVE_INFINITY) {
                        return "-1.0F / 0.0";
                    }
                    return this.value.toString() + "F";
                }
                if (Float.isNaN(fval)) {
                    floatfield = "NaN";
                } else if (fval == Float.POSITIVE_INFINITY) {
                    floatfield = "POSITIVE_INFINITY";
                } else if (fval == Float.NEGATIVE_INFINITY) {
                    floatfield = "NEGATIVE_INFINITY";
                } else if (fval == Float.MAX_VALUE) {
                    floatfield = "MAX_VALUE";
                } else if (fval == Float.MIN_VALUE) {
                    floatfield = "MIN_VALUE";
                } else {
                    return this.value.toString() + "F";
                }
                return new FieldExprent(floatfield, "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR).toJava(0, tracer);
            }
            case 13: {
                return "null";
            }
            case 8: {
                if (this.consttype.equals(VarType.VARTYPE_STRING)) {
                    return "\"" + ConstExprent.convertStringToJava(this.value.toString(), ascii) + "\"";
                }
                if (!this.consttype.equals(VarType.VARTYPE_CLASS)) break;
                String strval = this.value.toString();
                VarType classtype = strval.startsWith("[") ? new VarType(strval, false) : new VarType(strval, true);
                return ExprProcessor.getCastTypeName(classtype) + ".class";
            }
        }
        throw new RuntimeException("invalid constant type");
    }

    private static String convertStringToJava(String value, boolean ascii) {
        char[] arr = value.toCharArray();
        StringBuilder buffer = new StringBuilder(arr.length);
        block10: for (char c : arr) {
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block10;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block10;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block10;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block10;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block10;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    buffer.append("\\'");
                    continue block10;
                }
                default: {
                    if (c >= ' ' && c < '\u007f' || !ascii && InterpreterUtil.isPrintableUnicode(c)) {
                        buffer.append(c);
                        continue block10;
                    }
                    buffer.append(InterpreterUtil.charToUnicodeLiteral(c));
                }
            }
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ConstExprent)) {
            return false;
        }
        ConstExprent cn = (ConstExprent)o;
        return InterpreterUtil.equalObjects(this.consttype, cn.getConsttype()) && InterpreterUtil.equalObjects(this.value, cn.getValue());
    }

    public boolean hasBooleanValue() {
        switch (this.consttype.type) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                Integer ival = (Integer)this.value;
                return ival == 0 || DecompilerContext.getOption("bto") && ival == 1;
            }
        }
        return false;
    }

    public boolean hasValueOne() {
        switch (this.consttype.type) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                return (Integer)this.value == 1;
            }
            case 5: {
                return ((Long)this.value).intValue() == 1;
            }
            case 2: {
                return ((Double)this.value).intValue() == 1;
            }
            case 3: {
                return ((Float)this.value).intValue() == 1;
            }
        }
        return false;
    }

    public static ConstExprent getZeroConstant(int type) {
        switch (type) {
            case 4: {
                return new ConstExprent(VarType.VARTYPE_INT, new Integer(0));
            }
            case 5: {
                return new ConstExprent(VarType.VARTYPE_LONG, new Long(0L));
            }
            case 2: {
                return new ConstExprent(VarType.VARTYPE_DOUBLE, new Double(0.0));
            }
            case 3: {
                return new ConstExprent(VarType.VARTYPE_FLOAT, new Float(0.0f));
            }
        }
        throw new RuntimeException("Invalid argument!");
    }

    public VarType getConsttype() {
        return this.consttype;
    }

    public void setConsttype(VarType consttype) {
        this.consttype = consttype;
    }

    public Object getValue() {
        return this.value;
    }

    public int getIntValue() {
        return (Integer)this.value;
    }

    public boolean isBoolPermitted() {
        return this.boolPermitted;
    }

    public void setBoolPermitted(boolean boolPermitted) {
        this.boolPermitted = boolPermitted;
    }

    static {
        escapes.put(new Integer(8), "\\b");
        escapes.put(new Integer(9), "\\t");
        escapes.put(new Integer(10), "\\n");
        escapes.put(new Integer(12), "\\f");
        escapes.put(new Integer(13), "\\r");
        escapes.put(new Integer(34), "\\\"");
        escapes.put(new Integer(39), "\\'");
        escapes.put(new Integer(92), "\\\\");
    }
}

