/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.attr.StructExceptionsAttribute;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class ExitExprent
extends Exprent {
    public static final int EXIT_RETURN = 0;
    public static final int EXIT_THROW = 1;
    private int exittype;
    private Exprent value;
    private VarType rettype;

    public ExitExprent(int exittype, Exprent value, VarType rettype) {
        this.type = 4;
        this.exittype = exittype;
        this.value = value;
        this.rettype = rettype;
    }

    @Override
    public Exprent copy() {
        return new ExitExprent(this.exittype, this.value == null ? null : this.value.copy(), this.rettype);
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        if (this.exittype == 0 && this.rettype.type != 10) {
            result.addMinTypeExprent(this.value, VarType.getMinTypeInFamily(this.rettype.type_family));
            result.addMaxTypeExprent(this.value, this.rettype);
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        if (this.value != null) {
            lst.add(this.value);
        }
        return lst;
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        StructExceptionsAttribute attr;
        tracer.addMapping(this.bytecode);
        if (this.exittype == 0) {
            StringBuilder buffer = new StringBuilder();
            if (this.rettype.type != 10) {
                buffer.append(" ");
                ExprProcessor.getCastedExprent(this.value, this.rettype, buffer, indent, false, tracer);
            }
            return "return" + buffer.toString();
        }
        MethodWrapper meth = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
        ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        if (meth != null && node != null && (attr = (StructExceptionsAttribute)meth.methodStruct.getAttributes().getWithKey("Exceptions")) != null) {
            String classname = null;
            for (int i = 0; i < attr.getThrowsExceptions().size(); ++i) {
                String excclassname = attr.getExcClassname(i, node.classStruct.getPool());
                if ("java/lang/Throwable".equals(excclassname)) {
                    classname = excclassname;
                    break;
                }
                if (!"java/lang/Exception".equals(excclassname)) continue;
                classname = excclassname;
            }
            if (classname != null) {
                VarType exctype = new VarType(classname, true);
                StringBuilder buffer = new StringBuilder();
                ExprProcessor.getCastedExprent(this.value, exctype, buffer, indent, false, tracer);
                return "throw " + buffer.toString();
            }
        }
        return "throw " + this.value.toJava(indent, tracer);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ExitExprent)) {
            return false;
        }
        ExitExprent et = (ExitExprent)o;
        return this.exittype == et.getExittype() && InterpreterUtil.equalObjects(this.value, et.getValue());
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        if (oldexpr == this.value) {
            this.value = newexpr;
        }
    }

    public int getExittype() {
        return this.exittype;
    }

    public Exprent getValue() {
        return this.value;
    }

    public VarType getRettype() {
        return this.rettype;
    }
}

