/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.sforms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SynchronizedStatement;

public class FlattenStatementsHelper {
    private Map<Integer, String[]> mapDestinationNodes = new HashMap<Integer, String[]>();
    private List<Edge> listEdges = new ArrayList<Edge>();
    private Map<String, List<String[]>> mapShortRangeFinallyPathIds = new HashMap<String, List<String[]>>();
    private Map<String, List<String[]>> mapLongRangeFinallyPathIds = new HashMap<String, List<String[]>>();
    private Map<String, Integer> mapPosIfBranch = new HashMap<String, Integer>();
    private DirectGraph graph;
    private RootStatement root;

    public DirectGraph buildDirectGraph(RootStatement root) {
        this.root = root;
        this.graph = new DirectGraph();
        this.flattenStatement();
        Statement dummyexit = root.getDummyExit();
        DirectNode node = new DirectNode(1, dummyexit, dummyexit.id.toString());
        node.exprents = new ArrayList<Exprent>();
        this.graph.nodes.addWithKey(node, node.id);
        this.mapDestinationNodes.put(dummyexit.id, new String[]{node.id, null});
        this.setEdges();
        this.graph.first = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(root.id)[0]);
        this.graph.sortReversePostOrder();
        return this.graph;
    }

    private void flattenStatement() {
        LinkedList<StatementStackEntry> lstStackStatements = new LinkedList<StatementStackEntry>();
        class StatementStackEntry {
            public Statement statement;
            public LinkedList<StackEntry> stackFinally;
            public List<Exprent> tailExprents;
            public int statementIndex;
            public int edgeIndex;
            public List<StatEdge> succEdges;

            public StatementStackEntry(Statement statement, LinkedList<StackEntry> stackFinally, List<Exprent> tailExprents) {
                this.statement = statement;
                this.stackFinally = stackFinally;
                this.tailExprents = tailExprents;
            }
        }
        lstStackStatements.add(new StatementStackEntry(this.root, new LinkedList<StackEntry>(), null));
        block15: while (!lstStackStatements.isEmpty()) {
            StatementStackEntry statEntry = (StatementStackEntry)lstStackStatements.removeFirst();
            Statement stat = statEntry.statement;
            LinkedList<StackEntry> stackFinally = statEntry.stackFinally;
            int statementBreakIndex = statEntry.statementIndex;
            List<Object> lstSuccEdges = new ArrayList();
            DirectNode sourcenode = null;
            if (statEntry.succEdges == null) {
                switch (stat.type) {
                    case 8: {
                        DirectNode node = new DirectNode(1, stat, (BasicBlockStatement)stat);
                        if (stat.getExprents() != null) {
                            node.exprents = stat.getExprents();
                        }
                        this.graph.nodes.putWithKey(node, node.id);
                        this.mapDestinationNodes.put(stat.id, new String[]{node.id, null});
                        lstSuccEdges.addAll(stat.getSuccessorEdges(0x40000000));
                        sourcenode = node;
                        List<Exprent> tailExprentList = statEntry.tailExprents;
                        if (tailExprentList != null) {
                            DirectNode tail = new DirectNode(2, stat, stat.id + "_tail");
                            tail.exprents = tailExprentList;
                            this.graph.nodes.putWithKey(tail, tail.id);
                            this.mapDestinationNodes.put(-stat.id.intValue(), new String[]{tail.id, null});
                            this.listEdges.add(new Edge(node.id, -stat.id.intValue(), 1));
                            sourcenode = tail;
                        }
                        if (stat.getLastBasicType() != 0) break;
                        this.mapPosIfBranch.put(sourcenode.id, ((StatEdge)lstSuccEdges.get((int)0)).getDestination().id);
                        break;
                    }
                    case 7: 
                    case 12: {
                        DirectNode firstnd = new DirectNode(6, stat, stat.id + "_try");
                        this.mapDestinationNodes.put(stat.id, new String[]{firstnd.id, null});
                        this.graph.nodes.putWithKey(firstnd, firstnd.id);
                        LinkedList<StatementStackEntry> lst = new LinkedList<StatementStackEntry>();
                        for (Statement st : stat.getStats()) {
                            this.listEdges.add(new Edge(firstnd.id, st.id, 1));
                            LinkedList<StackEntry> stack = stackFinally;
                            if (stat.type == 12 && ((CatchAllStatement)stat).isFinally()) {
                                stack = new LinkedList<StackEntry>(stackFinally);
                                if (st == stat.getFirst()) {
                                    stack.add(new StackEntry((CatchAllStatement)stat, Boolean.FALSE));
                                } else {
                                    stack.add(new StackEntry((CatchAllStatement)stat, Boolean.TRUE, 4, this.root.getDummyExit(), st, st, firstnd, firstnd, true));
                                }
                            }
                            lst.add(new StatementStackEntry(st, stack, null));
                        }
                        lstStackStatements.addAll(0, lst);
                        break;
                    }
                    case 5: {
                        DirectNode node;
                        if (statementBreakIndex == 0) {
                            statEntry.statementIndex = 1;
                            lstStackStatements.addFirst(statEntry);
                            lstStackStatements.addFirst(new StatementStackEntry(stat.getFirst(), stackFinally, null));
                            continue block15;
                        }
                        DirectNode nd = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(stat.getFirst().id)[0]);
                        DoStatement dostat = (DoStatement)stat;
                        int looptype = dostat.getLooptype();
                        if (looptype == 0) {
                            this.mapDestinationNodes.put(stat.id, new String[]{nd.id, nd.id});
                            break;
                        }
                        lstSuccEdges.add(stat.getSuccessorEdges(0x40000000).get(0));
                        switch (looptype) {
                            case 1: 
                            case 2: {
                                node = new DirectNode(4, stat, stat.id + "_cond");
                                node.exprents = dostat.getConditionExprentList();
                                this.graph.nodes.putWithKey(node, node.id);
                                this.listEdges.add(new Edge(node.id, stat.getFirst().id, 1));
                                if (looptype == 2) {
                                    this.mapDestinationNodes.put(stat.id, new String[]{node.id, node.id});
                                } else {
                                    this.mapDestinationNodes.put(stat.id, new String[]{nd.id, node.id});
                                    boolean found = false;
                                    for (Edge edge : this.listEdges) {
                                        if (!edge.statid.equals(stat.id) || edge.edgetype != 8) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        this.listEdges.add(new Edge(nd.id, stat.id, 8));
                                    }
                                }
                                sourcenode = node;
                                break;
                            }
                            case 3: {
                                DirectNode nodeinit = new DirectNode(3, stat, stat.id + "_init");
                                if (dostat.getInitExprent() != null) {
                                    nodeinit.exprents = dostat.getInitExprentList();
                                }
                                this.graph.nodes.putWithKey(nodeinit, nodeinit.id);
                                DirectNode nodecond = new DirectNode(4, stat, stat.id + "_cond");
                                nodecond.exprents = dostat.getConditionExprentList();
                                this.graph.nodes.putWithKey(nodecond, nodecond.id);
                                DirectNode nodeinc = new DirectNode(5, stat, stat.id + "_inc");
                                nodeinc.exprents = dostat.getIncExprentList();
                                this.graph.nodes.putWithKey(nodeinc, nodeinc.id);
                                this.mapDestinationNodes.put(stat.id, new String[]{nodeinit.id, nodeinc.id});
                                this.mapDestinationNodes.put(-stat.id.intValue(), new String[]{nodecond.id, null});
                                this.listEdges.add(new Edge(nodecond.id, stat.getFirst().id, 1));
                                this.listEdges.add(new Edge(nodeinit.id, -stat.id.intValue(), 1));
                                this.listEdges.add(new Edge(nodeinc.id, -stat.id.intValue(), 1));
                                boolean found = false;
                                for (Edge edge : this.listEdges) {
                                    if (!edge.statid.equals(stat.id) || edge.edgetype != 8) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    this.listEdges.add(new Edge(nd.id, stat.id, 8));
                                }
                                sourcenode = nodecond;
                            }
                        }
                        break;
                    }
                    case 2: 
                    case 6: 
                    case 10: 
                    case 13: 
                    case 15: {
                        int statsize = stat.getStats().size();
                        if (stat.type == 10) {
                            statsize = 2;
                        }
                        if (statementBreakIndex > statsize) break;
                        List<Exprent> tailexprlst = null;
                        switch (stat.type) {
                            case 10: {
                                tailexprlst = ((SynchronizedStatement)stat).getHeadexprentList();
                                break;
                            }
                            case 6: {
                                tailexprlst = ((SwitchStatement)stat).getHeadexprentList();
                                break;
                            }
                            case 2: {
                                tailexprlst = ((IfStatement)stat).getHeadexprentList();
                            }
                        }
                        int i = statementBreakIndex;
                        if (i < statsize) {
                            statEntry.statementIndex = i + 1;
                            lstStackStatements.addFirst(statEntry);
                            lstStackStatements.addFirst(new StatementStackEntry((Statement)stat.getStats().get(i), stackFinally, i == 0 && tailexprlst != null && tailexprlst.get(0) != null ? tailexprlst : null));
                            continue block15;
                        }
                        DirectNode node = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(stat.getFirst().id)[0]);
                        this.mapDestinationNodes.put(stat.id, new String[]{node.id, null});
                        if (stat.type != 2 || ((IfStatement)stat).iftype != IfStatement.IFTYPE_IF) break;
                        lstSuccEdges.add(stat.getSuccessorEdges(0x40000000).get(0));
                        DirectNode directNode = sourcenode = tailexprlst.get(0) == null ? node : this.graph.nodes.getWithKey(node.id + "_tail");
                    }
                }
            }
            if (sourcenode == null) continue;
            if (statEntry.succEdges != null) {
                lstSuccEdges = statEntry.succEdges;
            }
            for (int edgeindex = statEntry.edgeIndex; edgeindex < lstSuccEdges.size(); ++edgeindex) {
                boolean created;
                StatEdge edge = (StatEdge)lstSuccEdges.get(edgeindex);
                LinkedList<StackEntry> stack = new LinkedList<StackEntry>(stackFinally);
                int edgetype = edge.getType();
                Statement destination = edge.getDestination();
                DirectNode finallyShortRangeSource = sourcenode;
                DirectNode finallyLongRangeSource = sourcenode;
                Statement finallyShortRangeEntry = null;
                Statement finallyLongRangeEntry = null;
                boolean isFinallyMonitorExceptionPath = false;
                boolean isFinallyExit = false;
                do {
                    StackEntry entry = null;
                    if (!stack.isEmpty()) {
                        entry = stack.getLast();
                    }
                    created = true;
                    if (entry == null) {
                        this.saveEdge(sourcenode, destination, edgetype, isFinallyExit ? finallyShortRangeSource : null, finallyLongRangeSource, finallyShortRangeEntry, finallyLongRangeEntry, isFinallyMonitorExceptionPath);
                        continue;
                    }
                    CatchAllStatement catchall = entry.catchstatement;
                    if (entry.state) {
                        if (edgetype == 32) {
                            stack.removeLast();
                            destination = entry.destination;
                            edgetype = entry.edgetype;
                            finallyShortRangeSource = entry.finallyShortRangeSource;
                            finallyLongRangeSource = entry.finallyLongRangeSource;
                            finallyShortRangeEntry = entry.finallyShortRangeEntry;
                            finallyLongRangeEntry = entry.finallyLongRangeEntry;
                            isFinallyExit = true;
                            isFinallyMonitorExceptionPath = catchall.getMonitor() != null & entry.isFinallyExceptionPath;
                            created = false;
                            continue;
                        }
                        if (!catchall.containsStatementStrict(destination)) {
                            stack.removeLast();
                            created = false;
                            continue;
                        }
                        this.saveEdge(sourcenode, destination, edgetype, isFinallyExit ? finallyShortRangeSource : null, finallyLongRangeSource, finallyShortRangeEntry, finallyLongRangeEntry, isFinallyMonitorExceptionPath);
                        continue;
                    }
                    if (!catchall.containsStatementStrict(destination)) {
                        this.saveEdge(sourcenode, catchall.getHandler(), 1, isFinallyExit ? finallyShortRangeSource : null, finallyLongRangeSource, finallyShortRangeEntry, finallyLongRangeEntry, isFinallyMonitorExceptionPath);
                        stack.removeLast();
                        stack.add(new StackEntry(catchall, Boolean.TRUE, edgetype, destination, catchall.getHandler(), finallyLongRangeEntry == null ? catchall.getHandler() : finallyLongRangeEntry, sourcenode, finallyLongRangeSource, false));
                        statEntry.edgeIndex = edgeindex + 1;
                        statEntry.succEdges = lstSuccEdges;
                        lstStackStatements.addFirst(statEntry);
                        lstStackStatements.addFirst(new StatementStackEntry(catchall.getHandler(), stack, null));
                        continue block15;
                    }
                    this.saveEdge(sourcenode, destination, edgetype, isFinallyExit ? finallyShortRangeSource : null, finallyLongRangeSource, finallyShortRangeEntry, finallyLongRangeEntry, isFinallyMonitorExceptionPath);
                } while (!created);
            }
        }
    }

    private void saveEdge(DirectNode sourcenode, Statement destination, int edgetype, DirectNode finallyShortRangeSource, DirectNode finallyLongRangeSource, Statement finallyShortRangeEntry, Statement finallyLongRangeEntry, boolean isFinallyMonitorExceptionPath) {
        if (edgetype != 32) {
            this.listEdges.add(new Edge(sourcenode.id, destination.id, edgetype));
        }
        if (finallyShortRangeSource != null) {
            boolean isContinueEdge = edgetype == 8;
            List<String[]> lst = this.mapShortRangeFinallyPathIds.get(sourcenode.id);
            if (lst == null) {
                lst = new ArrayList<String[]>();
                this.mapShortRangeFinallyPathIds.put(sourcenode.id, lst);
            }
            lst.add(new String[]{finallyShortRangeSource.id, destination.id.toString(), finallyShortRangeEntry.id.toString(), isFinallyMonitorExceptionPath ? "1" : null, isContinueEdge ? "1" : null});
            lst = this.mapLongRangeFinallyPathIds.get(sourcenode.id);
            if (lst == null) {
                lst = new ArrayList<String[]>();
                this.mapLongRangeFinallyPathIds.put(sourcenode.id, lst);
            }
            lst.add(new String[]{finallyLongRangeSource.id, destination.id.toString(), finallyLongRangeEntry.id.toString(), isContinueEdge ? "1" : null});
        }
    }

    private void setEdges() {
        for (Edge edge : this.listEdges) {
            String sourceid = edge.sourceid;
            Integer statid = edge.statid;
            DirectNode source = this.graph.nodes.getWithKey(sourceid);
            DirectNode dest = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(statid)[edge.edgetype == 8 ? 1 : 0]);
            if (!source.succs.contains(dest)) {
                source.succs.add(dest);
            }
            if (!dest.preds.contains(source)) {
                dest.preds.add(source);
            }
            if (!this.mapPosIfBranch.containsKey(sourceid) || statid.equals(this.mapPosIfBranch.get(sourceid))) continue;
            this.graph.mapNegIfBranch.put(sourceid, dest.id);
        }
        for (int i = 0; i < 2; ++i) {
            for (Map.Entry<String, List<String[]>> ent : (i == 0 ? this.mapShortRangeFinallyPathIds : this.mapLongRangeFinallyPathIds).entrySet()) {
                ArrayList<FinallyPathWrapper> newLst = new ArrayList<FinallyPathWrapper>();
                List<String[]> lst = ent.getValue();
                for (String[] arr : lst) {
                    boolean isContinueEdge = arr[i == 0 ? 4 : 3] != null;
                    DirectNode dest = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(Integer.parseInt(arr[1]))[isContinueEdge ? 1 : 0]);
                    DirectNode enter = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(Integer.parseInt(arr[2]))[0]);
                    newLst.add(new FinallyPathWrapper(arr[0], dest.id, enter.id));
                    if (i != 0 || arr[3] == null) continue;
                    this.graph.mapFinallyMonitorExceptionPathExits.put(ent.getKey(), dest.id);
                }
                if (newLst.isEmpty()) continue;
                (i == 0 ? this.graph.mapShortRangeFinallyPaths : this.graph.mapLongRangeFinallyPaths).put(ent.getKey(), new ArrayList(new HashSet(newLst)));
            }
        }
    }

    public Map<Integer, String[]> getMapDestinationNodes() {
        return this.mapDestinationNodes;
    }

    private static class Edge {
        public String sourceid;
        public Integer statid;
        public int edgetype;

        public Edge(String sourceid, Integer statid, int edgetype) {
            this.sourceid = sourceid;
            this.statid = statid;
            this.edgetype = edgetype;
        }
    }

    private static class StackEntry {
        public CatchAllStatement catchstatement;
        public boolean state;
        public int edgetype;
        public boolean isFinallyExceptionPath;
        public Statement destination;
        public Statement finallyShortRangeEntry;
        public Statement finallyLongRangeEntry;
        public DirectNode finallyShortRangeSource;
        public DirectNode finallyLongRangeSource;

        public StackEntry(CatchAllStatement catchstatement, boolean state, int edgetype, Statement destination, Statement finallyShortRangeEntry, Statement finallyLongRangeEntry, DirectNode finallyShortRangeSource, DirectNode finallyLongRangeSource, boolean isFinallyExceptionPath) {
            this.catchstatement = catchstatement;
            this.state = state;
            this.edgetype = edgetype;
            this.isFinallyExceptionPath = isFinallyExceptionPath;
            this.destination = destination;
            this.finallyShortRangeEntry = finallyShortRangeEntry;
            this.finallyLongRangeEntry = finallyLongRangeEntry;
            this.finallyShortRangeSource = finallyShortRangeSource;
            this.finallyLongRangeSource = finallyLongRangeSource;
        }

        public StackEntry(CatchAllStatement catchstatement, boolean state) {
            this(catchstatement, state, -1, null, null, null, null, null, false);
        }
    }

    public static class FinallyPathWrapper {
        public String source;
        public String destination;
        public String entry;

        private FinallyPathWrapper(String source, String destination, String entry) {
            this.source = source;
            this.destination = destination;
            this.entry = entry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof FinallyPathWrapper)) {
                return false;
            }
            FinallyPathWrapper fpw = (FinallyPathWrapper)o;
            return (this.source + ":" + this.destination + ":" + this.entry).equals(fpw.source + ":" + fpw.destination + ":" + fpw.entry);
        }

        public int hashCode() {
            return (this.source + ":" + this.destination + ":" + this.entry).hashCode();
        }

        public String toString() {
            return this.source + "->(" + this.entry + ")->" + this.destination;
        }
    }
}

