/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import com.intellij.openapi.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructLineNumberTableAttribute
extends StructGeneralAttribute {
    private List<Pair<Integer, Integer>> myLineInfo = Collections.emptyList();

    @Override
    public void initContent(ConstantPool pool) throws IOException {
        DataInputFullStream data = this.stream();
        int len = data.readUnsignedShort();
        if (len > 0) {
            this.myLineInfo = new ArrayList<Pair<Integer, Integer>>(len);
            for (int i = 0; i < len; ++i) {
                int startPC = data.readUnsignedShort();
                int lineNumber = data.readUnsignedShort();
                this.myLineInfo.add((Pair<Integer, Integer>)Pair.create((Object)startPC, (Object)lineNumber));
            }
        } else {
            this.myLineInfo = Collections.emptyList();
        }
    }

    public int getFirstLine() {
        if (!this.myLineInfo.isEmpty()) {
            return (Integer)this.myLineInfo.get(0).getSecond();
        }
        return -1;
    }

    public int findLineNumber(int pc) {
        for (Pair<Integer, Integer> pair : this.myLineInfo) {
            if (pc < (Integer)pair.getFirst()) continue;
            return (Integer)pair.getSecond();
        }
        return -1;
    }
}

