/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.java.decompiler.main.DecompilerContext;

public class InterpreterUtil {
    public static final boolean IS_WINDOWS = System.getProperty("os.name", "").startsWith("Windows");
    private static final int CHANNEL_WINDOW_SIZE = IS_WINDOWS ? 67076096 : 0x4000000;
    private static final int BUFFER_SIZE = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File in, File out) throws IOException {
        FileInputStream inStream = new FileInputStream(in);
        try {
            FileOutputStream outStream = new FileOutputStream(out);
            try {
                FileChannel inChannel = inStream.getChannel();
                FileChannel outChannel = outStream.getChannel();
                long size = inChannel.size();
                for (long position = 0L; position < size; position += inChannel.transferTo(position, CHANNEL_WINDOW_SIZE, outChannel)) {
                }
            }
            finally {
                outStream.close();
            }
        }
        finally {
            inStream.close();
        }
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[16384];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
    }

    public static byte[] getBytes(ZipFile archive, ZipEntry entry) throws IOException {
        return InterpreterUtil.readAndClose(archive.getInputStream(entry), (int)entry.getSize());
    }

    public static byte[] getBytes(File file) throws IOException {
        return InterpreterUtil.readAndClose(new FileInputStream(file), (int)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readAndClose(InputStream stream, int length) throws IOException {
        try {
            int count;
            byte[] bytes = new byte[length];
            int off = 0;
            for (int n = 0; n < length; n += count) {
                count = stream.read(bytes, off + n, length - n);
                if (count >= 0) continue;
                throw new IOException("premature end of stream");
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            stream.close();
        }
    }

    public static String getIndentString(int length) {
        if (length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        InterpreterUtil.appendIndent(buf, length);
        return buf.toString();
    }

    public static void appendIndent(StringBuilder buffer, int length) {
        if (length == 0) {
            return;
        }
        String indent = (String)DecompilerContext.getProperty("ind");
        while (length-- > 0) {
            buffer.append(indent);
        }
    }

    public static boolean equalSets(Collection<?> c1, Collection<?> c2) {
        if (c1 == null) {
            return c2 == null;
        }
        if (c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        HashSet set = new HashSet(c1);
        set.removeAll(c2);
        return set.size() == 0;
    }

    public static boolean equalObjects(Object first, Object second) {
        return first == null ? second == null : first.equals(second);
    }

    public static boolean equalObjectArrays(Object[] first, Object[] second) {
        if (first == null || second == null) {
            return InterpreterUtil.equalObjects(first, second);
        }
        if (first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (InterpreterUtil.equalObjects(first[i], second[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalLists(List<?> first, List<?> second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        if (first.size() == second.size()) {
            for (int i = 0; i < first.size(); ++i) {
                if (InterpreterUtil.equalObjects(first.get(i), second.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    public static String charToUnicodeLiteral(int value) {
        String sTemp = Integer.toHexString(value);
        sTemp = ("0000" + sTemp).substring(sTemp.length());
        return "\\u" + sTemp;
    }

    public static String makeUniqueKey(String name, String descriptor) {
        return name + " " + descriptor;
    }
}

