/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsReferenceableElement;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsElementCollectionImpl;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryReferenceImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootRole;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsLibraryImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsLibraryImpl<P>>
implements JpsTypedLibrary<P> {
    private final JpsLibraryType<P> myLibraryType;
    private static final Set<String> AR_EXTENSIONS = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY, (Object[])new String[]{"jar", "zip", "swc", "ane"});

    public JpsLibraryImpl(@NotNull String name, @NotNull JpsLibraryType<P> type, @NotNull P properties) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "<init>"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "<init>"));
        }
        super(name);
        this.myLibraryType = type;
        this.myContainer.setChild(this.myLibraryType.getPropertiesRole(), properties);
    }

    private JpsLibraryImpl(@NotNull JpsLibraryImpl<P> original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "<init>"));
        }
        super(original);
        this.myLibraryType = original.myLibraryType;
    }

    @NotNull
    public JpsLibraryType<P> getType() {
        JpsLibraryType<P> jpsLibraryType = this.myLibraryType;
        if (jpsLibraryType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "getType"));
        }
        return jpsLibraryType;
    }

    @Nullable
    public <P extends JpsElement> JpsTypedLibrary<P> asTyped(@NotNull JpsLibraryType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "asTyped"));
        }
        return this.myLibraryType.equals(type) ? this : null;
    }

    @NotNull
    public P getProperties() {
        JpsElement jpsElement = this.myContainer.getChild(this.myLibraryType.getPropertiesRole());
        if (jpsElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "getProperties"));
        }
        return (P)jpsElement;
    }

    @NotNull
    public List<JpsLibraryRoot> getRoots(@NotNull JpsOrderRootType rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "getRoots"));
        }
        JpsElementCollection rootsCollection = (JpsElementCollection)this.myContainer.getChild(JpsLibraryImpl.getRole(rootType));
        List list = rootsCollection != null ? rootsCollection.getElements() : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "getRoots"));
        }
        return list;
    }

    public void addRoot(@NotNull String url, @NotNull JpsOrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "addRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "addRoot"));
        }
        this.addRoot(url, rootType, JpsLibraryRoot.InclusionOptions.ROOT_ITSELF);
    }

    public void addRoot(@NotNull File file, @NotNull JpsOrderRootType rootType) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "addRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "addRoot"));
        }
        this.addRoot(JpsPathUtil.getLibraryRootUrl((File)file), rootType);
    }

    public void addRoot(@NotNull String url, @NotNull JpsOrderRootType rootType, @NotNull JpsLibraryRoot.InclusionOptions options) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "addRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "addRoot"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "addRoot"));
        }
        ((JpsElementCollection)this.myContainer.getOrSetChild(JpsLibraryImpl.getRole(rootType))).addChild((JpsElement)new JpsLibraryRootImpl(url, rootType, options));
    }

    public void removeUrl(@NotNull String url, @NotNull JpsOrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "removeUrl"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "removeUrl"));
        }
        JpsElementCollection rootsCollection = (JpsElementCollection)this.myContainer.getChild(JpsLibraryImpl.getRole(rootType));
        if (rootsCollection != null) {
            for (JpsLibraryRoot root : rootsCollection.getElements()) {
                if (!root.getUrl().equals(url) || !root.getRootType().equals(rootType)) continue;
                rootsCollection.removeChild((JpsElement)root);
                break;
            }
        }
    }

    private static JpsElementCollectionRole<JpsLibraryRoot> getRole(JpsOrderRootType type) {
        return JpsElementCollectionRole.create((JpsElementChildRole)new JpsLibraryRootRole(type));
    }

    public void delete() {
        this.getParent().removeChild(this);
    }

    public JpsElementCollectionImpl<JpsLibrary> getParent() {
        return (JpsElementCollectionImpl)this.myParent;
    }

    @NotNull
    public JpsLibraryImpl<P> createCopy() {
        JpsLibraryImpl<P> jpsLibraryImpl = new JpsLibraryImpl<P>(this);
        if (jpsLibraryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "createCopy"));
        }
        return jpsLibraryImpl;
    }

    @NotNull
    public JpsLibraryReference createReference() {
        JpsLibraryReferenceImpl jpsLibraryReferenceImpl = new JpsLibraryReferenceImpl(this.getName(), this.createParentReference());
        if (jpsLibraryReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryImpl", "createReference"));
        }
        return jpsLibraryReferenceImpl;
    }

    private JpsElementReference<JpsCompositeElement> createParentReference() {
        return ((JpsReferenceableElement)this.getParent().getParent()).createReference();
    }

    public List<File> getFiles(JpsOrderRootType rootType) {
        List<String> urls = this.getRootUrls(rootType);
        ArrayList<File> files = new ArrayList<File>(urls.size());
        for (String url : urls) {
            files.add(JpsPathUtil.urlToFile((String)url));
        }
        return files;
    }

    public List<String> getRootUrls(JpsOrderRootType rootType) {
        ArrayList<String> urls = new ArrayList<String>();
        for (JpsLibraryRoot root : this.getRoots(rootType)) {
            switch (root.getInclusionOptions()) {
                case ROOT_ITSELF: {
                    urls.add(root.getUrl());
                    break;
                }
                case ARCHIVES_UNDER_ROOT: {
                    JpsLibraryImpl.collectArchives(JpsPathUtil.urlToFile((String)root.getUrl()), false, urls);
                    break;
                }
                case ARCHIVES_UNDER_ROOT_RECURSIVELY: {
                    JpsLibraryImpl.collectArchives(JpsPathUtil.urlToFile((String)root.getUrl()), true, urls);
                }
            }
        }
        return urls;
    }

    private static void collectArchives(File file, boolean recursively, List<String> result) {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                String extension = FileUtilRt.getExtension((String)child.getName());
                if (child.isDirectory()) {
                    if (!recursively) continue;
                    JpsLibraryImpl.collectArchives(child, recursively, result);
                    continue;
                }
                if (!AR_EXTENSIONS.contains(extension)) continue;
                result.add(JpsPathUtil.getLibraryRootUrl((File)child));
            }
        }
    }
}

