/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.javadoc;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.resources.FrameworkResources;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemResolver;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.ResourceFolderRegistry;
import com.android.tools.idea.rendering.ResourceFolderRepository;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.android.AndroidColorAnnotator;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaDocRenderer {
    private static final int MASK_NORMAL = 0;
    private static final int MASK_FLAVOR_SELECTED = 1;
    private static final int MASK_ITEM_HIDDEN = 2;

    @Nullable
    public static String render(@NotNull Module module, @NotNull ResourceType type, @NotNull String name, boolean framework) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer", "render"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer", "render"));
        }
        return AndroidJavaDocRenderer.render(module, ResourceUrl.create((ResourceType)type, (String)name, (boolean)framework, (boolean)false));
    }

    @Nullable
    public static String render(@NotNull Module module, @NotNull ResourceUrl url) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer", "render"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer", "render"));
        }
        ResourceValueRenderer renderer = ResourceValueRenderer.create(url.type, module);
        boolean framework = url.framework;
        if (renderer == null || framework && renderer.getFrameworkResources() == null || !framework && renderer.getAppResources() == null) {
            return null;
        }
        return renderer.render(url);
    }

    @Nullable
    public static String injectExternalDocumentation(@Nullable String rendered, @Nullable String external) {
        int bodyEnd;
        if (rendered == null) {
            return external;
        }
        if (external == null) {
            return rendered;
        }
        external = external.replace("<HTML>", "").replace("</HTML>", "");
        int styleStart = external.indexOf("<style");
        int styleEnd = external.indexOf("</style>");
        if (styleStart != -1 && styleEnd != -1) {
            String style = external.substring(styleStart, styleEnd + "</style>".length());
            external = external.substring(0, styleStart) + external.substring(styleEnd + "</style>".length());
            int insert = rendered.indexOf("<body>");
            if (insert != -1) {
                int headEnd = rendered.lastIndexOf("</head>", insert);
                if (headEnd != -1) {
                    insert = headEnd;
                    rendered = rendered.substring(0, insert) + style + rendered.substring(insert);
                } else {
                    rendered = rendered.substring(0, insert) + "<head>" + style + "</head>" + rendered.substring(insert);
                }
            }
        }
        if ((bodyEnd = rendered.indexOf("</body>")) != -1) {
            rendered = rendered.substring(0, bodyEnd) + external + rendered.substring(bodyEnd);
        }
        return rendered;
    }

    private static boolean haveFlavors(List<ItemInfo> items) {
        for (ItemInfo info : items) {
            if (info.flavor == null) continue;
            return true;
        }
        return false;
    }

    private static void markHidden(List<ItemInfo> items) {
        HashSet hiddenQualifiers = Sets.newHashSet();
        for (ItemInfo info : items) {
            String folder = info.folder;
            if (hiddenQualifiers.contains(folder)) {
                info.displayMask |= 2;
            }
            hiddenQualifiers.add(folder);
        }
    }

    private static String renderFolderName(String name) {
        String prefix = "values";
        if (name.equals(prefix)) {
            return "Default";
        }
        if (name.startsWith(prefix + '-')) {
            return name.substring(prefix.length() + 1);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Dimension getSize(File file) {
        try {
            ImageInputStream input = ImageIO.createImageInputStream(file);
            if (input != null) {
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
                    if (readers.hasNext()) {
                        ImageReader reader = readers.next();
                        try {
                            reader.setInput(input);
                            Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                            reader.dispose();
                            return dimension;
                        }
                        catch (Throwable throwable) {
                            reader.dispose();
                            throw throwable;
                        }
                    }
                }
                finally {
                    input.close();
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class ItemInfo
    implements Comparable<ItemInfo> {
        @Nullable
        public final ResourceValue value;
        @NotNull
        public final FolderConfiguration configuration;
        @Nullable
        public final String flavor;
        @NotNull
        public final String folder;
        public final int rank;
        public int displayMask;

        private ItemInfo(@Nullable ResourceValue value, @NotNull FolderConfiguration configuration, @NotNull String folder, @Nullable String flavor, int rank, int initialMask) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ItemInfo", "<init>"));
            }
            if (folder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ItemInfo", "<init>"));
            }
            this.value = value;
            this.configuration = configuration;
            this.flavor = flavor;
            this.folder = folder;
            this.displayMask = initialMask;
            this.rank = rank;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemInfo itemInfo = (ItemInfo)o;
            if (this.rank != itemInfo.rank) {
                return false;
            }
            if (!this.configuration.equals((Object)itemInfo.configuration)) {
                return false;
            }
            if (this.flavor != null ? !this.flavor.equals(itemInfo.flavor) : itemInfo.flavor != null) {
                return false;
            }
            if (!this.folder.equals(itemInfo.folder)) {
                return false;
            }
            return !(this.value != null ? !this.value.equals((Object)itemInfo.value) : itemInfo.value != null);
        }

        public int hashCode() {
            int result = this.value != null ? this.value.hashCode() : 0;
            result = 31 * result + this.configuration.hashCode();
            result = 31 * result + (this.flavor != null ? this.flavor.hashCode() : 0);
            result = 31 * result + this.folder.hashCode();
            result = 31 * result + this.rank;
            return result;
        }

        @Override
        public int compareTo(@NotNull ItemInfo other) {
            int delta;
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ItemInfo", "compareTo"));
            }
            if (this.rank != other.rank) {
                return this.rank - other.rank;
            }
            DensityQualifier density1 = this.configuration.getDensityQualifier();
            DensityQualifier density2 = other.configuration.getDensityQualifier();
            if (density1 != null && density2 != null && (delta = density2.getValue().compareTo((Enum)density1.getValue())) != 0) {
                return delta;
            }
            return this.configuration.compareTo(other.configuration);
        }
    }

    private static class ColorValueRenderer
    extends ResourceValueRenderer {
        private ColorValueRenderer(Module module) {
            super(module);
        }

        @Override
        @Nullable
        protected Color resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value, @NotNull ResourceUrl url) {
            if (resolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ColorValueRenderer", "resolveValue"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ColorValueRenderer", "resolveValue"));
            }
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList((List)Lists.newArrayList());
            return ResourceHelper.resolveColor((RenderResources)resolver, value);
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ColorValueRenderer", "renderToHtml"));
            }
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ColorValueRenderer", "renderToHtml"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ColorValueRenderer", "renderToHtml"));
            }
            ResourceItemResolver resolver = this.createResolver(item);
            Color color = this.resolveValue(resolver, resourceValue, url);
            if (color != null) {
                int width = 200;
                int height = 100;
                if (this.mySmall) {
                    int divisor = 3;
                    width /= divisor;
                    height /= divisor;
                }
                String colorString = String.format(Locale.US, "rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
                String foregroundColor = ColorUtil.isDark((Color)color) ? "white" : "black";
                String css = "background-color:" + colorString + ";color:" + foregroundColor + ";width:" + width + "px;text-align:center;vertical-align:middle;";
                builder.addHtml("<table style=\"" + css + "\" border=\"0\"><tr height=\"" + height + "\">");
                builder.addHtml("<td align=\"center\" valign=\"middle\" height=\"" + height + "\">");
                builder.addHtml("#");
                int alpha = color.getAlpha();
                if (alpha != 255) {
                    String alphaString = Integer.toHexString(alpha);
                    builder.addHtml((alphaString.length() < 2 ? "0" : "") + alphaString);
                }
                builder.addHtml(ColorUtil.toHex((Color)color));
                builder.addHtml("</td></tr></table>");
            } else if (item.value != null && item.value.getValue() != null) {
                builder.add(item.value.getValue());
            }
            if (showResolution) {
                List lookupChain = resolver.getLookupChain();
                assert (lookupChain != null);
                this.displayChain(url, lookupChain, builder, true, false);
            }
        }
    }

    private static class DrawableValueRenderer
    extends ResourceValueRenderer {
        private DrawableValueRenderer(Module module) {
            super(module);
        }

        @Override
        @Nullable
        protected File resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value, @NotNull ResourceUrl url) {
            if (resolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$DrawableValueRenderer", "resolveValue"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$DrawableValueRenderer", "resolveValue"));
            }
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList((List)Lists.newArrayList());
            return ResourceHelper.resolveDrawable((RenderResources)resolver, value);
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$DrawableValueRenderer", "renderToHtml"));
            }
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$DrawableValueRenderer", "renderToHtml"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$DrawableValueRenderer", "renderToHtml"));
            }
            ResourceItemResolver resolver = this.createResolver(item);
            File bitmap = this.resolveValue(resolver, resourceValue, url);
            if (bitmap != null && bitmap.exists() && AndroidUtils.hasImageExtension(bitmap.getPath())) {
                URL fileUrl = null;
                try {
                    fileUrl = SdkUtils.fileToUrl((File)bitmap);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                if (fileUrl != null) {
                    builder.beginDiv("background-color:gray;padding:10px");
                    builder.addImage(fileUrl, bitmap.getPath());
                    builder.endDiv();
                    Dimension size = AndroidJavaDocRenderer.getSize(bitmap);
                    if (size != null) {
                        DensityQualifier densityQualifier = item.configuration.getDensityQualifier();
                        Density density = densityQualifier == null ? Density.MEDIUM : densityQualifier.getValue();
                        builder.addHtml(String.format(Locale.US, "%1$d&#xd7;%2$d px (%3$d&#xd7;%4$d dp @ %5$s)", size.width, size.height, DrawableValueRenderer.px2dp(size.width, density), DrawableValueRenderer.px2dp(size.height, density), density.getResourceValue()));
                    }
                }
            } else if (bitmap != null) {
                builder.add(bitmap.getPath());
            }
            if (showResolution) {
                List lookupChain = resolver.getLookupChain();
                assert (lookupChain != null);
                this.displayChain(url, lookupChain, builder, true, false);
            }
        }

        private static int px2dp(int px, Density density) {
            return (int)((float)px * (float)Density.MEDIUM.getDpiValue() / (float)density.getDpiValue());
        }
    }

    private static class ArrayRenderer
    extends ResourceValueRenderer {
        private ArrayRenderer(Module module) {
            super(module);
        }

        @Override
        @Nullable
        protected Object resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value, @NotNull ResourceUrl url) {
            if (resolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ArrayRenderer", "resolveValue"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ArrayRenderer", "resolveValue"));
            }
            if (value != null) {
                assert (resolver.getLookupChain() != null);
                resolver.setLookupChainList((List)Lists.newArrayList());
                return resolver.resolveResValue(value);
            }
            return null;
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ArrayRenderer", "renderToHtml"));
            }
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ArrayRenderer", "renderToHtml"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ArrayRenderer", "renderToHtml"));
            }
            ResourceItemResolver resolver = this.createResolver(item);
            Object value = this.resolveValue(resolver, resourceValue, url);
            if (value instanceof ArrayResourceValue) {
                ArrayResourceValue arv = (ArrayResourceValue)value;
                builder.add(Joiner.on((String)", ").skipNulls().join((Iterable)arv));
            } else if (value != null) {
                builder.add(value.toString());
            }
            if (showResolution) {
                List lookupChain = resolver.getLookupChain();
                assert (lookupChain != null);
                if (lookupChain.size() > 1) {
                    this.displayChain(url, lookupChain, builder, true, false);
                }
            }
        }
    }

    private static class TextValueRenderer
    extends ResourceValueRenderer {
        private TextValueRenderer(Module module) {
            super(module);
        }

        @Override
        @Nullable
        protected String resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue value, @NotNull ResourceUrl url) {
            if (resolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$TextValueRenderer", "resolveValue"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$TextValueRenderer", "resolveValue"));
            }
            return (String)super.resolveValue(resolver, value, url);
        }

        @Override
        public void renderToHtml(@NotNull HtmlBuilder builder, @NotNull ItemInfo item, @NotNull ResourceUrl url, boolean showResolution, @Nullable ResourceValue resourceValue) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$TextValueRenderer", "renderToHtml"));
            }
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$TextValueRenderer", "renderToHtml"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$TextValueRenderer", "renderToHtml"));
            }
            ResourceItemResolver resolver = this.createResolver(item);
            String value = this.resolveValue(resolver, resourceValue, url);
            List lookupChain = resolver.getLookupChain();
            if (value != null) {
                boolean found = false;
                if (url.theme) {
                    File f;
                    ResourceValue resolved;
                    ResourceValueRenderer renderer;
                    if (value.startsWith("#")) {
                        Color color = ResourceHelper.parseColor(value);
                        if (color != null) {
                            found = true;
                            renderer = ResourceValueRenderer.create(ResourceType.COLOR, this.myModule);
                            assert (renderer != null);
                            resolved = new ResourceValue(url.type, url.name, url.framework);
                            resolved.setValue(value);
                            renderer.renderToHtml(builder, item, url, false, resolved);
                            builder.newline();
                        }
                    } else if (value.endsWith(".png") && (f = new File(value)).exists()) {
                        found = true;
                        renderer = ResourceValueRenderer.create(ResourceType.DRAWABLE, this.myModule);
                        assert (renderer != null);
                        resolved = new ResourceValue(url.type, url.name, url.framework);
                        resolved.setValue(value);
                        renderer.renderToHtml(builder, item, url, false, resolved);
                        builder.newline();
                    }
                    if (!found) {
                        assert (lookupChain != null);
                        for (int i = lookupChain.size() - 1; i >= 0; --i) {
                            ResourceValueRenderer renderer2;
                            ResourceUrl resourceUrl;
                            String value2;
                            ResourceValue rv = (ResourceValue)lookupChain.get(i);
                            if (rv == null || (value2 = rv.getValue()) == null || (resourceUrl = ResourceUrl.parse((String)value2)) == null || resourceUrl.theme || (renderer2 = TextValueRenderer.create(resourceUrl.type, this.myModule)) == null || renderer2.getClass() == this.getClass()) continue;
                            found = true;
                            ResourceValue resolved2 = new ResourceValue(url.type, url.name, url.framework);
                            resolved2.setValue(value);
                            renderer2.renderToHtml(builder, item, resourceUrl, false, resolved2);
                            builder.newline();
                            break;
                        }
                    }
                }
                if (!(found || showResolution && lookupChain != null && !lookupChain.isEmpty())) {
                    builder.add(value);
                }
            } else if (item.value != null && item.value.getValue() != null) {
                builder.add(item.value.getValue());
            }
            if (showResolution) {
                ResourceValue rv;
                assert (lookupChain != null);
                this.displayChain(url, lookupChain, builder, true, true);
                if (!lookupChain.isEmpty() && (rv = (ResourceValue)lookupChain.get(lookupChain.size() - 1)) instanceof StyleResourceValue) {
                    StyleResourceValue srv = (StyleResourceValue)rv;
                    this.displayStyleValues(builder, item, resolver, srv);
                }
            }
        }

        private void displayStyleValues(HtmlBuilder builder, ItemInfo item, ResourceItemResolver resolver, StyleResourceValue styleValue) {
            List lookupChain = resolver.getLookupChain();
            builder.addHtml("<hr>");
            builder.addBold(styleValue.getName()).add(":").newline();
            HashSet masked = Sets.newHashSet();
            while (styleValue != null) {
                for (ItemResourceValue itemResourceValue : styleValue.getValues()) {
                    String name = itemResourceValue.getName();
                    if (masked.contains(name)) continue;
                    masked.add(name);
                    ItemResourceValue v = styleValue.getItem(name, itemResourceValue.isFrameworkAttr());
                    String value = v != null ? v.getValue() : null;
                    builder.addNbsps(4);
                    if (itemResourceValue.isFrameworkAttr()) {
                        builder.add("android:");
                    }
                    builder.addBold(name).add(" = ").add(v != null ? v.getValue() : "null");
                    if (v != null && v.getValue() != null) {
                        ResourceUrl url = ResourceUrl.parse((String)v.getValue());
                        if (url != null) {
                            ResourceValueRenderer renderer;
                            ResourceUrl resolvedUrl = url;
                            int count = 0;
                            while (resolvedUrl != null) {
                                if (lookupChain != null) {
                                    lookupChain.clear();
                                }
                                boolean framework = resolvedUrl.framework || styleValue.isFramework();
                                ResourceValue resourceValue = resolvedUrl.theme ? resolver.findItemInTheme(resolvedUrl.name, framework) : resolver.findResValue(resolvedUrl.toString(), framework);
                                if (resourceValue == null || resourceValue.getValue() == null) break;
                                url = resolvedUrl;
                                value = resourceValue.getValue();
                                resolvedUrl = ResourceUrl.parse((String)value);
                                if (count++ != 50) continue;
                                break;
                            }
                            if ((renderer = TextValueRenderer.create(url.type, this.myModule)) != null && renderer.getClass() != this.getClass()) {
                                builder.newline();
                                renderer.setSmall(true);
                                ResourceValue resolved = new ResourceValue(url.type, url.name, url.framework);
                                resolved.setValue(value);
                                renderer.renderToHtml(builder, item, url, false, resolved);
                                continue;
                            }
                            if (value == null) continue;
                            builder.add(" => ");
                            builder.add(value);
                            builder.newline();
                            continue;
                        }
                        builder.newline();
                        continue;
                    }
                    builder.newline();
                }
                if ((styleValue = resolver.getParent(styleValue)) == null) continue;
                builder.newline();
                builder.add("Inherits from: ").add(ResourceUrl.create((ResourceValue)styleValue).toString()).add(":").newline();
            }
        }
    }

    private static abstract class ResourceValueRenderer
    implements ResourceItemResolver.ResourceProvider {
        protected final Module myModule;
        protected FrameworkResources myFrameworkResources;
        protected AppResourceRepository myAppResources;
        protected ResourceResolver myResourceResolver;
        protected boolean mySmall;

        protected ResourceValueRenderer(Module module) {
            this.myModule = module;
        }

        public void setSmall(boolean small) {
            this.mySmall = small;
        }

        public abstract void renderToHtml(@NotNull HtmlBuilder var1, @NotNull ItemInfo var2, @NotNull ResourceUrl var3, boolean var4, @Nullable ResourceValue var5);

        @Nullable
        public static ResourceValueRenderer create(@NotNull ResourceType type, @NotNull Module module) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "create"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "create"));
            }
            switch (type) {
                case ATTR: 
                case STRING: 
                case DIMEN: 
                case INTEGER: 
                case BOOL: {
                    return new TextValueRenderer(module);
                }
                case ARRAY: {
                    return new ArrayRenderer(module);
                }
                case DRAWABLE: {
                    return new DrawableValueRenderer(module);
                }
                case COLOR: {
                    return new ColorValueRenderer(module);
                }
            }
            return null;
        }

        @Nullable
        private static FrameworkResources getFrameworkResources(Module module) {
            AndroidTargetData targetData;
            AndroidPlatform platform = AndroidPlatform.getPlatform(module);
            if (platform != null && (targetData = AndroidTargetData.getTargetData(platform.getTarget(), module)) != null) {
                try {
                    return targetData.getFrameworkResources();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Nullable
        public String render(@NotNull ResourceUrl url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "render"));
            }
            List<ItemInfo> items = this.gatherItems(url);
            if (items != null) {
                Collections.sort(items);
                return this.renderKeyValues(items, url);
            }
            return null;
        }

        @Nullable
        private List<ItemInfo> gatherItems(@NotNull ResourceUrl url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "gatherItems"));
            }
            ResourceType type = url.type;
            String resourceName = url.name;
            boolean framework = url.framework;
            if (framework) {
                ArrayList results = Lists.newArrayList();
                this.addItemsFromFramework(null, 0, 0, type, resourceName, results);
                return results;
            }
            AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
            if (facet == null) {
                return null;
            }
            ArrayList results = Lists.newArrayList();
            AppResourceRepository resources = this.getAppResources();
            IdeaAndroidProject ideaAndroidProject = facet.getIdeaAndroidProject();
            if (ideaAndroidProject != null) {
                assert (facet.isGradleProject());
                AndroidProject delegate = ideaAndroidProject.getDelegate();
                Variant selectedVariant = ideaAndroidProject.getSelectedVariant();
                HashSet selectedProviders = Sets.newHashSet();
                BuildTypeContainer buildType = ideaAndroidProject.findBuildType(selectedVariant.getBuildType());
                assert (buildType != null);
                SourceProvider sourceProvider = buildType.getSourceProvider();
                String buildTypeName = selectedVariant.getName();
                int rank = 0;
                ResourceValueRenderer.addItemsFromSourceSet(buildTypeName, 1, rank++, sourceProvider, type, resourceName, results, facet);
                selectedProviders.add(sourceProvider);
                List productFlavors = selectedVariant.getProductFlavors();
                for (int i = productFlavors.size() - 1; i >= 0; --i) {
                    String flavorName = (String)productFlavors.get(i);
                    ProductFlavorContainer productFlavor = ideaAndroidProject.findProductFlavor(flavorName);
                    assert (productFlavor != null);
                    SourceProvider provider = productFlavor.getSourceProvider();
                    ResourceValueRenderer.addItemsFromSourceSet(flavorName, 1, rank++, provider, type, resourceName, results, facet);
                    selectedProviders.add(provider);
                }
                SourceProvider main = delegate.getDefaultConfig().getSourceProvider();
                ResourceValueRenderer.addItemsFromSourceSet("main", 1, rank++, main, type, resourceName, results, facet);
                selectedProviders.add(main);
                Collection buildTypes = delegate.getBuildTypes();
                for (BuildTypeContainer container : buildTypes) {
                    SourceProvider provider = container.getSourceProvider();
                    if (selectedProviders.contains(provider)) continue;
                    ResourceValueRenderer.addItemsFromSourceSet(container.getBuildType().getName(), 0, rank++, provider, type, resourceName, results, facet);
                    selectedProviders.add(provider);
                }
                Collection flavors = delegate.getProductFlavors();
                for (ProductFlavorContainer container : flavors) {
                    SourceProvider provider = container.getSourceProvider();
                    if (selectedProviders.contains(provider)) continue;
                    ResourceValueRenderer.addItemsFromSourceSet(container.getProductFlavor().getName(), 0, rank++, provider, type, resourceName, results, facet);
                    selectedProviders.add(provider);
                }
                if (resources != null) {
                    for (LocalResourceRepository dependency : resources.getLibraries()) {
                        ResourceValueRenderer.addItemsFromRepository(dependency.getDisplayName(), 0, rank++, dependency, type, resourceName, results);
                    }
                }
            } else if (resources != null) {
                ResourceValueRenderer.addItemsFromRepository(null, 0, 0, resources, type, resourceName, results);
            }
            return results;
        }

        private static void addItemsFromSourceSet(@Nullable String flavor, int mask, int rank, @NotNull SourceProvider sourceProvider, @NotNull ResourceType type, @NotNull String name, @NotNull List<ItemInfo> results, @NotNull AndroidFacet facet) {
            if (sourceProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "addItemsFromSourceSet"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "addItemsFromSourceSet"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "addItemsFromSourceSet"));
            }
            if (results == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "addItemsFromSourceSet"));
            }
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "addItemsFromSourceSet"));
            }
            Collection resDirectories = sourceProvider.getResDirectories();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (File dir : resDirectories) {
                VirtualFile virtualFile = fileSystem.findFileByIoFile(dir);
                if (virtualFile == null) continue;
                ResourceFolderRepository resources = ResourceFolderRegistry.get(facet, virtualFile);
                ResourceValueRenderer.addItemsFromRepository(flavor, mask, rank, resources, type, name, results);
            }
        }

        private void addItemsFromFramework(@Nullable String flavor, int mask, int rank, @NotNull ResourceType type, @NotNull String name, @NotNull List<ItemInfo> results) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "addItemsFromFramework"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "addItemsFromFramework"));
            }
            if (results == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "addItemsFromFramework"));
            }
            ResourceRepository frameworkResources = this.getFrameworkResources();
            if (frameworkResources == null) {
                return;
            }
            if (frameworkResources.hasResourceItem(type, name)) {
                ResourceItem item = frameworkResources.getResourceItem(type, name);
                for (com.android.ide.common.resources.ResourceFile resourceFile : item.getSourceFileList()) {
                    FolderConfiguration configuration = resourceFile.getConfiguration();
                    ResourceValue value = resourceFile.getValue(type, name);
                    String folderName = resourceFile.getFolder().getFolder().getName();
                    String folder = AndroidJavaDocRenderer.renderFolderName(folderName);
                    ItemInfo info = new ItemInfo(value, configuration, folder, flavor, rank, mask);
                    results.add(info);
                }
            }
        }

        private static void addItemsFromRepository(@Nullable String flavor, int mask, int rank, @NotNull AbstractResourceRepository resources, @NotNull ResourceType type, @NotNull String name, @NotNull List<ItemInfo> results) {
            if (resources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "addItemsFromRepository"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "addItemsFromRepository"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "addItemsFromRepository"));
            }
            if (results == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "addItemsFromRepository"));
            }
            List items = resources.getResourceItem(type, name);
            if (items != null) {
                for (com.android.ide.common.res2.ResourceItem item : items) {
                    String folderName = "?";
                    ResourceFile source = (ResourceFile)item.getSource();
                    if (source != null) {
                        folderName = source.getFile().getParentFile().getName();
                    }
                    String folder = AndroidJavaDocRenderer.renderFolderName(folderName);
                    ResourceValue value = item.getResourceValue(resources.isFramework());
                    ItemInfo info = new ItemInfo(value, item.getConfiguration(), folder, flavor, rank, mask);
                    results.add(info);
                }
            }
        }

        @Nullable
        private String renderKeyValues(@NotNull List<ItemInfo> items, @NotNull ResourceUrl url) {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "renderKeyValues"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "renderKeyValues"));
            }
            if (items.isEmpty()) {
                return null;
            }
            AndroidJavaDocRenderer.markHidden(items);
            HtmlBuilder builder = new HtmlBuilder();
            builder.openHtmlBody();
            if (items.size() == 1) {
                this.renderToHtml(builder, items.get(0), url, true, items.get((int)0).value);
            } else {
                builder.beginTable("valign=\"top\"");
                boolean haveFlavors = AndroidJavaDocRenderer.haveFlavors(items);
                if (haveFlavors) {
                    builder.addTableRow(true, new String[]{"Flavor/Library", "Configuration", "Value"});
                } else {
                    builder.addTableRow(true, new String[]{"Configuration", "Value"});
                }
                String prevFlavor = null;
                boolean showResolution = true;
                for (ItemInfo info : items) {
                    String style;
                    String folder = info.folder;
                    String flavor = StringUtil.notNullize((String)info.flavor);
                    if (flavor.equals(prevFlavor)) {
                        flavor = "";
                    } else {
                        prevFlavor = flavor;
                    }
                    builder.addHtml("<tr>");
                    if (haveFlavors) {
                        style = (info.displayMask & 1) != 0 ? "b" : null;
                        this.addTableCell(builder, style, flavor, null, null, false);
                    }
                    this.addTableCell(builder, null, folder, null, null, false);
                    style = (info.displayMask & 2) != 0 ? "s" : null;
                    this.addTableCell(builder, style, null, info, url, showResolution);
                    showResolution = false;
                    builder.addHtml("</tr>");
                }
                builder.endTable();
            }
            builder.closeHtmlBody();
            return builder.getHtml();
        }

        private void addTableCell(@NotNull HtmlBuilder builder, @Nullable String attribute, @Nullable String text, @Nullable ItemInfo info, @Nullable ResourceUrl url, boolean showResolution) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "addTableCell"));
            }
            builder.addHtml("<td valign=\"top\">");
            if (attribute != null) {
                builder.addHtml("<").addHtml(attribute).addHtml(">");
            }
            if (text != null) {
                builder.add(text);
            } else {
                assert (info != null);
                assert (url != null);
                this.renderToHtml(builder, info, url, showResolution, info.value);
            }
            if (attribute != null) {
                builder.addHtml("</").addHtml(attribute).addHtml(">");
            }
            builder.addHtml("</td>");
        }

        @NotNull
        protected ResourceItemResolver createResolver(@NotNull ItemInfo item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "createResolver"));
            }
            ResourceItemResolver resolver = new ResourceItemResolver(item.configuration, (ResourceItemResolver.ResourceProvider)this, null);
            ArrayList lookupChain = Lists.newArrayList();
            lookupChain.add(item.value);
            resolver.setLookupChainList((List)lookupChain);
            ResourceItemResolver resourceItemResolver = resolver;
            if (resourceItemResolver == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "createResolver"));
            }
            return resourceItemResolver;
        }

        @Nullable
        protected Object resolveValue(@NotNull ResourceItemResolver resolver, @Nullable ResourceValue itemValue, @NotNull ResourceUrl url) {
            if (resolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "resolveValue"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "resolveValue"));
            }
            assert (resolver.getLookupChain() != null);
            resolver.setLookupChainList((List)Lists.newArrayList());
            if (itemValue != null) {
                String value = itemValue.getValue();
                if (value != null) {
                    ResourceUrl parsed = ResourceUrl.parse((String)value);
                    if (parsed != null) {
                        ResourceValue v = new ResourceValue(url.type, url.name, url.framework);
                        v.setValue(url.toString());
                        ResourceValue resourceValue = resolver.resolveResValue(v);
                        if (resourceValue != null && resourceValue.getValue() != null) {
                            return resourceValue.getValue();
                        }
                    }
                    return value;
                }
                ResourceValue v = new ResourceValue(url.type, url.name, url.framework);
                v.setValue(url.toString());
                ResourceValue resourceValue = resolver.resolveResValue(v);
                if (resourceValue != null && resourceValue.getValue() != null) {
                    return resourceValue.getValue();
                }
                if (resourceValue instanceof StyleResourceValue) {
                    return ResourceUrl.create((ResourceValue)resourceValue).toString();
                }
                return url.toString();
            }
            return null;
        }

        protected void displayChain(@NotNull ResourceUrl url, @NotNull List<ResourceValue> lookupChain, @NotNull HtmlBuilder builder, boolean newlineBefore, boolean newlineAfter) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "displayChain"));
            }
            if (lookupChain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupChain", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "displayChain"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/javadoc/AndroidJavaDocRenderer$ResourceValueRenderer", "displayChain"));
            }
            if (!lookupChain.isEmpty()) {
                if (newlineBefore) {
                    builder.newline();
                }
                String text = ResourceItemResolver.getDisplayString((String)url.toString(), lookupChain);
                builder.add(text);
                builder.newline();
                if (newlineAfter) {
                    builder.newline();
                }
            }
        }

        @Nullable
        public ResourceRepository getFrameworkResources() {
            if (this.myFrameworkResources == null) {
                this.myFrameworkResources = ResourceValueRenderer.getFrameworkResources(this.myModule);
            }
            return this.myFrameworkResources;
        }

        @Nullable
        public AppResourceRepository getAppResources() {
            if (this.myAppResources == null) {
                this.myAppResources = AppResourceRepository.getAppResources(this.myModule, true);
            }
            return this.myAppResources;
        }

        @Nullable
        public ResourceResolver getResolver(boolean createIfNecessary) {
            VirtualFile layout;
            AndroidFacet facet;
            if (this.myResourceResolver == null && createIfNecessary && (facet = AndroidFacet.getInstance(this.myModule)) != null && (layout = AndroidColorAnnotator.pickLayoutFile(this.myModule, facet)) != null) {
                Configuration configuration = facet.getConfigurationManager().getConfiguration(layout);
                this.myResourceResolver = configuration.getResourceResolver();
            }
            return this.myResourceResolver;
        }
    }
}

