/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.NewProjectImportGradleSyncListener;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.AndroidModuleTemplatesProvider;
import com.android.tools.idea.wizard.AndroidStudioWizardPath;
import com.android.tools.idea.wizard.ChooseModuleTypeStep;
import com.android.tools.idea.wizard.ConfigureAndroidProjectPath;
import com.android.tools.idea.wizard.DynamicWizardStep;
import com.android.tools.idea.wizard.ModuleTemplate;
import com.android.tools.idea.wizard.NewFormFactorModulePath;
import com.android.tools.idea.wizard.NewModuleDynamicPath;
import com.android.tools.idea.wizard.NewModuleDynamicPathFactory;
import com.android.tools.idea.wizard.NewProjectWizardDynamic;
import com.android.tools.idea.wizard.SingleStepPath;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import icons.AndroidIcons;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewModuleWizardDynamic
extends NewProjectWizardDynamic {
    private List<File> myFilesToOpen = Lists.newArrayList();

    public NewModuleWizardDynamic(@Nullable Project project, @Nullable Module module) {
        super(project, module);
        this.setTitle("Create New Module");
    }

    @Override
    public void init() {
        super.init();
        Project project = this.getProject();
        if (project != null) {
            this.getState().put(WizardConstants.PROJECT_LOCATION_KEY, project.getBasePath());
        }
        ConfigureAndroidProjectPath.putSdkDependentParams(this.getState());
    }

    @Nullable
    protected static JComponent buildHeader() {
        return DynamicWizardStep.createWizardStepHeader(WizardConstants.ANDROID_NPW_HEADER_COLOR, AndroidIcons.Wizards.NewProjectMascotGreen, "New Module");
    }

    @Override
    protected void addPaths() {
        Collection<NewModuleDynamicPath> contributions = this.getContributedPaths();
        Iterable templateProviders = Iterables.concat((Iterable)ImmutableSet.of((Object)new AndroidModuleTemplatesProvider()), contributions);
        this.addPath(new SingleStepPath(new ChooseModuleTypeStep(templateProviders, this.getDisposable())));
        for (NewFormFactorModulePath path : NewFormFactorModulePath.getAvailableFormFactorModulePaths(this.getDisposable())) {
            this.addPath(path);
        }
        for (NewModuleDynamicPath contribution : contributions) {
            this.addPath(contribution);
        }
    }

    private Collection<NewModuleDynamicPath> getContributedPaths() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (NewModuleDynamicPathFactory factory : (NewModuleDynamicPathFactory[])NewModuleDynamicPathFactory.EP_NAME.getExtensions()) {
            builder.addAll(factory.createWizardPaths(this.getProject(), this.getDisposable()));
        }
        return builder.build();
    }

    @Override
    protected String getWizardActionDescription() {
        String applicationName = this.getState().get(WizardConstants.APPLICATION_NAME_KEY);
        if (StringUtil.isEmptyOrSpaces((String)applicationName)) {
            ModuleTemplate moduleType = this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
            applicationName = moduleType != null ? moduleType.getName() : "Module";
        }
        return String.format("Create %1$s", applicationName);
    }

    @Override
    public void performFinishingActions() {
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        for (AndroidStudioWizardPath path : this.myPaths) {
            if (!(path instanceof NewFormFactorModulePath)) continue;
            this.myFilesToOpen.addAll(((NewFormFactorModulePath)path).getFilesToOpen());
        }
        GradleProjectImporter.getInstance().requestProjectSync(project, new NewProjectImportGradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/wizard/NewModuleWizardDynamic$1", "syncSucceeded"));
                }
                this.openTemplateFiles(project);
            }

            private boolean openTemplateFiles(Project project) {
                return TemplateUtils.openEditors(project, NewModuleWizardDynamic.this.myFilesToOpen, true);
            }
        });
    }
}

