/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.Variant;
import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.compiler.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.rendering.AarResourceClassRegistry;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.RenderClassLoader;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectClassLoader
extends RenderClassLoader {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.ProjectClassLoader");
    private final Module myModule;
    private final RenderLogger myLogger;
    private final Object myCredential;

    public ProjectClassLoader(@Nullable ClassLoader parentClassLoader, @NotNull Module module, @Nullable RenderLogger logger, @Nullable Object credential) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ProjectClassLoader", "<init>"));
        }
        super(parentClassLoader);
        this.myModule = module;
        this.myLogger = logger;
        this.myCredential = credential;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            byte[] data;
            int index;
            if (!(this.myInsideJarClassLoader || (index = name.lastIndexOf(46)) == -1 || name.charAt(index + 1) != 'R' || index != name.length() - 2 && name.charAt(index + 2) != '$' || index <= 1 || (data = AarResourceClassRegistry.get().findClassDefinition(name)) == null)) {
                data = this.convertClass(data);
                return this.defineClass(null, data, 0, data.length);
            }
            throw e;
        }
    }

    @Nullable
    public static ClassLoader create(IAndroidTarget target, Module module) throws Exception {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(module);
        if (androidPlatform == null) {
            return null;
        }
        AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(target);
        LayoutLibrary library = targetData.getLayoutLibrary(module.getProject());
        if (library == null) {
            return null;
        }
        return new ProjectClassLoader(library.getClassLoader(), module, null, null);
    }

    @Override
    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        Class<?> aClass = this.loadClassFromModuleOrDependency(this.myModule, name, (Set<Module>)new HashSet());
        if (aClass != null) {
            Class<?> clazz = aClass;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ProjectClassLoader", "load"));
            }
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    @Nullable
    private Class<?> loadClassFromModuleOrDependency(Module module, String name, Set<Module> visited) {
        if (!visited.add(module)) {
            return null;
        }
        Class<?> aClass = this.loadClassFromModule(module, name);
        if (aClass != null) {
            return aClass;
        }
        aClass = this.loadClassFromJar(name);
        if (aClass != null) {
            return aClass;
        }
        for (Module depModule : ModuleRootManager.getInstance((Module)module).getDependencies(false)) {
            aClass = this.loadClassFromModuleOrDependency(depModule, name, visited);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    @Nullable
    private Class<?> loadClassFromModule(Module module, String name) {
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension == null) {
            return null;
        }
        VirtualFile vOutFolder = extension.getCompilerOutputPath();
        if (vOutFolder == null) {
            IdeaAndroidProject gradleProject;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet != null && facet.isGradleProject() && (gradleProject = facet.getIdeaAndroidProject()) != null) {
                Class<?> localClass;
                File outFolder;
                Variant variant = gradleProject.getSelectedVariant();
                String variantName = variant.getName();
                AndroidArtifact mainArtifactInfo = variant.getMainArtifact();
                File classesFolder = mainArtifactInfo.getClassesFolder();
                if (classesFolder == null) {
                    AndroidArtifactOutput output = GradleUtil.getOutput(mainArtifactInfo);
                    File file = output.getMainOutputFile().getOutputFile();
                    File buildFolder = file.getParentFile().getParentFile();
                    classesFolder = new File(buildFolder, "classes");
                }
                if ((outFolder = new File(classesFolder, variantName.replace('-', File.separatorChar))).exists() && (vOutFolder = LocalFileSystem.getInstance().findFileByIoFile(outFolder)) != null && (localClass = this.loadClassFromClassPath(name, VfsUtilCore.virtualToIoFile((VirtualFile)vOutFolder))) != null) {
                    return localClass;
                }
            }
            return null;
        }
        return this.loadClassFromClassPath(name, VfsUtilCore.virtualToIoFile((VirtualFile)vOutFolder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Class<?> loadClassFile(final String fqcn, File classFile) {
        if (this.myLogger != null) {
            boolean token = RenderSecurityManager.enterSafeRegion((Object)this.myCredential);
            try {
                VirtualFile virtualFile;
                long classFileModified = classFile.lastModified();
                if (classFileModified > 0L && (virtualFile = (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

                    @Nullable
                    public VirtualFile compute() {
                        PsiFile containingFile;
                        Project project = ProjectClassLoader.this.myModule.getProject();
                        GlobalSearchScope scope = ProjectClassLoader.this.myModule.getModuleScope();
                        PsiManager psiManager = PsiManager.getInstance((Project)project);
                        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)psiManager.getProject());
                        PsiClass source = psiFacade.findClass(fqcn, scope);
                        if (source != null && (containingFile = source.getContainingFile()) != null) {
                            return containingFile.getVirtualFile();
                        }
                        return null;
                    }
                })) != null && !"R.java".equals(virtualFile.getName())) {
                    boolean modified = FileDocumentManager.getInstance().isFileModified(virtualFile);
                    if (!modified) {
                        long lastBuildTimestamp;
                        File sourceFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                        long sourceFileModified = sourceFile.lastModified();
                        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
                        long l = lastBuildTimestamp = facet != null && facet.isGradleProject() ? PostProjectBuildTasksExecutor.getInstance(this.myModule.getProject()).getLastBuildTimestamp() : classFileModified;
                        if (sourceFileModified > lastBuildTimestamp) {
                            modified = true;
                        }
                    }
                    if (modified) {
                        RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                        HtmlBuilder builder = problem.getHtmlBuilder();
                        String className = fqcn.substring(fqcn.lastIndexOf(46) + 1);
                        builder.addLink("The " + className + " custom view has been edited more recently than the last build: ", "Build", " the project.", this.myLogger.getLinkManager().createCompileModuleUrl());
                        this.myLogger.addMessage(problem);
                    }
                }
            }
            finally {
                RenderSecurityManager.exitSafeRegion((boolean)token);
            }
        }
        return super.loadClassFile(fqcn, classFile);
    }

    @Override
    protected URL[] getExternalJars() {
        ArrayList<URL> result = new ArrayList<URL>();
        for (VirtualFile libFile : AndroidRootUtil.getExternalLibraries(this.myModule)) {
            File file;
            if (!"jar".equals(libFile.getExtension()) || !(file = new File(libFile.getPath())).exists()) continue;
            try {
                AppResourceRepository appResources;
                result.add(SdkUtils.fileToUrl((File)file));
                File parentFile = file.getParentFile();
                if (parentFile == null || !parentFile.getPath().endsWith(".aar") && !parentFile.getPath().contains("exploded-aar") || (appResources = AppResourceRepository.getAppResources(this.myModule, true)) == null) continue;
                AarResourceClassRegistry.get().addLibrary(appResources, parentFile);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        return result.toArray(new URL[result.size()]);
    }
}

