/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.Queue;
import gnu.trove.Equality;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TransferToEDTQueue<T> {
    private final String myName;
    private final Processor<T> myProcessor;
    private volatile boolean stopped;
    private final Condition<?> myShutUpCondition;
    private final int myMaxUnitOfWorkThresholdMs;
    private final Queue<T> myQueue;
    private final AtomicBoolean invokeLaterScheduled;
    private final Runnable myUpdateRunnable;

    public TransferToEDTQueue(@NotNull @NonNls String name, @NotNull Processor<T> processor, @NotNull Condition<?> shutUpCondition, int maxUnitOfWorkThresholdMs) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/containers/TransferToEDTQueue", "<init>"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/containers/TransferToEDTQueue", "<init>"));
        }
        if (shutUpCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shutUpCondition", "com/intellij/util/containers/TransferToEDTQueue", "<init>"));
        }
        this.myQueue = new Queue(10);
        this.invokeLaterScheduled = new AtomicBoolean();
        this.myUpdateRunnable = new Runnable(){

            @Override
            public void run() {
                boolean b = TransferToEDTQueue.this.invokeLaterScheduled.compareAndSet(true, false);
                assert (b);
                if (TransferToEDTQueue.this.stopped || TransferToEDTQueue.this.myShutUpCondition.value(null)) {
                    TransferToEDTQueue.this.stop();
                    return;
                }
                long start = System.currentTimeMillis();
                int processed = 0;
                while (TransferToEDTQueue.this.processNext()) {
                    ++processed;
                    long finish = System.currentTimeMillis();
                    if (TransferToEDTQueue.this.myMaxUnitOfWorkThresholdMs == -1 || finish - start <= (long)TransferToEDTQueue.this.myMaxUnitOfWorkThresholdMs) continue;
                    break;
                }
                if (!TransferToEDTQueue.this.isEmpty()) {
                    TransferToEDTQueue.this.scheduleUpdate();
                }
            }
        };
        this.myName = name;
        this.myProcessor = processor;
        this.myShutUpCondition = shutUpCondition;
        this.myMaxUnitOfWorkThresholdMs = maxUnitOfWorkThresholdMs;
    }

    public static TransferToEDTQueue<Runnable> createRunnableMerger(@NotNull @NonNls String name, int maxUnitOfWorkThresholdMs) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/containers/TransferToEDTQueue", "createRunnableMerger"));
        }
        return new TransferToEDTQueue<Runnable>(name, new Processor<Runnable>(){

            @Override
            public boolean process(Runnable runnable) {
                runnable.run();
                return true;
            }
        }, Conditions.alwaysFalse(), maxUnitOfWorkThresholdMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmpty() {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            return this.myQueue.isEmpty();
        }
    }

    private boolean processNext() {
        T thing = this.pullFirst();
        if (thing == null) {
            return false;
        }
        if (!this.myProcessor.process(thing)) {
            this.stop();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T pullFirst() {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            return this.myQueue.isEmpty() ? null : (T)this.myQueue.pullFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(@NotNull T thing) {
        if (thing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thing", "com/intellij/util/containers/TransferToEDTQueue", "offer"));
        }
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            this.myQueue.addLast(thing);
        }
        this.scheduleUpdate();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerIfAbsent(final @NotNull T thing, final @NotNull Equality<T> equality) {
        if (thing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thing", "com/intellij/util/containers/TransferToEDTQueue", "offerIfAbsent"));
        }
        if (equality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equality", "com/intellij/util/containers/TransferToEDTQueue", "offerIfAbsent"));
        }
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            boolean absent = this.myQueue.process(new Processor<T>(){

                @Override
                public boolean process(T t) {
                    return !equality.equals(t, thing);
                }
            });
            if (absent) {
                this.myQueue.addLast(thing);
                this.scheduleUpdate();
            }
            return absent;
        }
    }

    private void scheduleUpdate() {
        if (!this.stopped && this.invokeLaterScheduled.compareAndSet(false, true)) {
            this.schedule(this.myUpdateRunnable);
        }
    }

    protected void schedule(@NotNull Runnable updateRunnable) {
        if (updateRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateRunnable", "com/intellij/util/containers/TransferToEDTQueue", "schedule"));
        }
        SwingUtilities.invokeLater(updateRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopped = true;
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            this.myQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            return this.myQueue.size();
        }
    }

    public void drain() {
        int processed = 0;
        long start = System.currentTimeMillis();
        while (this.processNext()) {
            ++processed;
        }
        long finish = System.currentTimeMillis();
    }

    public void waitFor() {
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.schedule(new Runnable(){

            @Override
            public void run() {
                semaphore.up();
            }
        });
        semaphore.waitFor();
    }
}

