/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgLogSingleCommitAction;
import org.zmlx.hg4idea.action.HgUpdateToAction;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgUpdateToFromLogAction
extends HgLogSingleCommitAction {
    protected void actionPerformed(@NotNull HgRepository repository, @NotNull VcsFullCommitDetails commit) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/action/HgUpdateToFromLogAction", "actionPerformed"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "org/zmlx/hg4idea/action/HgUpdateToFromLogAction", "actionPerformed"));
        }
        final Hash revisionHash = (Hash)commit.getId();
        final Project project = repository.getProject();
        final VirtualFile root = repository.getRoot();
        FileDocumentManager.getInstance().saveAllDocuments();
        new Task.Backgroundable(project, HgVcsMessages.message("hg4idea.progress.updatingTo", revisionHash.toShortString())){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/action/HgUpdateToFromLogAction$1", "run"));
                }
                HgUpdateToAction.updateTo(project, root, revisionHash.asString(), false);
            }
        }.queue();
    }
}

