/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelBinding;
import org.gradle.model.internal.core.ModelRuleRegistrar;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceModelAdapter<I>
implements ModelAdapter {
    private final ModelType<I> type;
    private final Factory<? extends I> factory;
    private I instance;

    public InstanceModelAdapter(ModelType<I> type, Factory<? extends I> factory) {
        this.type = type;
        this.factory = factory;
    }

    public static <T> ModelAdapter of(ModelType<T> type, T instance) {
        return InstanceModelAdapter.of(type, Factories.constant(instance));
    }

    public static <T> ModelAdapter of(ModelType<T> type, Factory<? extends T> factory) {
        return new InstanceModelAdapter<T>(type, factory);
    }

    @Override
    public <T> ModelView<? extends T> asWritable(ModelBinding<T> binding, ModelRuleDescriptor sourceDescriptor, Inputs inputs, ModelRuleRegistrar modelRuleRegistrar) {
        return this.type(binding.getReference().getType());
    }

    @Override
    public <T> ModelView<? extends T> asReadOnly(ModelType<T> type) {
        return this.type(type);
    }

    private I getInstance() {
        if (this.instance == null) {
            this.instance = this.factory.create();
        }
        return this.instance;
    }

    private <T> ModelView<? extends T> type(ModelType<T> targetType) {
        if (targetType.isAssignableFrom(this.type)) {
            ModelView<I> cast = InstanceModelView.of(this.type, this.getInstance());
            return cast;
        }
        return null;
    }
}

