/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestType;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class TestNGPatternConfigurationProducer
extends TestNGConfigurationProducer {
    protected boolean setupConfigurationFromContext(TestNGConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PsiElement[] elements = TestNGPatternConfigurationProducer.collectPatternElements(context, classes);
        if (elements == null || TestNGPatternConfigurationProducer.collectTestMembers(elements).size() <= 1) {
            return false;
        }
        TestData data = configuration.getPersistantData();
        data.setPatterns(classes);
        data.TEST_OBJECT = TestType.PATTERN.getType();
        data.setScope(this.setupPackageConfiguration(context, configuration, data.getScope()));
        configuration.setGeneratedName();
        sourceElement.set((Object)elements[0]);
        return true;
    }

    static Set<PsiMember> collectTestMembers(PsiElement[] psiElements) {
        LinkedHashSet<PsiMember> foundMembers = new LinkedHashSet<PsiMember>();
        for (PsiElement psiElement : psiElements) {
            if (psiElement instanceof PsiClassOwner) {
                PsiClass[] classes;
                for (PsiClass aClass : classes = ((PsiClassOwner)psiElement).getClasses()) {
                    if (!TestNGUtil.hasTest((PsiModifierListOwner)aClass)) continue;
                    foundMembers.add((PsiMember)aClass);
                }
                continue;
            }
            if (psiElement instanceof PsiClass) {
                if (!TestNGUtil.hasTest((PsiModifierListOwner)((PsiClass)psiElement))) continue;
                foundMembers.add((PsiMember)((PsiClass)psiElement));
                continue;
            }
            if (!(psiElement instanceof PsiMethod) || !TestNGUtil.hasTest((PsiModifierListOwner)psiElement)) continue;
            foundMembers.add((PsiMember)psiElement);
        }
        return foundMembers;
    }

    public static boolean isMultipleElementsSelected(ConfigurationContext context) {
        if (TestsUIUtil.isMultipleSelectionImpossible((DataContext)context.getDataContext())) {
            return false;
        }
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PsiElement[] elements = TestNGPatternConfigurationProducer.collectPatternElements(context, classes);
        return elements != null && TestNGPatternConfigurationProducer.collectTestMembers(elements).size() > 1;
    }

    private static PsiElement[] collectPatternElements(ConfigurationContext context, LinkedHashSet<String> classes) {
        DataContext dataContext = context.getDataContext();
        Location[] locations = (Location[])Location.DATA_KEYS.getData(dataContext);
        if (locations != null) {
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            for (Location location : locations) {
                PsiElement psiElement = location.getPsiElement();
                classes.add(TestNGPatternConfigurationProducer.getQName(psiElement, location));
                elements.add(psiElement);
            }
            return elements.toArray(new PsiElement[elements.size()]);
        }
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (elements != null) {
            for (PsiMember psiMember : TestNGPatternConfigurationProducer.collectTestMembers(elements)) {
                classes.add(TestNGPatternConfigurationProducer.getQName((PsiElement)psiMember, null));
            }
            return elements;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file instanceof PsiClassOwner) {
            for (PsiMember psiMember : TestNGPatternConfigurationProducer.collectTestMembers((PsiElement[])((PsiClassOwner)file).getClasses())) {
                classes.add(((PsiClass)psiMember).getQualifiedName());
            }
            return new PsiElement[]{file};
        }
        return null;
    }

    public static String getQName(PsiElement psiMember, Location location) {
        if (psiMember instanceof PsiClass) {
            return ((PsiClass)psiMember).getQualifiedName();
        }
        if (psiMember instanceof PsiMember) {
            PsiClass containingClass;
            PsiClass psiClass = containingClass = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : ((PsiMember)psiMember).getContainingClass();
            assert (containingClass != null);
            return containingClass.getQualifiedName() + "," + ((PsiMember)psiMember).getName();
        }
        if (psiMember instanceof PsiPackage) {
            return ((PsiPackage)psiMember).getQualifiedName();
        }
        assert (false);
        return null;
    }

    protected Module findModule(TestNGConfiguration configuration, Module contextModule) {
        Set<String> patterns = configuration.data.getPatterns();
        return TestNGPatternConfigurationProducer.findModule(configuration, contextModule, patterns);
    }

    public static Module findModule(ModuleBasedConfiguration configuration, Module contextModule, Set<String> patterns) {
        return JavaExecutionUtil.findModule((Module)contextModule, patterns, (Project)configuration.getProject(), (Condition)new Condition<PsiClass>(){

            public boolean value(PsiClass psiClass) {
                return TestNGUtil.hasTest((PsiModifierListOwner)psiClass);
            }
        });
    }

    @Override
    public boolean isConfigurationFromContext(TestNGConfiguration testNGConfiguration, ConfigurationContext context) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        TestNGPatternConfigurationProducer.collectPatternElements(context, classes);
        String type = testNGConfiguration.getPersistantData().TEST_OBJECT;
        return Comparing.equal((String)type, (String)TestType.PATTERN.getType()) && Comparing.equal(classes, testNGConfiguration.getPersistantData().getPatterns());
    }
}

