/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.MergeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;

public class ExitHelper {
    public static boolean condenseExits(RootStatement root) {
        int changed = ExitHelper.integrateExits(root);
        if (changed > 0) {
            ExitHelper.cleanUpUnreachableBlocks(root);
            SequenceHelper.condenseSequences(root);
        }
        return changed > 0;
    }

    private static void cleanUpUnreachableBlocks(Statement stat) {
        boolean found;
        block0: do {
            found = false;
            for (int i = 0; i < stat.getStats().size(); ++i) {
                Statement st = (Statement)stat.getStats().get(i);
                ExitHelper.cleanUpUnreachableBlocks(st);
                if (st.type != 15 || st.getStats().size() <= 1) continue;
                Statement last = st.getStats().getLast();
                Statement secondlast = (Statement)st.getStats().get(st.getStats().size() - 2);
                if (last.getExprents() != null && last.getExprents().isEmpty() || secondlast.hasBasicSuccEdge()) continue;
                Set<Statement> set = last.getNeighboursSet(0x40000000, 0);
                set.remove(secondlast);
                if (!set.isEmpty()) continue;
                last.setExprents(new ArrayList<Exprent>());
                found = true;
                continue block0;
            }
        } while (found);
    }

    private static int integrateExits(Statement stat) {
        StatEdge destedge;
        Statement parent;
        BasicBlockStatement bstat;
        int ret = 0;
        Statement dest = null;
        if (stat.getExprents() == null) {
            int changed;
            block3: do {
                changed = 0;
                for (Statement st : stat.getStats()) {
                    changed = ExitHelper.integrateExits(st);
                    if (changed <= 0) continue;
                    ret = 1;
                    continue block3;
                }
            } while (changed != 0);
            switch (stat.type) {
                case 2: {
                    StatEdge ifedge;
                    IfStatement ifst = (IfStatement)stat;
                    if (ifst.getIfstat() != null || (dest = ExitHelper.isExitEdge(ifedge = ifst.getIfEdge())) == null) break;
                    bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
                    bstat.setExprents(DecHelper.copyExprentList(dest.getExprents()));
                    ifst.getFirst().removeSuccessor(ifedge);
                    StatEdge newedge = new StatEdge(1, ifst.getFirst(), bstat);
                    ifst.getFirst().addSuccessor(newedge);
                    ifst.setIfEdge(newedge);
                    ifst.setIfstat(bstat);
                    ifst.getStats().addWithKey(bstat, bstat.id);
                    bstat.setParent(ifst);
                    StatEdge oldexitedge = dest.getAllSuccessorEdges().get(0);
                    StatEdge newexitedge = new StatEdge(4, (Statement)bstat, oldexitedge.getDestination());
                    bstat.addSuccessor(newexitedge);
                    oldexitedge.closure.addLabeledEdge(newexitedge);
                    ret = 1;
                }
            }
        }
        if (stat.getAllSuccessorEdges().size() == 1 && stat.getAllSuccessorEdges().get(0).getType() == 4 && stat.getLabelEdges().isEmpty() && (stat != (parent = stat.getParent()).getFirst() || parent.type != 2 && parent.type != 6) && (dest = ExitHelper.isExitEdge(destedge = stat.getAllSuccessorEdges().get(0))) != null) {
            stat.removeSuccessor(destedge);
            bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
            bstat.setExprents(DecHelper.copyExprentList(dest.getExprents()));
            StatEdge oldexitedge = dest.getAllSuccessorEdges().get(0);
            StatEdge newexitedge = new StatEdge(4, (Statement)bstat, oldexitedge.getDestination());
            bstat.addSuccessor(newexitedge);
            oldexitedge.closure.addLabeledEdge(newexitedge);
            SequenceStatement block = new SequenceStatement(Arrays.asList(stat, bstat));
            block.setAllParent();
            parent.replaceStatement(stat, block);
            for (StatEdge prededge : block.getPredecessorEdges(8)) {
                block.removePredecessor(prededge);
                prededge.getSource().changeEdgeNode(1, prededge, stat);
                stat.addPredecessor(prededge);
                stat.addLabeledEdge(prededge);
            }
            stat.addSuccessor(new StatEdge(1, stat, bstat));
            for (StatEdge edge : dest.getAllPredecessorEdges()) {
                if (edge.explicit || !stat.containsStatementStrict(edge.getSource()) || !MergeHelper.isDirectPath(edge.getSource().getParent(), bstat)) continue;
                dest.removePredecessor(edge);
                edge.getSource().changeEdgeNode(1, edge, bstat);
                bstat.addPredecessor(edge);
                if (stat.containsStatementStrict(edge.closure)) continue;
                stat.addLabeledEdge(edge);
            }
            ret = 2;
        }
        return ret;
    }

    private static Statement isExitEdge(StatEdge edge) {
        List<Exprent> data;
        Statement dest = edge.getDestination();
        if (edge.getType() == 4 && dest.type == 8 && edge.explicit && (edge.labeled || ExitHelper.isOnlyEdge(edge)) && (data = dest.getExprents()) != null && data.size() == 1 && data.get((int)0).type == 4) {
            return dest;
        }
        return null;
    }

    private static boolean isOnlyEdge(StatEdge edge) {
        Statement stat = edge.getDestination();
        for (StatEdge ed : stat.getAllPredecessorEdges()) {
            if (ed == edge) continue;
            if (ed.getType() == 1) {
                Statement source = ed.getSource();
                if (source.type != 8 && (source.type != 2 || ((IfStatement)source).iftype != IfStatement.IFTYPE_IF) && (source.type != 5 || ((DoStatement)source).getLooptype() == 0)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean removeRedundantReturns(RootStatement root) {
        boolean res = false;
        for (StatEdge edge : root.getDummyExit().getAllPredecessorEdges()) {
            ExitExprent ex;
            Statement source;
            List<Exprent> lstExpr;
            if (edge.explicit || (lstExpr = (source = edge.getSource()).getExprents()) == null || lstExpr.isEmpty()) continue;
            Exprent expr = lstExpr.get(lstExpr.size() - 1);
            if (expr.type != 4 || (ex = (ExitExprent)expr).getExittype() != 0 || ex.getValue() != null) continue;
            lstExpr.remove(lstExpr.size() - 1);
            res = true;
        }
        return res;
    }

    public static boolean handleReturnFromInitializer(RootStatement root) {
        boolean res = false;
        Statement exit = root.getDummyExit();
        Statement top = root.getFirst();
        Statement newret = null;
        boolean sharedcreated = false;
        for (StatEdge edge : exit.getAllPredecessorEdges()) {
            ExitExprent ex;
            Statement source;
            List<Exprent> lstExpr;
            if (!edge.explicit) continue;
            if (!sharedcreated) {
                newret = ExitHelper.addSharedInitializerReturn(root);
                sharedcreated = true;
            }
            if ((lstExpr = (source = edge.getSource()).getExprents()) == null || lstExpr.isEmpty()) continue;
            Exprent expr = lstExpr.get(lstExpr.size() - 1);
            if (expr.type != 4 || (ex = (ExitExprent)expr).getExittype() != 0 || ex.getValue() != null) continue;
            lstExpr.remove(lstExpr.size() - 1);
            source.removeSuccessor(edge);
            source.addSuccessor(new StatEdge(4, source, newret, top));
            res = true;
        }
        return res;
    }

    private static Statement addSharedInitializerReturn(RootStatement root) {
        Statement exit = root.getDummyExit();
        Statement top = root.getFirst();
        BasicBlockStatement bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
        ExitExprent retexpr = new ExitExprent(0, null, ((MethodDescriptor)DecompilerContext.getProperty((String)"CURRENT_METHOD_DESCRIPTOR")).ret);
        bstat.setExprents(new ArrayList<Exprent>(Arrays.asList(retexpr)));
        SequenceStatement seq = new SequenceStatement(Arrays.asList(top, bstat));
        top.setParent(seq);
        bstat.setParent(seq);
        seq.setParent(root);
        root.getStats().removeWithKey(top.id);
        root.getStats().addWithKeyAndIndex(0, seq, seq.id);
        root.setFirst(seq);
        for (StatEdge succedge : top.getAllSuccessorEdges()) {
            top.removeSuccessor(succedge);
        }
        top.addSuccessor(new StatEdge(1, top, bstat));
        bstat.addSuccessor(new StatEdge(4, bstat, exit, seq));
        return bstat;
    }
}

