/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarDefinitionHelper;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsProcessor;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class VarProcessor {
    private HashMap<VarVersionPaar, String> mapVarNames = new HashMap();
    private VarVersionsProcessor varvers;
    private HashMap<VarVersionPaar, String> thisvars = new HashMap();
    private HashSet<VarVersionPaar> externvars = new HashSet();

    public void setVarVersions(RootStatement root) {
        this.varvers = new VarVersionsProcessor();
        this.varvers.setVarVersions(root);
    }

    public void setVarDefinitions(Statement root) {
        this.mapVarNames = new HashMap();
        VarDefinitionHelper defproc = new VarDefinitionHelper(root, (StructMethod)DecompilerContext.getProperty("CURRENT_METHOD"), this);
        defproc.setVarDefinitions();
    }

    public void setDebugVarNames(Map<Integer, String> mapDebugVarNames) {
        if (this.varvers == null) {
            return;
        }
        HashMap<Integer, Integer> mapOriginalVarIndices = this.varvers.getMapOriginalVarIndices();
        ArrayList<VarVersionPaar> listVars = new ArrayList<VarVersionPaar>(this.mapVarNames.keySet());
        Collections.sort(listVars, new Comparator<VarVersionPaar>(){

            @Override
            public int compare(VarVersionPaar o1, VarVersionPaar o2) {
                return o1.var > o2.var ? 1 : (o1.var == o2.var ? 0 : -1);
            }
        });
        HashMap<String, Integer> mapNames = new HashMap<String, Integer>();
        for (VarVersionPaar varpaar : listVars) {
            Integer counter;
            String name = this.mapVarNames.get(varpaar);
            Integer orindex = mapOriginalVarIndices.get(varpaar.var);
            if (orindex != null && mapDebugVarNames.containsKey(orindex)) {
                name = mapDebugVarNames.get(orindex);
            }
            mapNames.put(name, (counter = (Integer)mapNames.get(name)) == null ? (counter = new Integer(0)) : (counter = Integer.valueOf(counter + 1)));
            if (counter > 0) {
                name = name + String.valueOf(counter);
            }
            this.mapVarNames.put(varpaar, name);
        }
    }

    public void refreshVarNames(VarNamesCollector vc) {
        HashMap<VarVersionPaar, String> tempVarNames = new HashMap<VarVersionPaar, String>(this.mapVarNames);
        for (Map.Entry<VarVersionPaar, String> ent : tempVarNames.entrySet()) {
            this.mapVarNames.put(ent.getKey(), vc.getFreeName(ent.getValue()));
        }
    }

    public VarType getVarType(VarVersionPaar varpaar) {
        return this.varvers == null ? null : this.varvers.getVarType(varpaar);
    }

    public void setVarType(VarVersionPaar varpaar, VarType type) {
        this.varvers.setVarType(varpaar, type);
    }

    public String getVarName(VarVersionPaar varpaar) {
        return this.mapVarNames == null ? null : this.mapVarNames.get(varpaar);
    }

    public void setVarName(VarVersionPaar varpaar, String name) {
        this.mapVarNames.put(varpaar, name);
    }

    public int getVarFinal(VarVersionPaar varpaar) {
        return this.varvers == null ? 3 : this.varvers.getVarFinal(varpaar);
    }

    public void setVarFinal(VarVersionPaar varpaar, int finaltype) {
        this.varvers.setVarFinal(varpaar, finaltype);
    }

    public HashMap<VarVersionPaar, String> getThisvars() {
        return this.thisvars;
    }

    public HashSet<VarVersionPaar> getExternvars() {
        return this.externvars;
    }
}

