/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen.generics;

import java.util.ArrayList;
import java.util.List;

public class GenericType {
    public static final int WILDCARD_EXTENDS = 1;
    public static final int WILDCARD_SUPER = 2;
    public static final int WILDCARD_UNBOUND = 3;
    public static final int WILDCARD_NO = 4;
    public int type;
    public int arraydim;
    public String value;
    private List<GenericType> enclosingClasses = new ArrayList<GenericType>();
    private List<GenericType> arguments = new ArrayList<GenericType>();
    private List<Integer> wildcards = new ArrayList<Integer>();

    public GenericType(int type, int arraydim, String value) {
        this.type = type;
        this.arraydim = arraydim;
        this.value = value;
    }

    public GenericType(String strtype) {
        this.parseSignature(strtype);
    }

    private void parseSignature(String sig) {
        block5: for (int index = 0; index < sig.length(); ++index) {
            switch (sig.charAt(index)) {
                case '[': {
                    ++this.arraydim;
                    continue block5;
                }
                case 'T': {
                    this.type = 18;
                    this.value = sig.substring(index + 1, sig.length() - 1);
                    return;
                }
                case 'L': {
                    String args;
                    String name;
                    this.type = 8;
                    sig = sig.substring(index + 1, sig.length() - 1);
                    while (true) {
                        String cl;
                        name = cl = GenericType.getNextClassSignature(sig);
                        args = null;
                        int argfrom = cl.indexOf("<");
                        if (argfrom >= 0) {
                            name = cl.substring(0, argfrom);
                            args = cl.substring(argfrom + 1, cl.length() - 1);
                        }
                        if (cl.length() >= sig.length()) break;
                        sig = sig.substring(cl.length() + 1);
                        GenericType type = new GenericType(8, 0, name);
                        GenericType.parseArgumentsList(args, type);
                        this.enclosingClasses.add(type);
                    }
                    this.value = name;
                    GenericType.parseArgumentsList(args, this);
                    return;
                }
                default: {
                    this.value = sig.substring(index, index + 1);
                    this.type = GenericType.getType(this.value.charAt(0));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getNextClassSignature(String value) {
        int counter = 0;
        int index = 0;
        while (index < value.length()) {
            switch (value.charAt(index)) {
                case '<': {
                    ++counter;
                    break;
                }
                case '>': {
                    --counter;
                    break;
                }
                case '.': {
                    if (counter != 0) break;
                    return value.substring(0, index);
                }
            }
            ++index;
        }
        return value.substring(0, index);
    }

    private static void parseArgumentsList(String value, GenericType type) {
        if (value == null) {
            return;
        }
        while (value.length() > 0) {
            String tstr = GenericType.getNextType(value);
            int len = tstr.length();
            int wildcard = 4;
            switch (tstr.charAt(0)) {
                case '*': {
                    wildcard = 3;
                    break;
                }
                case '+': {
                    wildcard = 1;
                    break;
                }
                case '-': {
                    wildcard = 2;
                }
            }
            type.getWildcards().add(wildcard);
            if (wildcard != 4) {
                tstr = tstr.substring(1);
            }
            type.getArguments().add(tstr.length() == 0 ? null : new GenericType(tstr));
            value = value.substring(len);
        }
    }

    public static String getNextType(String value) {
        int index;
        int counter = 0;
        boolean contmode = false;
        block8: for (index = 0; index < value.length(); ++index) {
            switch (value.charAt(index)) {
                case '*': {
                    if (contmode) continue block8;
                    break block8;
                }
                case 'L': 
                case 'T': {
                    if (!contmode) {
                        contmode = true;
                    }
                }
                case '+': 
                case '-': 
                case '[': {
                    continue block8;
                }
                default: {
                    if (contmode) continue block8;
                    break block8;
                }
                case '<': {
                    ++counter;
                    continue block8;
                }
                case '>': {
                    --counter;
                    continue block8;
                }
                case ';': {
                    if (counter == 0) break block8;
                }
            }
        }
        return value.substring(0, index + 1);
    }

    private static int getType(char c) {
        switch (c) {
            case 'B': {
                return 0;
            }
            case 'C': {
                return 1;
            }
            case 'D': {
                return 2;
            }
            case 'F': {
                return 3;
            }
            case 'I': {
                return 4;
            }
            case 'J': {
                return 5;
            }
            case 'S': {
                return 6;
            }
            case 'Z': {
                return 7;
            }
            case 'V': {
                return 10;
            }
            case 'G': {
                return 12;
            }
            case 'N': {
                return 14;
            }
            case 'A': {
                return 9;
            }
            case 'X': {
                return 15;
            }
            case 'Y': {
                return 16;
            }
            case 'U': {
                return 17;
            }
        }
        throw new RuntimeException("Invalid type");
    }

    public List<GenericType> getArguments() {
        return this.arguments;
    }

    public List<GenericType> getEnclosingClasses() {
        return this.enclosingClasses;
    }

    public List<Integer> getWildcards() {
        return this.wildcards;
    }
}

