/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecutionManager {
    public static final Topic<ExecutionListener> EXECUTION_TOPIC = Topic.create((String)"configuration executed", ExecutionListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);

    public static ExecutionManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionManager", "getInstance"));
        }
        return ServiceManager.getService(project, ExecutionManager.class);
    }

    @NotNull
    public abstract RunContentManager getContentManager();

    public abstract void compileAndRun(@NotNull Runnable var1, @NotNull ExecutionEnvironment var2, @Nullable RunProfileState var3, @Nullable Runnable var4);

    @NotNull
    public abstract ProcessHandler[] getRunningProcesses();

    public abstract void startRunProfile(@NotNull RunProfileStarter var1, @NotNull RunProfileState var2, @NotNull ExecutionEnvironment var3);

    public abstract void restartRunProfile(@NotNull Project var1, @NotNull Executor var2, @NotNull ExecutionTarget var3, @Nullable RunnerAndConfigurationSettings var4, @Nullable ProcessHandler var5);

    public abstract void restartRunProfile(@NotNull Project var1, @NotNull Executor var2, @NotNull ExecutionTarget var3, @Nullable RunnerAndConfigurationSettings var4, @Nullable RunContentDescriptor var5);

    public abstract void restartRunProfile(@Nullable ProgramRunner var1, @NotNull ExecutionEnvironment var2, @Nullable RunContentDescriptor var3);

    public abstract void restartRunProfile(@NotNull ExecutionEnvironment var1);
}

