/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTypedHandlerBean;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedAction {
    private TypedActionHandler myHandler = new Handler();
    private boolean myHandlersLoaded;

    private void ensureHandlersLoaded() {
        if (!this.myHandlersLoaded) {
            this.myHandlersLoaded = true;
            for (EditorTypedHandlerBean handlerBean : (EditorTypedHandlerBean[])Extensions.getExtensions(EditorTypedHandlerBean.EP_NAME)) {
                this.myHandler = handlerBean.getHandler(this.myHandler);
            }
        }
    }

    public TypedActionHandler getHandler() {
        this.ensureHandlersLoaded();
        return this.myHandler;
    }

    public TypedActionHandler setupHandler(TypedActionHandler handler) {
        this.ensureHandlersLoaded();
        TypedActionHandler tmp = this.myHandler;
        this.myHandler = handler;
        return tmp;
    }

    public final void actionPerformed(@Nullable Editor editor, char charTyped, DataContext dataContext) {
        if (editor == null) {
            return;
        }
        TypingCommand command = new TypingCommand(editor, charTyped, dataContext);
        CommandProcessor.getInstance().executeCommand(CommonDataKeys.PROJECT.getData(dataContext), command, "", editor.getDocument(), UndoConfirmationPolicy.DEFAULT, editor.getDocument());
    }

    private class TypingCommand
    implements Runnable {
        private final Editor myEditor;
        private final char myCharTyped;
        private final DataContext myDataContext;

        public TypingCommand(Editor editor, char charTyped, DataContext dataContext) {
            this.myEditor = editor;
            this.myCharTyped = charTyped;
            this.myDataContext = dataContext;
        }

        @Override
        public void run() {
            if (!FileDocumentManager.getInstance().requestWriting(this.myEditor.getDocument(), this.myEditor.getProject())) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(new DocumentRunnable(this.myEditor.getDocument(), this.myEditor.getProject()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Document doc = TypingCommand.this.myEditor.getDocument();
                    doc.startGuardedBlockChecking();
                    try {
                        TypedAction.this.getHandler().execute(TypingCommand.this.myEditor, TypingCommand.this.myCharTyped, TypingCommand.this.myDataContext);
                    }
                    catch (ReadOnlyFragmentModificationException e) {
                        EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
                    }
                    finally {
                        doc.stopGuardedBlockChecking();
                    }
                }
            });
        }
    }

    private static class Handler
    implements TypedActionHandler {
        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actionSystem/TypedAction$Handler", "execute"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/actionSystem/TypedAction$Handler", "execute"));
            }
            if (editor.isViewer()) {
                return;
            }
            Document doc = editor.getDocument();
            Project project = CommonDataKeys.PROJECT.getData(dataContext);
            if (!FileDocumentManager.getInstance().requestWriting(doc, project)) {
                return;
            }
            doc.startGuardedBlockChecking();
            try {
                String str = String.valueOf(charTyped);
                CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message("typing.in.editor.command.name", new Object[0]));
                EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true);
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
            }
            finally {
                doc.stopGuardedBlockChecking();
            }
        }
    }
}

