/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.ProgressMonitorInputStream;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.net.HTTPMethod;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.NetUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequests {
    private HttpRequests() {
    }

    @NotNull
    public static RequestBuilder request(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/HttpRequests", "request"));
        }
        RequestBuilder requestBuilder = new RequestBuilder(url);
        if (requestBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests", "request"));
        }
        return requestBuilder;
    }

    @NotNull
    public static RequestBuilder head(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/HttpRequests", "head"));
        }
        RequestBuilder builder = HttpRequests.request(url);
        builder.myMethod = HTTPMethod.HEAD;
        RequestBuilder requestBuilder = builder;
        if (requestBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests", "head"));
        }
        return requestBuilder;
    }

    @NotNull
    public static String createErrorMessage(@NotNull IOException e, @NotNull Request request, boolean includeHeaders) throws IOException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/io/HttpRequests", "createErrorMessage"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/io/HttpRequests", "createErrorMessage"));
        }
        URLConnection connection = request.getConnection();
        StringBuilder builder = new StringBuilder();
        builder.append("Cannot download '").append(connection.getURL().toExternalForm()).append("': ").append(e.getMessage());
        if (includeHeaders) {
            builder.append("\n, headers: ").append(connection.getHeaderFields());
        }
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            builder.append("\n, response: ").append(httpConnection.getResponseCode()).append(' ').append(httpConnection.getResponseMessage());
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests", "createErrorMessage"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T wrapAndProcess(RequestBuilder builder, RequestProcessor<T> processor) throws IOException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[0], oldClassLoader));
        try {
            T t = HttpRequests.process(builder, processor);
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @NotNull
    static Charset getCharset(@NotNull Request request) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/io/HttpRequests", "getCharset"));
        }
        String contentEncoding = request.getConnection().getContentEncoding();
        if (contentEncoding != null) {
            Charset charset;
            try {
                charset = Charset.forName(contentEncoding);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (charset == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests", "getCharset"));
            }
            return charset;
        }
        Charset charset = CharsetToolkit.UTF8_CHARSET;
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests", "getCharset"));
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T process(RequestBuilder builder, RequestProcessor<T> processor) throws IOException {
        class RequestImpl
        implements Request {
            private URLConnection myConnection;
            private InputStream myInputStream;
            private BufferedReader myReader;
            final /* synthetic */ RequestBuilder val$builder;

            RequestImpl(RequestBuilder requestBuilder) {
                this.val$builder = requestBuilder;
            }

            @Override
            @NotNull
            public URLConnection getConnection() throws IOException {
                if (this.myConnection == null) {
                    this.myConnection = HttpRequests.openConnection(this.val$builder);
                }
                URLConnection uRLConnection = this.myConnection;
                if (uRLConnection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$1RequestImpl", "getConnection"));
                }
                return uRLConnection;
            }

            @Override
            @NotNull
            public InputStream getInputStream() throws IOException {
                if (this.myInputStream == null) {
                    this.myInputStream = this.getConnection().getInputStream();
                    if (this.val$builder.myGzip && "gzip".equalsIgnoreCase(this.getConnection().getContentEncoding())) {
                        this.myInputStream = new GZIPInputStream(this.myInputStream);
                    }
                }
                InputStream inputStream = this.myInputStream;
                if (inputStream == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$1RequestImpl", "getInputStream"));
                }
                return inputStream;
            }

            @Override
            @NotNull
            public BufferedReader getReader() throws IOException {
                BufferedReader bufferedReader = this.getReader(null);
                if (bufferedReader == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$1RequestImpl", "getReader"));
                }
                return bufferedReader;
            }

            @Override
            @NotNull
            public BufferedReader getReader(@Nullable ProgressIndicator indicator) throws IOException {
                if (this.myReader == null) {
                    int contentLength;
                    InputStream inputStream = this.getInputStream();
                    if (indicator != null && (contentLength = this.getConnection().getContentLength()) > 0) {
                        inputStream = new ProgressMonitorInputStream(indicator, inputStream, contentLength);
                    }
                    this.myReader = new BufferedReader(new InputStreamReader(inputStream, HttpRequests.getCharset(this)));
                }
                BufferedReader bufferedReader = this.myReader;
                if (bufferedReader == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$1RequestImpl", "getReader"));
                }
                return bufferedReader;
            }

            @Override
            public boolean isSuccessful() throws IOException {
                URLConnection connection = this.getConnection();
                return !(connection instanceof HttpURLConnection) || ((HttpURLConnection)connection).getResponseCode() == 200;
            }

            private void cleanup() {
                StreamUtil.closeStream((Closeable)this.myInputStream);
                StreamUtil.closeStream((Closeable)this.myReader);
                if (this.myConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)this.myConnection).disconnect();
                }
            }

            @Override
            @NotNull
            public byte[] readBytes(@Nullable ProgressIndicator indicator) throws IOException {
                int contentLength = this.getConnection().getContentLength();
                BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(contentLength > 0 ? contentLength : 32768);
                NetUtils.copyStreamContent(indicator, this.getInputStream(), (OutputStream)out, contentLength);
                byte[] byArray = ArrayUtil.realloc((byte[])out.getInternalBuffer(), (int)out.size());
                if (byArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$1RequestImpl", "readBytes"));
                }
                return byArray;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NotNull
            public File saveToFile(@NotNull File file, @Nullable ProgressIndicator indicator) throws IOException {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/HttpRequests$1RequestImpl", "saveToFile"));
                }
                FileUtilRt.createParentDirs((File)file);
                boolean deleteFile = true;
                try {
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        NetUtils.copyStreamContent(indicator, this.getInputStream(), out, this.getConnection().getContentLength());
                        deleteFile = false;
                    }
                    catch (IOException e) {
                        throw new IOException(HttpRequests.createErrorMessage(e, this, false), e);
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    if (deleteFile) {
                        FileUtilRt.delete((File)file);
                    }
                }
                File file2 = file;
                if (file2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$1RequestImpl", "saveToFile"));
                }
                return file2;
            }
        }
        RequestImpl request = new RequestImpl(builder);
        try {
            T t = processor.process(request);
            return t;
        }
        finally {
            request.cleanup();
        }
    }

    private static URLConnection openConnection(RequestBuilder builder) throws IOException {
        String url = builder.myUrl;
        for (int i = 0; i < builder.myRedirectLimit; ++i) {
            int responseCode;
            if (builder.myForceHttps && StringUtil.startsWith((CharSequence)url, (CharSequence)"http:")) {
                url = "https:" + url.substring(5);
            }
            URLConnection connection = ApplicationManager.getApplication() == null ? new URL(url).openConnection() : HttpConfigurable.getInstance().openConnection(url);
            connection.setConnectTimeout(builder.myConnectTimeout);
            connection.setReadTimeout(builder.myTimeout);
            if (builder.myUserAgent != null) {
                connection.setRequestProperty("User-Agent", builder.myUserAgent);
            }
            if (builder.myHostnameVerifier != null && connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setHostnameVerifier(builder.myHostnameVerifier);
            }
            if (builder.myMethod != null) {
                ((HttpURLConnection)connection).setRequestMethod(builder.myMethod.name());
            }
            if (builder.myGzip) {
                connection.setRequestProperty("Accept-Encoding", "gzip");
            }
            if (builder.myAccept != null) {
                connection.setRequestProperty("Accept", builder.myAccept);
            }
            connection.setUseCaches(false);
            if (connection instanceof HttpURLConnection && (responseCode = ((HttpURLConnection)connection).getResponseCode()) != 200 && responseCode != 304) {
                ((HttpURLConnection)connection).disconnect();
                if ((responseCode == 301 || responseCode == 302) && (url = connection.getHeaderField("Location")) != null) continue;
                throw new IOException(IdeBundle.message("error.connection.failed.with.http.code.N", responseCode));
            }
            return connection;
        }
        throw new IOException(IdeBundle.message("error.connection.failed.redirects", new Object[0]));
    }

    public static interface RequestProcessor<T> {
        public T process(@NotNull Request var1) throws IOException;
    }

    public static interface Request {
        @NotNull
        public URLConnection getConnection() throws IOException;

        @NotNull
        public InputStream getInputStream() throws IOException;

        @NotNull
        public BufferedReader getReader() throws IOException;

        @NotNull
        public BufferedReader getReader(@Nullable ProgressIndicator var1) throws IOException;

        public boolean isSuccessful() throws IOException;

        @NotNull
        public File saveToFile(@NotNull File var1, @Nullable ProgressIndicator var2) throws IOException;

        public byte[] readBytes(@Nullable ProgressIndicator var1) throws IOException;
    }
}

