/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.NonNull;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.StackFrame;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.ThreadObj;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class Heap {
    private final int mId;
    @NonNull
    private final String mName;
    @NonNull
    TLongObjectHashMap<StackFrame> mFrames = new TLongObjectHashMap();
    @NonNull
    TIntObjectHashMap<StackTrace> mTraces = new TIntObjectHashMap();
    @NonNull
    ArrayList<RootObj> mRoots = new ArrayList();
    @NonNull
    TIntObjectHashMap<ThreadObj> mThreads = new TIntObjectHashMap();
    @NonNull
    TLongObjectHashMap<ClassObj> mClassesById = new TLongObjectHashMap();
    @NonNull
    HashMap<String, ClassObj> mClassesByName = new HashMap();
    private final TLongObjectHashMap<Instance> mInstances = new TLongObjectHashMap();
    Snapshot mSnapshot;

    public Heap(int id, @NonNull String name) {
        this.mId = id;
        this.mName = name;
    }

    public int getId() {
        return this.mId;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public final void addStackFrame(@NonNull StackFrame theFrame) {
        this.mFrames.put(theFrame.mId, (Object)theFrame);
    }

    public final StackFrame getStackFrame(long id) {
        return (StackFrame)this.mFrames.get(id);
    }

    public final void addStackTrace(@NonNull StackTrace theTrace) {
        this.mTraces.put(theTrace.mSerialNumber, (Object)theTrace);
    }

    public final StackTrace getStackTrace(int traceSerialNumber) {
        return (StackTrace)this.mTraces.get(traceSerialNumber);
    }

    public final StackTrace getStackTraceAtDepth(int traceSerialNumber, int depth) {
        StackTrace trace = (StackTrace)this.mTraces.get(traceSerialNumber);
        if (trace != null) {
            trace = trace.fromDepth(depth);
        }
        return trace;
    }

    public final void addRoot(@NonNull RootObj root) {
        root.mIndex = this.mRoots.size();
        this.mRoots.add(root);
    }

    public final void addThread(ThreadObj thread, int serialNumber) {
        this.mThreads.put(serialNumber, (Object)thread);
    }

    public final ThreadObj getThread(int serialNumber) {
        return (ThreadObj)this.mThreads.get(serialNumber);
    }

    public final void addInstance(long id, Instance instance) {
        this.mInstances.put(id, (Object)instance);
    }

    public final Instance getInstance(long id) {
        return (Instance)this.mInstances.get(id);
    }

    public final void addClass(long id, @NonNull ClassObj theClass) {
        this.mClassesById.put(id, (Object)theClass);
        this.mClassesByName.put(theClass.mClassName, theClass);
    }

    public final ClassObj getClass(long id) {
        return (ClassObj)this.mClassesById.get(id);
    }

    public final ClassObj getClass(String name) {
        return this.mClassesByName.get(name);
    }

    public final void dumpInstanceCounts() {
        for (Object value : this.mClassesById.getValues()) {
            ClassObj theClass = (ClassObj)value;
            int count = theClass.mInstances.size();
            if (count <= 0) continue;
            System.out.println(theClass + ": " + count);
        }
    }

    public final void dumpSubclasses() {
        for (Object value : this.mClassesById.getValues()) {
            ClassObj theClass = (ClassObj)value;
            int count = theClass.mSubclasses.size();
            if (count <= 0) continue;
            System.out.println(theClass);
            theClass.dumpSubclasses();
        }
    }

    public final void dumpSizes() {
        for (Object value : this.mClassesById.getValues()) {
            ClassObj theClass = (ClassObj)value;
            int size = 0;
            for (Instance instance : theClass.mInstances) {
                size += instance.getCompositeSize();
            }
            if (size <= 0) continue;
            System.out.println(theClass + ": base " + theClass.getSize() + ", composite " + size);
        }
    }

    @NonNull
    public Collection<ClassObj> getClasses() {
        return this.mClassesByName.values();
    }

    @NonNull
    public Collection<Instance> getInstances() {
        final ArrayList<Instance> result = new ArrayList<Instance>(this.mInstances.size());
        this.mInstances.forEachValue((TObjectProcedure)new TObjectProcedure<Instance>(){

            public boolean execute(Instance instance) {
                result.add(instance);
                return true;
            }
        });
        return result;
    }
}

