/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentRefHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
TObjectHashingStrategy<K> {
    protected final ReferenceQueue<K> myReferenceQueue;
    private final ConcurrentMap<KeyReference<K, V>, V> myMap;
    @NotNull
    private final TObjectHashingStrategy<K> myHashingStrategy;
    private static final KeyReference NULL_KEY = new KeyReference(){

        public Object get() {
            return null;
        }

        @NotNull
        public Object getValue() {
            throw new UnsupportedOperationException();
        }
    };
    private static final TObjectHashingStrategy THIS = new TObjectHashingStrategy(){

        public int computeHashCode(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o1, Object o2) {
            throw new UnsupportedOperationException();
        }
    };
    private static final ThreadLocal<HardKey> HARD_KEY = new ThreadLocal<HardKey>(){

        @Override
        protected HardKey initialValue() {
            return new HardKey();
        }
    };
    private Set<Map.Entry<K, V>> entrySet;

    protected abstract KeyReference<K, V> createKeyReference(@NotNull K var1, @NotNull V var2, @NotNull TObjectHashingStrategy<K> var3);

    boolean processQueue() {
        KeyReference wk;
        boolean processed = false;
        while ((wk = (KeyReference)((Object)this.myReferenceQueue.poll())) != null) {
            Object value = wk.getValue();
            this.myMap.remove(wk, value);
            processed = true;
        }
        return processed;
    }

    public ConcurrentRefHashMap(Map<? extends K, ? extends V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    public ConcurrentRefHashMap() {
        this(16);
    }

    public ConcurrentRefHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ConcurrentRefHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 4, THIS);
    }

    public ConcurrentRefHashMap(@NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentRefHashMap", "<init>"));
        }
        this(16, 0.75f, 2, hashingStrategy);
    }

    public ConcurrentRefHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentRefHashMap", "<init>"));
        }
        this.myReferenceQueue = new ReferenceQueue();
        this.entrySet = null;
        this.myHashingStrategy = hashingStrategy == THIS ? this : hashingStrategy;
        this.myMap = ContainerUtil.newConcurrentMap(initialCapacity, loadFactor, concurrencyLevel, CANONICAL);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.myMap.containsKey(NULL_KEY);
        }
        HardKey<K, V> hardKey = this.createHardKey(key);
        boolean result = this.myMap.containsKey(hardKey);
        ConcurrentRefHashMap.releaseHardKey(hardKey);
        return result;
    }

    private HardKey<K, V> createHardKey(Object o) {
        Object key = o;
        HardKey hardKey = HARD_KEY.get();
        hardKey.setKey(key, this.myHashingStrategy.computeHashCode(key));
        return hardKey;
    }

    private static void releaseHardKey(HardKey<?, ?> key) {
        ((HardKey)key).setKey(null, 0);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.myMap.get(NULL_KEY);
        }
        HardKey<K, V> hardKey = this.createHardKey(key);
        Object result = this.myMap.get(hardKey);
        ConcurrentRefHashMap.releaseHardKey(hardKey);
        return result;
    }

    @Override
    public V put(K key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefHashMap", "put"));
        }
        this.processQueue();
        KeyReference<K, V> weakKey = key == null ? NULL_KEY : this.createKeyReference(key, value, this.myHashingStrategy);
        return this.myMap.put(weakKey, value);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        if (key == null) {
            return this.myMap.remove(NULL_KEY);
        }
        HardKey<K, V> hardKey = this.createHardKey(key);
        Object result = this.myMap.remove(hardKey);
        ConcurrentRefHashMap.releaseHardKey(hardKey);
        return result;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefHashMap", "entrySet"));
        }
        return set;
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefHashMap", "putIfAbsent"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefHashMap", "putIfAbsent"));
        }
        this.processQueue();
        return this.myMap.putIfAbsent(this.createKeyReference(key, value, this.myHashingStrategy), value);
    }

    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefHashMap", "remove"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefHashMap", "remove"));
        }
        this.processQueue();
        return this.myMap.remove(this.createKeyReference(key, value, this.myHashingStrategy), value);
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefHashMap", "replace"));
        }
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/intellij/util/containers/ConcurrentRefHashMap", "replace"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/util/containers/ConcurrentRefHashMap", "replace"));
        }
        this.processQueue();
        return this.myMap.replace(this.createKeyReference(key, oldValue, this.myHashingStrategy), oldValue, newValue);
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefHashMap", "replace"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefHashMap", "replace"));
        }
        this.processQueue();
        return this.myMap.replace(this.createKeyReference(key, value, this.myHashingStrategy), value);
    }

    public int computeHashCode(K object) {
        int h = object.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public boolean equals(K o1, K o2) {
        return o1.equals(o2);
    }

    int underlyingMapSize() {
        return this.myMap.size();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        Set<Map.Entry<KeyReference<K, V>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = ConcurrentRefHashMap.this.myMap.entrySet();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            Iterator iterator = new Iterator<Map.Entry<K, V>>(){
                Iterator<Map.Entry<KeyReference<K, V>, V>> hashIterator;
                RefEntry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        KeyReference wk = ent.getKey();
                        Object k = null;
                        if (wk != null) {
                            Object k2 = wk.get();
                            k = k2;
                            if (k2 == null) continue;
                        }
                        this.next = new RefEntry(ent, k);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    RefEntry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
            if (iterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefHashMap$EntrySet", "iterator"));
            }
            return iterator;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            ConcurrentRefHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            HardKey key = ConcurrentRefHashMap.this.createHardKey(e.getKey());
            Object hv = ConcurrentRefHashMap.this.myMap.get(key);
            boolean bl = hv == null ? ev == null && ConcurrentRefHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
            if (toRemove) {
                ConcurrentRefHashMap.this.myMap.remove(key);
            }
            ConcurrentRefHashMap.releaseHardKey(key);
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v;
                Map.Entry ent = entry;
                KeyReference wk = ent.getKey();
                if (wk == null) continue;
                h += ((Object)wk).hashCode() ^ ((v = ent.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static class RefEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;

        RefEntry(Map.Entry<?, V> ent, K key) {
            this.ent = ent;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.ent.setValue(value);
        }

        private static boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return RefEntry.valEquals(this.key, e.getKey()) && RefEntry.valEquals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }
    }

    private static class HardKey<K, V>
    implements KeyReference<K, V> {
        private K myKey;
        private int myHash;

        private HardKey() {
        }

        private void setKey(K key, int hash) {
            this.myKey = key;
            this.myHash = hash;
        }

        @Override
        public K get() {
            return this.myKey;
        }

        @Override
        @NotNull
        public V getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }
    }

    static interface KeyReference<K, V> {
        public K get();

        @NotNull
        public V getValue();

        public boolean equals(Object var1);

        public int hashCode();
    }
}

