/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.trello.TrelloRepository;
import com.intellij.tasks.trello.model.TrelloBoard;
import com.intellij.tasks.trello.model.TrelloList;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrelloRepositoryEditor
extends BaseRepositoryEditor<TrelloRepository> {
    private static final Logger LOG = Logger.getInstance(TrelloRepositoryEditor.class);
    private static final TrelloBoard UNSPECIFIED_BOARD = new TrelloBoard(){

        @Override
        @NotNull
        public String getName() {
            if ("-- from all boards --" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepositoryEditor$1", "getName"));
            }
            return "-- from all boards --";
        }
    };
    private static final TrelloList UNSPECIFIED_LIST = new TrelloList(){

        @Override
        @NotNull
        public String getName() {
            if ("-- from all lists --" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepositoryEditor$2", "getName"));
            }
            return "-- from all lists --";
        }
    };
    private ComboBox myBoardComboBox;
    private ComboBox myListComboBox;
    private JBLabel myListLabel;
    private JBLabel myBoardLabel;
    private JBCheckBox myAllCardsCheckBox;

    public TrelloRepositoryEditor(Project project, TrelloRepository repository, Consumer<TrelloRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
        this.myUrlLabel.setVisible(false);
        this.myURLText.setVisible(false);
        this.myUsernameLabel.setVisible(false);
        this.myUserNameText.setVisible(false);
        this.myPasswordLabel.setText("Token:");
        this.myAllCardsCheckBox.setSelected(((TrelloRepository)this.myRepository).isIncludeAllCards());
        this.myPasswordText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String password = String.valueOf(TrelloRepositoryEditor.this.myPasswordText.getPassword());
                if (password.isEmpty() || password.equals(((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getPassword())) {
                    return;
                }
                LOG.debug("Authentication token was changed");
                ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setPassword(password);
                new BoardsDownloader(UNSPECIFIED_BOARD){

                    @Override
                    protected List<TrelloBoard> download() throws Exception {
                        ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentUser(((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchUserByToken());
                        return super.download();
                    }
                }.runOnPooledThread();
                TrelloRepositoryEditor.this.doApply();
            }
        });
        this.myBoardComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TrelloBoard board = (TrelloBoard)e.getItem();
                if (e.getStateChange() == 2 || board.equals(((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getCurrentBoard())) {
                    return;
                }
                if (board != UNSPECIFIED_BOARD) {
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentBoard(board);
                    new ListsDownloader(UNSPECIFIED_LIST).runOnPooledThread();
                } else {
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentBoard(null);
                    TrelloRepositoryEditor.this.myListComboBox.removeAllItems();
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentList(null);
                }
                TrelloRepositoryEditor.this.doApply();
            }
        });
        this.myBoardComboBox.setRenderer((ListCellRenderer)((Object)new TrelloBoardRenderer("Set token first")));
        this.myListComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TrelloList list = (TrelloList)e.getItem();
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentList(list != UNSPECIFIED_LIST ? list : null);
                    TrelloRepositoryEditor.this.doApply();
                }
            }
        });
        this.myListComboBox.setRenderer((ListCellRenderer)((Object)new TrelloListRenderer("Select board first")));
        if (((TrelloRepository)this.myRepository).getCurrentUser() != null) {
            new BoardsDownloader(((TrelloRepository)this.myRepository).getCurrentBoard()){

                @Override
                protected List<TrelloBoard> download() throws Exception {
                    LOG.debug("Updating information about boards available to user when repository setting are shown");
                    Object boards = super.download();
                    if (this.myBoard == null) {
                        return boards;
                    }
                    int i = boards.indexOf(this.myBoard);
                    this.myBoard = i >= 0 ? (TrelloBoard)boards.get(i) : ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchBoardById(this.myBoard.getId());
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentBoard(this.myBoard);
                    return boards;
                }
            }.runOnPooledThread();
        }
        if (((TrelloRepository)this.myRepository).getCurrentBoard() != null) {
            new ListsDownloader(((TrelloRepository)this.myRepository).getCurrentList()){

                @Override
                protected List<TrelloList> download() throws Exception {
                    LOG.debug("Updating information about lists of board " + ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getCurrentBoard() + " when repository setting are shown");
                    Object lists = super.download();
                    if (this.myList == null) {
                        return lists;
                    }
                    int i = lists.indexOf(this.myList);
                    this.myList = i >= 0 ? (TrelloList)lists.get(i) : ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchListById(this.myList.getId());
                    TrelloBoard currentBoard = ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getCurrentBoard();
                    if (currentBoard != null && !this.myList.getIdBoard().equals(currentBoard.getId())) {
                        this.myList.setMoved(true);
                    }
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentList(this.myList);
                    return lists;
                }
            }.runOnPooledThread();
        }
        this.installListener((JCheckBox)this.myAllCardsCheckBox);
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.myBoardComboBox = new ComboBox(300);
        this.myBoardLabel = new JBLabel("Board:", 4);
        this.myBoardLabel.setLabelFor((Component)this.myBoardComboBox);
        this.myListComboBox = new ComboBox(300);
        this.myListLabel = new JBLabel("List:", 4);
        this.myListLabel.setLabelFor((Component)this.myListComboBox);
        this.myAllCardsCheckBox = new JBCheckBox("Include cards not assigned to me");
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.myBoardLabel, (JComponent)this.myBoardComboBox).addLabeledComponent((JComponent)this.myListLabel, (JComponent)this.myListComboBox).addComponentToRightColumn((JComponent)this.myAllCardsCheckBox).getPanel();
    }

    public void apply() {
        super.apply();
        ((TrelloRepository)this.myRepository).setIncludeAllCards(this.myAllCardsCheckBox.isSelected());
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myListLabel.setAnchor(anchor);
        this.myBoardLabel.setAnchor(anchor);
    }

    private static class TrelloListRenderer
    extends ListCellRendererWrapper<TrelloList> {
        private String myNullDescription;

        private TrelloListRenderer(String nullDescription) {
            this.myNullDescription = nullDescription;
        }

        public void customize(JList list, TrelloList trelloList, int index, boolean selected, boolean hasFocus) {
            if (trelloList == null) {
                this.setText(this.myNullDescription);
                return;
            }
            String text = trelloList.getName();
            if (trelloList.isClosed() && trelloList.isMoved()) {
                text = text + " (archived,moved)";
            } else if (trelloList.isMoved()) {
                text = text + " (moved)";
            } else if (trelloList.isClosed()) {
                text = text + " (archived)";
            }
            this.setText(text);
        }
    }

    private static class TrelloBoardRenderer
    extends ListCellRendererWrapper<TrelloBoard> {
        private String myNullDescription;

        private TrelloBoardRenderer(String nullDescription) {
            this.myNullDescription = nullDescription;
        }

        public void customize(JList list, TrelloBoard board, int index, boolean selected, boolean hasFocus) {
            if (board == null) {
                this.setText(this.myNullDescription);
                return;
            }
            this.setText(board.isClosed() ? board.getName() + " (closed)" : board.getName());
        }
    }

    private class ListsDownloader
    extends Downloader<List<TrelloList>> {
        protected TrelloList myList;

        private ListsDownloader(TrelloList selectedList) {
            this.myList = selectedList;
        }

        @Override
        protected List<TrelloList> download() throws Exception {
            return ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchBoardLists();
        }

        @Override
        protected void updateUI(List<TrelloList> lists) {
            TrelloRepositoryEditor.this.myListComboBox.setModel(new DefaultComboBoxModel<Object>(lists.toArray()));
            TrelloRepositoryEditor.this.myListComboBox.insertItemAt((Object)UNSPECIFIED_LIST, 0);
            if (this.myList != null && this.myList != UNSPECIFIED_LIST && !lists.contains(this.myList)) {
                TrelloRepositoryEditor.this.myListComboBox.addItem((Object)this.myList);
            }
            TrelloRepositoryEditor.this.myListComboBox.setSelectedItem((Object)(this.myList == null ? UNSPECIFIED_LIST : this.myList));
        }

        @Override
        protected void handleException(Exception e) {
            TrelloRepositoryEditor.this.myListComboBox.removeAllItems();
        }
    }

    private class BoardsDownloader
    extends Downloader<List<TrelloBoard>> {
        protected TrelloBoard myBoard;

        private BoardsDownloader(TrelloBoard selectedBoard) {
            this.myBoard = selectedBoard;
        }

        @Override
        protected List<TrelloBoard> download() throws Exception {
            return ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchUserBoards();
        }

        @Override
        protected void updateUI(List<TrelloBoard> boards) {
            TrelloRepositoryEditor.this.myBoardComboBox.setModel(new DefaultComboBoxModel<Object>(boards.toArray()));
            TrelloRepositoryEditor.this.myBoardComboBox.insertItemAt((Object)UNSPECIFIED_BOARD, 0);
            if (this.myBoard != null && this.myBoard != UNSPECIFIED_BOARD && !boards.contains(this.myBoard)) {
                TrelloRepositoryEditor.this.myBoardComboBox.addItem((Object)this.myBoard);
            }
            TrelloRepositoryEditor.this.myBoardComboBox.setSelectedItem((Object)(this.myBoard == null ? UNSPECIFIED_BOARD : this.myBoard));
        }

        @Override
        protected void handleException(Exception e) {
            TrelloRepositoryEditor.this.myBoardComboBox.removeAllItems();
            TrelloRepositoryEditor.this.myListComboBox.removeAllItems();
        }
    }

    private abstract class Downloader<T>
    implements Runnable {
        private final ModalityState myModalityState = ModalityState.current();

        private Downloader() {
        }

        protected abstract T download() throws Exception;

        protected void updateUI(T result) {
        }

        protected void handleException(Exception e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                T result;
                TrelloRepository trelloRepository = (TrelloRepository)TrelloRepositoryEditor.this.myRepository;
                synchronized (trelloRepository) {
                    result = this.download();
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Downloader.this.updateUI(result);
                    }
                }, this.myModalityState);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Downloader.this.handleException(e);
                    }
                }, this.myModalityState);
            }
        }

        public void runOnPooledThread() {
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this);
        }
    }
}

