/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.BindingTargetVisitor;
import java.lang.annotation.Annotation;
import org.sonatype.guice.bean.locators.ImplementationVisitor;
import org.sonatype.guice.bean.locators.WildcardKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum QualifyingStrategy {
    UNRESTRICTED{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier = 1.qualify(binding.getKey());
            return null != qualifier ? qualifier : BLANK_QUALIFIER;
        }
    }
    ,
    NAMED{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier = 2.qualify(binding.getKey());
            return qualifier instanceof Named ? qualifier : null;
        }
    }
    ,
    NAMED_WITH_ATTRIBUTES{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier = 3.qualify(binding.getKey());
            return ((Object)requirement.getAnnotation()).equals(qualifier) ? qualifier : null;
        }
    }
    ,
    MARKED{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier;
            Class markerType = requirement.getAnnotationType();
            if (markerType.isInstance(qualifier = 4.qualify(binding.getKey()))) {
                return qualifier;
            }
            Class implementation = (Class)binding.acceptTargetVisitor((BindingTargetVisitor)ImplementationVisitor.THIS);
            return null != implementation ? (Annotation)implementation.getAnnotation(markerType) : null;
        }
    }
    ,
    MARKED_WITH_ATTRIBUTES{

        @Override
        final Annotation qualifies(Key<?> requirement, Binding<?> binding) {
            Annotation qualifier = MARKED.qualifies(requirement, binding);
            return ((Object)requirement.getAnnotation()).equals(qualifier) ? qualifier : null;
        }
    };

    static final Annotation DEFAULT_QUALIFIER;
    static final Annotation BLANK_QUALIFIER;

    abstract Annotation qualifies(Key<?> var1, Binding<?> var2);

    static final QualifyingStrategy selectFor(Key<?> key) {
        Class qualifierType = key.getAnnotationType();
        if (null == qualifierType) {
            return UNRESTRICTED;
        }
        if (Named.class == qualifierType) {
            return key.hasAttributes() ? NAMED_WITH_ATTRIBUTES : NAMED;
        }
        return key.hasAttributes() ? MARKED_WITH_ATTRIBUTES : MARKED;
    }

    static final Annotation qualify(Key<?> key) {
        if (key instanceof WildcardKey) {
            Annotation qualifier = ((WildcardKey)key).getQualifier();
            return null != qualifier ? qualifier : DEFAULT_QUALIFIER;
        }
        return null != key.getAnnotationType() ? key.getAnnotation() : DEFAULT_QUALIFIER;
    }

    static {
        DEFAULT_QUALIFIER = Names.named((String)"default");
        BLANK_QUALIFIER = Names.named((String)"");
    }
}

