/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.externalSystem.service.settings.AbstractImportFromExternalSystemControl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControl;
import org.jetbrains.plugins.gradle.service.settings.GradleSystemSettingsControl;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class ImportFromGradleControl
extends AbstractImportFromExternalSystemControl<GradleProjectSettings, GradleSettingsListener, GradleSettings> {
    public ImportFromGradleControl() {
        super(GradleConstants.SYSTEM_ID, (AbstractExternalSystemSettings)new GradleSettings(ProjectManager.getInstance().getDefaultProject()), (ExternalProjectSettings)ImportFromGradleControl.getInitialProjectSettings(), true);
    }

    @NotNull
    private static GradleProjectSettings getInitialProjectSettings() {
        GradleProjectSettings result = new GradleProjectSettings();
        String gradleHome = GradleUtil.getLastUsedGradleHome();
        if (!StringUtil.isEmpty((String)gradleHome)) {
            result.setGradleHome(gradleHome);
        }
        GradleProjectSettings gradleProjectSettings = result;
        if (gradleProjectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/ImportFromGradleControl", "getInitialProjectSettings"));
        }
        return gradleProjectSettings;
    }

    @NotNull
    protected ExternalSystemSettingsControl<GradleProjectSettings> createProjectSettingsControl(@NotNull GradleProjectSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/gradle/service/settings/ImportFromGradleControl", "createProjectSettingsControl"));
        }
        GradleProjectSettingsControl settingsControl = new GradleProjectSettingsControl(settings);
        settingsControl.hideUseAutoImportBox();
        GradleProjectSettingsControl gradleProjectSettingsControl = settingsControl;
        if (gradleProjectSettingsControl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/ImportFromGradleControl", "createProjectSettingsControl"));
        }
        return gradleProjectSettingsControl;
    }

    @Nullable
    protected ExternalSystemSettingsControl<GradleSettings> createSystemSettingsControl(@NotNull GradleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/gradle/service/settings/ImportFromGradleControl", "createSystemSettingsControl"));
        }
        return new GradleSystemSettingsControl(settings);
    }

    protected void onLinkedProjectPathChange(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/gradle/service/settings/ImportFromGradleControl", "onLinkedProjectPathChange"));
        }
        ((GradleProjectSettingsControl)this.getProjectSettingsControl()).updateWrapperControls(path, false);
    }
}

