/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public abstract class TemplateInsertHandler<T extends LookupElement>
implements InsertHandler<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.TemplateInsertHandler");
    protected static final Object EXPANDED_TEMPLATE_ATTR = Key.create((String)"EXPANDED_TEMPLATE_ATTR");

    public void handleInsert(InsertionContext context, LookupElement item) {
        if (TemplateInsertHandler.isTemplateToBeCompleted(item)) {
            context.setAddCompletionChar(false);
            this.handleTemplate((LookupItem)item, context);
        }
    }

    protected static boolean isTemplateToBeCompleted(LookupElement lookupItem) {
        return lookupItem instanceof LookupItem && lookupItem.getObject() instanceof Template && ((LookupItem)lookupItem).getAttribute(EXPANDED_TEMPLATE_ATTR) == null;
    }

    protected void handleTemplate(final @NotNull LookupItem lookupItem, final @NotNull InsertionContext context) {
        if (lookupItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupItem", "com/intellij/codeInsight/completion/TemplateInsertHandler", "handleTemplate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/TemplateInsertHandler", "handleTemplate"));
        }
        LOG.assertTrue(CommandProcessor.getInstance().getCurrentCommand() != null);
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
        Template template = (Template)lookupItem.getObject();
        Editor editor = context.getEditor();
        final Document document = editor.getDocument();
        int templateStartOffset = context.getStartOffset();
        document.replaceString(templateStartOffset, templateStartOffset + lookupItem.getLookupString().length(), (CharSequence)"");
        final RangeMarker offsetRangeMarker = document.createRangeMarker(templateStartOffset, templateStartOffset);
        TemplateManager.getInstance(editor.getProject()).startTemplate(editor, template, new TemplateEditingAdapter(){

            @Override
            public void templateFinished(Template template, boolean brokenOff) {
                lookupItem.setAttribute(EXPANDED_TEMPLATE_ATTR, Boolean.TRUE);
                if (!offsetRangeMarker.isValid()) {
                    return;
                }
                Editor editor = context.getEditor();
                int startOffset = offsetRangeMarker.getStartOffset();
                int endOffset = editor.getCaretModel().getOffset();
                String lookupString = ((Object)editor.getDocument().getCharsSequence().subSequence(startOffset, endOffset)).toString();
                lookupItem.setLookupString(lookupString);
                OffsetMap offsetMap = new OffsetMap(document);
                offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, startOffset);
                offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, endOffset);
                offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, endOffset);
                PsiFile psiFile = context.getFile();
                InsertionContext newContext = new InsertionContext(offsetMap, context.getCompletionChar(), LookupElement.EMPTY_ARRAY, psiFile, editor, context.shouldAddCompletionChar());
                TemplateInsertHandler.this.populateInsertMap(psiFile, offsetMap);
                TemplateInsertHandler.this.handleInsert(newContext, (LookupElement)lookupItem);
            }
        });
    }

    protected void populateInsertMap(@NotNull PsiFile file, @NotNull OffsetMap offsetMap) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/completion/TemplateInsertHandler", "populateInsertMap"));
        }
        if (offsetMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offsetMap", "com/intellij/codeInsight/completion/TemplateInsertHandler", "populateInsertMap"));
        }
    }
}

