/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.ExtraSteppingFilter;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VMDisconnectedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestHint {
    public static final int STOP = 0;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.RequestHint");
    private final int myDepth;
    private final SourcePosition myPosition;
    private final int myFrameCount;
    @Nullable
    private final MethodFilter myMethodFilter;
    private boolean myTargetMethodMatched;
    private boolean myIgnoreFilters;
    private boolean myRestoreBreakpoints;

    public RequestHint(ThreadReferenceProxyImpl stepThread, SuspendContextImpl suspendContext, @NotNull MethodFilter methodFilter) {
        if (methodFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodFilter", "com/intellij/debugger/engine/RequestHint", "<init>"));
        }
        this(stepThread, suspendContext, 1, methodFilter);
    }

    public RequestHint(ThreadReferenceProxyImpl stepThread, SuspendContextImpl suspendContext, int depth) {
        this(stepThread, suspendContext, depth, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestHint(final ThreadReferenceProxyImpl stepThread, final SuspendContextImpl suspendContext, int depth, @Nullable MethodFilter methodFilter) {
        this.myTargetMethodMatched = false;
        this.myIgnoreFilters = false;
        this.myRestoreBreakpoints = false;
        this.myDepth = depth;
        this.myMethodFilter = methodFilter;
        int frameCount = 0;
        SourcePosition position = null;
        try {
            frameCount = stepThread.frameCount();
            position = (SourcePosition)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SourcePosition>(){

                public SourcePosition compute() {
                    return ContextUtil.getSourcePosition(new StackFrameContext(){

                        public StackFrameProxy getFrameProxy() {
                            try {
                                return stepThread.frame(0);
                            }
                            catch (EvaluateException e) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Throwable)e);
                                }
                                return null;
                            }
                        }

                        @NotNull
                        public DebugProcess getDebugProcess() {
                            DebugProcessImpl debugProcessImpl = suspendContext.getDebugProcess();
                            if (debugProcessImpl == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/RequestHint$1$1", "getDebugProcess"));
                            }
                            return debugProcessImpl;
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        finally {
            this.myFrameCount = frameCount;
            this.myPosition = position;
        }
    }

    public void setIgnoreFilters(boolean ignoreFilters) {
        this.myIgnoreFilters = ignoreFilters;
    }

    public void setRestoreBreakpoints(boolean restoreBreakpoints) {
        this.myRestoreBreakpoints = restoreBreakpoints;
    }

    public boolean isRestoreBreakpoints() {
        return this.myRestoreBreakpoints;
    }

    public boolean isIgnoreFilters() {
        return this.myIgnoreFilters;
    }

    public int getDepth() {
        return this.myDepth;
    }

    @Nullable
    public MethodFilter getMethodFilter() {
        return this.myMethodFilter;
    }

    public boolean wasStepTargetMethodMatched() {
        return this.myMethodFilter instanceof BreakpointStepMethodFilter || this.myTargetMethodMatched;
    }

    private boolean isOnTheSameLine(SourcePosition locationPosition) {
        if (this.myMethodFilter == null) {
            return this.myPosition.getLine() == locationPosition.getLine();
        }
        return locationPosition.getLine() >= (Integer)this.myMethodFilter.getCallingExpressionLines().getFrom() && locationPosition.getLine() <= (Integer)this.myMethodFilter.getCallingExpressionLines().getTo();
    }

    public int getNextStepDepth(final SuspendContextImpl context) {
        try {
            Integer resultDepth;
            StackFrameProxyImpl frameProxy = context.getFrameProxy();
            if (this.myMethodFilter != null && frameProxy != null && !(this.myMethodFilter instanceof BreakpointStepMethodFilter) && this.myMethodFilter.locationMatches(context.getDebugProcess(), frameProxy.location())) {
                this.myTargetMethodMatched = true;
                return 0;
            }
            if ((this.myDepth == 2 || this.myDepth == 1) && this.myPosition != null && (resultDepth = (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

                public Integer compute() {
                    boolean filesEqual;
                    SourcePosition locationPosition = ContextUtil.getSourcePosition((StackFrameContext)context);
                    if (locationPosition == null) {
                        return null;
                    }
                    int frameCount = -1;
                    ThreadReferenceProxyImpl contextThread = context.getThread();
                    if (contextThread != null) {
                        try {
                            frameCount = contextThread.frameCount();
                        }
                        catch (EvaluateException ignored) {
                            // empty catch block
                        }
                    }
                    if ((filesEqual = RequestHint.this.myPosition.getFile().equals(locationPosition.getFile())) && RequestHint.this.isOnTheSameLine(locationPosition) && RequestHint.this.myFrameCount == frameCount) {
                        return RequestHint.this.myDepth;
                    }
                    if (RequestHint.this.myDepth == 1 && filesEqual) {
                        if (RequestHint.this.myFrameCount > frameCount) {
                            return 0;
                        }
                        if (RequestHint.this.myFrameCount == frameCount && !RequestHint.this.isOnTheSameLine(locationPosition)) {
                            return 0;
                        }
                    }
                    return null;
                }
            })) != null) {
                return resultDepth;
            }
            if (this.myDepth == 1) {
                Location location;
                DebuggerSettings settings = DebuggerSettings.getInstance();
                if ((settings.SKIP_SYNTHETIC_METHODS || this.myMethodFilter != null) && frameProxy != null && (location = frameProxy.location()) != null && DebuggerUtils.isSynthetic((TypeComponent)location.method())) {
                    return this.myDepth;
                }
                if (!this.myIgnoreFilters) {
                    boolean isGetter;
                    if (settings.SKIP_GETTERS && (isGetter = ((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                        public Boolean compute() {
                            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)PositionUtil.getContextElement((StackFrameContext)context), PsiMethod.class);
                            return psiMethod != null && DebuggerUtils.isSimpleGetter((PsiMethod)psiMethod) ? Boolean.TRUE : Boolean.FALSE;
                        }
                    })).booleanValue())) {
                        return 3;
                    }
                    if (frameProxy != null) {
                        Method method;
                        if (settings.SKIP_CONSTRUCTORS && (location = frameProxy.location()) != null && (method = location.method()) != null && method.isConstructor()) {
                            return 3;
                        }
                        if (settings.SKIP_CLASSLOADERS && (location = frameProxy.location()) != null && DebuggerUtilsEx.isAssignableFrom("java.lang.ClassLoader", location.declaringType())) {
                            return 3;
                        }
                    }
                }
                for (ExtraSteppingFilter filter : (ExtraSteppingFilter[])ExtraSteppingFilter.EP_NAME.getExtensions()) {
                    if (!filter.isApplicable(context)) continue;
                    return filter.getStepRequestDepth(context);
                }
            }
            if (this.myMethodFilter != null) {
                return 3;
            }
        }
        catch (VMDisconnectedException ignored) {
        }
        catch (EvaluateException e) {
            LOG.error((Throwable)e);
        }
        return 0;
    }
}

