/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;

public abstract class CustomPopupFullValueEvaluator
extends XFullValueEvaluator {
    protected final EvaluationContextImpl myEvaluationContext;

    public CustomPopupFullValueEvaluator(@NotNull String linkText, EvaluationContextImpl evaluationContext) {
        if (linkText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkText", "com/intellij/debugger/settings/CustomPopupFullValueEvaluator", "<init>"));
        }
        super(linkText);
        this.myEvaluationContext = evaluationContext;
        this.setShowValuePopup(false);
    }

    protected abstract JComponent createComponent();

    public void startEvaluation(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/settings/CustomPopupFullValueEvaluator", "startEvaluation"));
        }
        this.myEvaluationContext.getDebugProcess().getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void contextAction() throws Exception {
                final JComponent comp = CustomPopupFullValueEvaluator.this.createComponent();
                DebuggerUIUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Project project = CustomPopupFullValueEvaluator.this.myEvaluationContext.getProject();
                        JBPopup popup = DebuggerUIUtil.createValuePopup(project, comp, null);
                        JFrame frame = WindowManager.getInstance().getFrame(project);
                        Dimension frameSize = frame.getSize();
                        Dimension size = new Dimension(frameSize.width / 2, frameSize.height / 2);
                        popup.setSize(size);
                        callback.evaluated("");
                        popup.show(new RelativePoint((Component)frame, new Point((int)size.getWidth() / 2, (int)size.getHeight() / 2)));
                    }
                });
            }
        });
    }
}

