/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ArrayRenderer
extends NodeRendererImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.ArrayRenderer");
    @NonNls
    public static final String UNIQUE_ID = "ArrayRenderer";
    public int START_INDEX = 0;
    public int END_INDEX = 100;
    public int ENTRIES_LIMIT = 101;
    private static final String MORE_ELEMENTS = "...";
    private boolean myForced = false;

    public ArrayRenderer() {
        this.myProperties.setEnabled(true);
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public boolean isEnabled() {
        return this.myProperties.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myProperties.setEnabled(enabled);
    }

    @Override
    @NonNls
    public String getName() {
        return "Array";
    }

    @Override
    public void setName(String text) {
        LOG.assertTrue(false);
    }

    @Override
    public ArrayRenderer clone() {
        return (ArrayRenderer)super.clone();
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        return ClassRenderer.calcLabel(descriptor);
    }

    public void setForced(boolean forced) {
        this.myForced = forced;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        ArrayReference array;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ArrayList<DebuggerTreeNode> children = new ArrayList<DebuggerTreeNode>();
        NodeManagerImpl nodeManager = (NodeManagerImpl)builder.getNodeManager();
        NodeDescriptorFactory descriptorFactory = builder.getDescriptorManager();
        if (!this.myForced) {
            builder.initChildrenArrayRenderer(this);
        }
        if ((array = (ArrayReference)value).length() > 0) {
            int added = 0;
            if (this.ENTRIES_LIMIT > this.END_INDEX - this.START_INDEX + 1) {
                this.ENTRIES_LIMIT = this.END_INDEX - this.START_INDEX;
            }
            if (this.ENTRIES_LIMIT <= 0) {
                this.ENTRIES_LIMIT = 1;
            }
            if (array.length() - 1 >= this.START_INDEX) {
                int idx;
                int start = this.START_INDEX;
                int end = array.length() - 1 < this.END_INDEX ? array.length() - 1 : this.END_INDEX;
                for (idx = start; idx <= end; ++idx) {
                    DebuggerTreeNodeImpl arrayItemNode = nodeManager.createNode(descriptorFactory.getArrayItemDescriptor(builder.getParentDescriptor(), array, idx), evaluationContext);
                    if (arrayItemNode == null) continue;
                    if (ViewsGeneralSettings.getInstance().HIDE_NULL_ARRAY_ELEMENTS) {
                        ValueDescriptorImpl descriptor = (ValueDescriptorImpl)arrayItemNode.getDescriptor();
                        descriptor.setContext((EvaluationContextImpl)evaluationContext);
                        if (descriptor.isNull()) continue;
                    }
                    children.add(arrayItemNode);
                    ++added;
                }
                start = idx;
            }
            if (added == 0) {
                if (this.START_INDEX == 0 && array.length() - 1 <= this.END_INDEX) {
                    children.add(nodeManager.createMessageNode(MessageDescriptor.ALL_ELEMENTS_IN_RANGE_ARE_NULL));
                } else {
                    children.add(nodeManager.createMessageNode(DebuggerBundle.message((String)"message.node.all.array.elements.null", (Object[])new Object[]{this.START_INDEX, this.END_INDEX})));
                }
            } else if (!this.myForced && this.END_INDEX < array.length() - 1) {
                builder.setRemaining(array.length() - 1 - this.END_INDEX);
            }
        }
        builder.setChildren(children);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    @Override
    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) {
        LOG.assertTrue(node.getDescriptor() instanceof ArrayElementDescriptorImpl, (Object)node.getDescriptor().getClass().getName());
        ArrayElementDescriptorImpl descriptor = (ArrayElementDescriptorImpl)node.getDescriptor();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)node.getProject()).getElementFactory();
        try {
            LanguageLevel languageLevel = LanguageLevelProjectExtension.getInstance((Project)node.getProject()).getLanguageLevel();
            return elementFactory.createExpressionFromText("this[" + descriptor.getIndex() + "]", (PsiElement)elementFactory.getArrayClass(languageLevel));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return value instanceof ArrayReference && ((ArrayReference)value).length() > 0;
    }

    @Override
    public boolean isApplicable(Type type) {
        return type instanceof ArrayType;
    }
}

