/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NonNls;

public class HexRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "HexRenderer";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.HexRenderer");

    public HexRenderer() {
        this.setEnabled(false);
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    @NonNls
    public String getName() {
        return "Hex";
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public HexRenderer clone() {
        return (HexRenderer)super.clone();
    }

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) {
        Value value = valueDescriptor.getValue();
        StringBuilder buf = new StringBuilder(16);
        if (value == null) {
            buf.append("null");
        } else if (value instanceof CharValue) {
            buf.append("'");
            buf.append(value.toString());
            buf.append("' ");
            long longValue = ((PrimitiveValue)value).longValue();
            buf.append("0x").append(Long.toHexString(longValue).toUpperCase());
        } else if (value instanceof ByteValue) {
            byte val = ((PrimitiveValue)value).byteValue();
            String strValue = Integer.toHexString(val).toUpperCase();
            if (strValue.length() > 2) {
                strValue = strValue.substring(strValue.length() - 2);
            }
            buf.append("0x").append(strValue);
        } else if (value instanceof ShortValue) {
            short val = ((PrimitiveValue)value).shortValue();
            String strValue = Integer.toHexString(val).toUpperCase();
            if (strValue.length() > 4) {
                strValue = strValue.substring(strValue.length() - 4);
            }
            buf.append("0x").append(strValue);
        } else if (value instanceof IntegerValue) {
            int val = ((PrimitiveValue)value).intValue();
            buf.append("0x").append(Integer.toHexString(val).toUpperCase());
        } else if (value instanceof LongValue) {
            long val = ((PrimitiveValue)value).longValue();
            buf.append("0x").append(Long.toHexString(val).toUpperCase());
        } else {
            LOG.assertTrue(false);
        }
        return buf.toString();
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
    }

    @Override
    public boolean isApplicable(Type t) {
        if (t == null) {
            return false;
        }
        return t instanceof CharType || t instanceof ByteType || t instanceof ShortType || t instanceof IntegerType || t instanceof LongType;
    }

    @Override
    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) {
        LOG.assertTrue(false);
        return null;
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return false;
    }
}

