/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EnvironmentVariablesComponent
extends LabeledComponent<TextFieldWithBrowseButton>
implements UserActivityProviderComponent {
    @NonNls
    private static final String ENVS = "envs";
    @NonNls
    public static final String ENV = "env";
    @NonNls
    public static final String NAME = "name";
    @NonNls
    public static final String VALUE = "value";
    @NonNls
    private static final String OPTION = "option";
    @NonNls
    private static final String ENV_VARIABLES = "ENV_VARIABLES";
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVars = new EnvironmentVariablesTextFieldWithBrowseButton();

    public EnvironmentVariablesComponent() {
        this.setComponent((JComponent)((Object)this.myEnvVars));
        this.setText(ExecutionBundle.message((String)"environment.variables.component.title", (Object[])new Object[0]));
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ENVS, "com/intellij/execution/configuration/EnvironmentVariablesComponent", "setEnvs"));
        }
        this.myEnvVars.setEnvs(envs);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myEnvVars.getEnvs();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesComponent", "getEnvs"));
        }
        return map;
    }

    public boolean isPassParentEnvs() {
        return this.myEnvVars.isPassParentEnvs();
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myEnvVars.setPassParentEnvs(passParentEnvs);
    }

    public static void readExternal(Element element, Map<String, String> envs) {
        Element envsElement = element.getChild(ENVS);
        if (envsElement != null) {
            Iterator i$ = envsElement.getChildren(ENV).iterator();
            while (i$.hasNext()) {
                Element o;
                Element envElement = o = (Element)i$.next();
                String envName = envElement.getAttributeValue(NAME);
                String envValue = envElement.getAttributeValue(VALUE);
                if (envName == null || envValue == null) continue;
                envs.put(envName, envValue);
            }
        } else {
            for (Element o : element.getChildren(OPTION)) {
                if (!Comparing.strEqual((String)o.getAttributeValue(NAME), (String)ENV_VARIABLES)) continue;
                EnvironmentVariablesComponent.splitVars(envs, o.getAttributeValue(VALUE));
                break;
            }
        }
    }

    private static void splitVars(Map<String, String> envs, String val) {
        if (val != null) {
            String[] envVars;
            for (String envVar : envVars = val.split(";")) {
                int idx = envVar.indexOf(61);
                if (idx <= -1) continue;
                envs.put(envVar.substring(0, idx), idx < envVar.length() - 1 ? envVar.substring(idx + 1) : "");
            }
        }
    }

    public static void writeExternal(Element element, Map<String, String> envs) {
        Element envsElement = new Element(ENVS);
        for (String envName : envs.keySet()) {
            Element envElement = new Element(ENV);
            envElement.setAttribute(NAME, envName);
            envElement.setAttribute(VALUE, envs.get(envName));
            envsElement.addContent(envElement);
        }
        element.addContent(envsElement);
    }

    @Deprecated
    public static void inlineParentOccurrences(Map<String, String> envs) {
        EnvironmentUtil.inlineParentOccurrences(envs);
    }

    @Deprecated
    public static boolean containsEnvKeySubstitution(String envKey, String val) {
        return ArrayUtil.find((Object[])val.split(File.pathSeparator), (Object)("$" + envKey + "$")) != -1;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.myEnvVars.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.myEnvVars.removeChangeListener(changeListener);
    }
}

