/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.impl.ConsoleState;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class ConsoleViewRunningState
extends ConsoleState {
    private final ConsoleViewImpl myConsole;
    private final ProcessHandler myProcessHandler;
    private final ConsoleState myFinishedStated;
    private final Writer myUserInputWriter;
    private final ProcessAdapter myProcessListener = new ProcessAdapter(){

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            ConsoleViewRunningState.this.myConsole.print(event.getText(), ConsoleViewContentType.getConsoleViewType((Key)outputType));
        }
    };

    public ConsoleViewRunningState(ConsoleViewImpl console, ProcessHandler processHandler, ConsoleState finishedStated, boolean attachToStdOut, boolean attachToStdIn) {
        OutputStream processInput;
        this.myConsole = console;
        this.myProcessHandler = processHandler;
        this.myFinishedStated = finishedStated;
        if (attachToStdOut) {
            processHandler.addProcessListener((ProcessListener)this.myProcessListener);
        }
        this.myUserInputWriter = attachToStdIn ? ((processInput = this.myProcessHandler.getProcessInput()) != null ? ConsoleViewRunningState.createOutputStreamWriter(processInput, processHandler) : null) : null;
    }

    private static OutputStreamWriter createOutputStreamWriter(OutputStream processInput, ProcessHandler processHandler) {
        Charset charset = null;
        if (processHandler instanceof OSProcessHandler) {
            charset = ((OSProcessHandler)processHandler).getCharset();
        }
        if (charset == null) {
            charset = (Charset)ObjectUtils.notNull((Object)EncodingManager.getInstance().getDefaultCharset(), (Object)CharsetToolkit.UTF8_CHARSET);
        }
        return new OutputStreamWriter(processInput, charset);
    }

    @Override
    @NotNull
    public ConsoleState dispose() {
        if (this.myProcessHandler != null) {
            this.myProcessHandler.removeProcessListener((ProcessListener)this.myProcessListener);
        }
        ConsoleState consoleState = this.myFinishedStated;
        if (consoleState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewRunningState", "dispose"));
        }
        return consoleState;
    }

    @Override
    public boolean isFinished() {
        return this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated();
    }

    @Override
    public boolean isRunning() {
        return this.myProcessHandler != null && !this.myProcessHandler.isProcessTerminated();
    }

    @Override
    public void sendUserInput(String input) throws IOException {
        if (this.myUserInputWriter == null) {
            throw new IOException(ExecutionBundle.message((String)"no.user.process.input.error.message", (Object[])new Object[0]));
        }
        this.myUserInputWriter.write(input);
        this.myUserInputWriter.flush();
    }

    @Override
    public ConsoleState attachTo(ConsoleViewImpl console, ProcessHandler processHandler) {
        return this.dispose().attachTo(console, processHandler);
    }

    public String toString() {
        return "Running state";
    }
}

