/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestIgnoredEvent
extends TreeNodeEvent {
    private final String myIgnoreComment;
    private final String myStacktrace;

    public TestIgnoredEvent(@NotNull String testName, @NotNull String ignoreComment, @Nullable String stacktrace) {
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/intellij/execution/testframework/sm/runner/events/TestIgnoredEvent", "<init>"));
        }
        if (ignoreComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoreComment", "com/intellij/execution/testframework/sm/runner/events/TestIgnoredEvent", "<init>"));
        }
        super(testName, -1);
        this.myIgnoreComment = ignoreComment;
        this.myStacktrace = stacktrace;
    }

    public TestIgnoredEvent(@NotNull TestIgnored testIgnored, @Nullable String stacktrace) {
        if (testIgnored == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testIgnored", "com/intellij/execution/testframework/sm/runner/events/TestIgnoredEvent", "<init>"));
        }
        super(testIgnored.getTestName(), TreeNodeEvent.getNodeId((ServiceMessage)testIgnored));
        this.myIgnoreComment = testIgnored.getIgnoreComment();
        this.myStacktrace = stacktrace;
    }

    @Nullable
    public String getIgnoreComment() {
        return this.myIgnoreComment;
    }

    @Nullable
    public String getStacktrace() {
        return this.myStacktrace;
    }

    @Override
    protected void appendToStringInfo(@NotNull StringBuilder buf) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/execution/testframework/sm/runner/events/TestIgnoredEvent", "appendToStringInfo"));
        }
        TestIgnoredEvent.append(buf, "ignoreComment", this.myIgnoreComment);
        TestIgnoredEvent.append(buf, "stacktrace", this.myStacktrace);
    }
}

