/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.PathUtilEx;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.List;
import java.util.Map;

public class JavaParametersUtil {
    private JavaParametersUtil() {
    }

    public static void configureConfiguration(SimpleJavaParameters parameters, CommonJavaRunConfigurationParameters configuration) {
        ProgramParametersUtil.configureConfiguration((SimpleProgramParameters)parameters, configuration);
        Project project = configuration.getProject();
        Module module = ProgramParametersUtil.getModule(configuration);
        String vmParameters = configuration.getVMParameters();
        if (vmParameters != null) {
            vmParameters = ProgramParametersUtil.expandPath(vmParameters, module, project);
            for (Map.Entry each : parameters.getEnv().entrySet()) {
                vmParameters = StringUtil.replace((String)vmParameters, (String)("$" + (String)each.getKey() + "$"), (String)((String)each.getValue()), (boolean)false);
            }
        }
        parameters.getVMParametersList().addParametersString(vmParameters);
    }

    public static int getClasspathType(RunConfigurationModule configurationModule, String mainClassName, boolean classMustHaveSource) throws CantRunException {
        ModuleFileIndex fileIndex;
        Module classModule;
        Module module = configurationModule.getModule();
        if (module == null) {
            throw CantRunException.noModuleConfigured((String)configurationModule.getModuleName());
        }
        PsiClass psiClass = JavaExecutionUtil.findMainClass((Module)module, (String)mainClassName);
        if (psiClass == null) {
            if (!classMustHaveSource) {
                return 7;
            }
            throw CantRunException.classNotFound((String)mainClassName, (Module)module);
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            throw CantRunException.classNotFound((String)mainClassName, (Module)module);
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            throw CantRunException.classNotFound((String)mainClassName, (Module)module);
        }
        Module module2 = classModule = psiClass.isValid() ? ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass) : null;
        if (classModule == null) {
            classModule = module;
        }
        if ((fileIndex = ModuleRootManager.getInstance((Module)classModule).getFileIndex()).isInSourceContent(virtualFile)) {
            return fileIndex.isInTestSourceContent(virtualFile) ? 7 : 3;
        }
        List entriesForFile = fileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry entry : entriesForFile) {
            if (!(entry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entry).getScope() != DependencyScope.TEST) continue;
            return 7;
        }
        return 3;
    }

    public static void configureModule(RunConfigurationModule runConfigurationModule, JavaParameters parameters, int classPathType, String jreHome) throws CantRunException {
        Module module = runConfigurationModule.getModule();
        if (module == null) {
            throw CantRunException.noModuleConfigured((String)runConfigurationModule.getModuleName());
        }
        JavaParametersUtil.configureModule(module, parameters, classPathType, jreHome);
    }

    public static void configureModule(Module module, JavaParameters parameters, int classPathType, String jreHome) throws CantRunException {
        parameters.configureByModule(module, classPathType, JavaParametersUtil.createModuleJdk(module, jreHome));
    }

    public static void configureProject(Project project, JavaParameters parameters, int classPathType, String jreHome) throws CantRunException {
        parameters.configureByProject(project, classPathType, JavaParametersUtil.createProjectJdk(project, jreHome));
    }

    private static Sdk createModuleJdk(Module module, String jreHome) throws CantRunException {
        return jreHome == null ? JavaParameters.getModuleJdk((Module)module) : JavaParametersUtil.createAlternativeJdk(jreHome);
    }

    public static Sdk createProjectJdk(Project project, String jreHome) throws CantRunException {
        return jreHome == null ? JavaParametersUtil.createProjectJdk(project) : JavaParametersUtil.createAlternativeJdk(jreHome);
    }

    private static Sdk createProjectJdk(Project project) throws CantRunException {
        Sdk jdk = PathUtilEx.getAnyJdk(project);
        if (jdk == null) {
            throw CantRunException.noJdkConfigured();
        }
        return jdk;
    }

    private static Sdk createAlternativeJdk(String jreHome) throws CantRunException {
        Sdk configuredJdk = ProjectJdkTable.getInstance().findJdk(jreHome);
        if (configuredJdk != null) {
            return configuredJdk;
        }
        boolean isJdk = JavaSdk.checkForJdk((File)new File(jreHome));
        if (isJdk) {
            throw new CantRunException("Jre expected but jdk found");
        }
        Sdk jdk = JavaSdk.getInstance().createJdk("", jreHome);
        if (jdk == null) {
            throw CantRunException.noJdkConfigured();
        }
        return jdk;
    }

    public static void checkAlternativeJRE(CommonJavaRunConfigurationParameters configuration) throws RuntimeConfigurationWarning {
        String alternativeJrePath;
        if (configuration.isAlternativeJrePathEnabled() && ((alternativeJrePath = configuration.getAlternativeJrePath()) == null || alternativeJrePath.length() == 0 || ProjectJdkTable.getInstance().findJdk(alternativeJrePath) == null && !JavaSdk.checkForJre((String)alternativeJrePath))) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.mesage", (Object[])new Object[]{alternativeJrePath}));
        }
    }
}

