/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class CreateLauncherScriptAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(CreateLauncherScriptAction.class);
    private static final String CONTENTS = "/Contents";

    public static boolean isAvailable() {
        return SystemInfo.isUnix;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/CreateLauncherScriptAction", "update"));
        }
        boolean canCreateScript = CreateLauncherScriptAction.isAvailable();
        Presentation presentation = e.getPresentation();
        presentation.setVisible(canCreateScript);
        presentation.setEnabled(canCreateScript);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String title;
        String message;
        String home;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/CreateLauncherScriptAction", "actionPerformed"));
        }
        if (!CreateLauncherScriptAction.isAvailable()) {
            return;
        }
        Project project = e.getProject();
        CreateLauncherScriptDialog dialog = new CreateLauncherScriptDialog(project);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        String path = dialog.myPathField.getText();
        assert (path != null);
        if (!path.startsWith("/") && (home = System.getenv("HOME")) != null && new File(home).isDirectory()) {
            path = path.startsWith("~") ? home + path.substring(1) : home + "/" + path;
        }
        String name = dialog.myNameField.getText();
        assert (name != null);
        File target = new File(path, name);
        if (target.exists() && Messages.showOkCancelDialog((Project)project, (String)(message = ApplicationBundle.message((String)"launcher.script.overwrite", (Object[])new Object[]{target})), (String)(title = ApplicationBundle.message((String)"launcher.script.title", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon()) != 0) {
            return;
        }
        CreateLauncherScriptAction.createLauncherScript(project, target.getAbsolutePath());
    }

    public static void createLauncherScript(Project project, String pathName) {
        if (!CreateLauncherScriptAction.isAvailable()) {
            return;
        }
        try {
            File scriptFile = CreateLauncherScriptAction.createLauncherScriptFile();
            File scriptTarget = new File(pathName);
            File scriptTargetDir = scriptTarget.getParentFile();
            assert (scriptTargetDir != null);
            if (!scriptTargetDir.exists() && !scriptTargetDir.mkdirs() || !scriptFile.renameTo(scriptTarget)) {
                String scriptTargetDirPath = scriptTargetDir.getCanonicalPath();
                String installationScriptSrc = "#!/bin/sh\nmkdir -p \"" + scriptTargetDirPath + "\"\n" + "install -g 0 -o 0 \"" + scriptFile.getCanonicalPath() + "\" \"" + pathName + "\"";
                File installationScript = ExecUtil.createTempExecutableScript((String)"launcher_installer", (String)".sh", (String)installationScriptSrc);
                String prompt = ApplicationBundle.message((String)"launcher.script.sudo.prompt", (Object[])new Object[]{scriptTargetDirPath});
                ExecUtil.sudoAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{installationScript.getPath()}), (String)prompt);
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (!StringUtil.isEmptyOrSpaces((String)message)) {
                LOG.warn((Throwable)e);
                Notifications.Bus.notify((Notification)new Notification("System Messages", "Failed to create launcher script", message, NotificationType.ERROR), (Project)project);
            }
            LOG.error((Throwable)e);
        }
    }

    private static File createLauncherScriptFile() throws IOException, ExecutionException {
        String runPath = PathManager.getHomePath();
        String productName = ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.US);
        if (!SystemInfo.isMac) {
            runPath = runPath + "/bin/" + productName + ".sh";
        } else if (runPath.endsWith(CONTENTS)) {
            runPath = runPath.substring(0, runPath.length() - CONTENTS.length());
        }
        ClassLoader loader = CreateLauncherScriptAction.class.getClassLoader();
        assert (loader != null);
        Map variables = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"$CONFIG_PATH$", (Object)PathManager.getConfigPath()), (Pair[])new Pair[]{Pair.pair((Object)"$RUN_PATH$", (Object)runPath)});
        String launcherContents = StringUtil.convertLineSeparators((String)ExecUtil.loadTemplate((ClassLoader)loader, (String)"launcher.py", (Map)variables));
        return ExecUtil.createTempExecutableScript((String)"launcher", (String)"", (String)launcherContents);
    }

    public static String defaultScriptName() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        return StringUtil.isEmptyOrSpaces((String)scriptName) ? "idea" : scriptName;
    }

    public static class CreateLauncherScriptDialog
    extends DialogWrapper {
        private JPanel myMainPanel;
        private JTextField myNameField;
        private JTextField myPathField;
        private JLabel myTitle;

        protected CreateLauncherScriptDialog(Project project) {
            super(project);
            this.$$$setupUI$$$();
            this.init();
            this.setTitle(ApplicationBundle.message((String)"launcher.script.title", (Object[])new Object[0]));
            String productName = ApplicationNamesInfo.getInstance().getProductName();
            this.myTitle.setText(this.myTitle.getText().replace("$APP_NAME$", productName));
            this.myNameField.setText(CreateLauncherScriptAction.defaultScriptName());
        }

        protected JComponent createCenterPanel() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTextField jTextField;
            JTextField jTextField2;
            JLabel jLabel;
            JPanel jPanel;
            this.myMainPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myTitle = jLabel = new JLabel();
            jLabel.setText("<html>You can create a launcher script to enable opening files and projects in $APP_NAME$ from the command line.<br> Please specify the name of the script and the path where it should be created:</html>");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText("Name:");
            jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myNameField = jTextField2 = new JTextField();
            jTextField2.setText("idea");
            jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            JLabel jLabel3 = new JLabel();
            jLabel3.setText("Path:");
            jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myPathField = jTextField = new JTextField();
            jTextField.setText("/usr/local/bin");
            jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }
    }
}

