/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockLanguageFileType;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileTypeManager
extends FileTypeManagerEx {
    private FileType fileType;

    public MockFileTypeManager(FileType fileType) {
        this.fileType = fileType;
    }

    @Override
    public void registerFileType(FileType fileType) {
    }

    @Override
    public void unregisterFileType(FileType fileType) {
    }

    @NotNull
    public String getIgnoredFilesList() {
        throw new IncorrectOperationException();
    }

    public void setIgnoredFilesList(@NotNull String list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/mock/MockFileTypeManager", "setIgnoredFilesList"));
        }
    }

    @Override
    public boolean isIgnoredFilesListEqualToCurrent(String list) {
        return false;
    }

    public void save() {
    }

    @Override
    @NotNull
    public String getExtension(String fileName) {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getExtension"));
        }
        return "";
    }

    public void registerFileType(@NotNull FileType type, @NotNull List<FileNameMatcher> defaultAssociations) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/mock/MockFileTypeManager", "registerFileType"));
        }
        if (defaultAssociations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultAssociations", "com/intellij/mock/MockFileTypeManager", "registerFileType"));
        }
    }

    @Override
    public void fireFileTypesChanged() {
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/mock/MockFileTypeManager", "getFileTypeByFileName"));
        }
        FileType fileType = this.fileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getFileTypeByFileName"));
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileTypeManager", "getFileTypeByFile"));
        }
        FileType fileType = this.fileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getFileTypeByFile"));
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/mock/MockFileTypeManager", "getFileTypeByExtension"));
        }
        FileType fileType = this.fileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getFileTypeByExtension"));
        }
        return fileType;
    }

    @NotNull
    public FileType[] getRegisteredFileTypes() {
        if (FileType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getRegisteredFileTypes"));
        }
        return FileType.EMPTY_ARRAY;
    }

    public boolean isFileIgnored(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockFileTypeManager", "isFileIgnored"));
        }
        return false;
    }

    public boolean isFileIgnored(@NonNls @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileTypeManager", "isFileIgnored"));
        }
        return false;
    }

    @NotNull
    public String[] getAssociatedExtensions(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/mock/MockFileTypeManager", "getAssociatedExtensions"));
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getAssociatedExtensions"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public void fireBeforeFileTypesChanged() {
    }

    public void addFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockFileTypeManager", "addFileTypeListener"));
        }
    }

    public void removeFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockFileTypeManager", "removeFileTypeListener"));
        }
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileTypeManager", "getKnownFileTypeOrAssociate"));
        }
        return file.getFileType();
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileTypeManager", "getKnownFileTypeOrAssociate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/mock/MockFileTypeManager", "getKnownFileTypeOrAssociate"));
        }
        return this.getKnownFileTypeOrAssociate(file);
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/mock/MockFileTypeManager", "getAssociations"));
        }
        List<FileNameMatcher> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getAssociations"));
        }
        return list;
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/mock/MockFileTypeManager", "associate"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/mock/MockFileTypeManager", "associate"));
        }
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/mock/MockFileTypeManager", "removeAssociation"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/mock/MockFileTypeManager", "removeAssociation"));
        }
    }

    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String fileTypeName) {
        if (fileTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeName", "com/intellij/mock/MockFileTypeManager", "getStdFileType"));
        }
        if ("ARCHIVE".equals(fileTypeName) || "CLASS".equals(fileTypeName)) {
            FileType fileType = UnknownFileType.INSTANCE;
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getStdFileType"));
            }
            return fileType;
        }
        if ("PLAIN_TEXT".equals(fileTypeName)) {
            PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
            if (plainTextFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getStdFileType"));
            }
            return plainTextFileType;
        }
        if ("JAVA".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JavaFileType", fileTypeName);
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getStdFileType"));
            }
            return fileType;
        }
        if ("XML".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.XmlFileType", fileTypeName);
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getStdFileType"));
            }
            return fileType;
        }
        if ("DTD".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.DTDFileType", fileTypeName);
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getStdFileType"));
            }
            return fileType;
        }
        if ("JSP".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.NewJspFileType", fileTypeName);
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getStdFileType"));
            }
            return fileType;
        }
        if ("JSPX".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JspxFileType", fileTypeName);
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getStdFileType"));
            }
            return fileType;
        }
        if ("HTML".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.HtmlFileType", fileTypeName);
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getStdFileType"));
            }
            return fileType;
        }
        if ("XHTML".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.XHtmlFileType", fileTypeName);
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getStdFileType"));
            }
            return fileType;
        }
        if ("JavaScript".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.lang.javascript.JavaScriptFileType", fileTypeName);
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getStdFileType"));
            }
            return fileType;
        }
        if ("Properties".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.lang.properties.PropertiesFileType", fileTypeName);
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getStdFileType"));
            }
            return fileType;
        }
        MockLanguageFileType mockLanguageFileType = new MockLanguageFileType(PlainTextLanguage.INSTANCE, fileTypeName.toLowerCase());
        if (mockLanguageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "getStdFileType"));
        }
        return mockLanguageFileType;
    }

    private static FileType loadFileTypeSafe(String className, String fileTypeName) {
        try {
            return (FileType)Class.forName(className).getField("INSTANCE").get(null);
        }
        catch (Exception e) {
            return new MockLanguageFileType(PlainTextLanguage.INSTANCE, fileTypeName.toLowerCase());
        }
    }

    @Override
    public SchemesManager<FileType, AbstractFileType> getSchemesManager() {
        return SchemesManager.EMPTY;
    }

    public boolean isFileOfType(@NotNull VirtualFile file, @NotNull FileType type) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileTypeManager", "isFileOfType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/mock/MockFileTypeManager", "isFileOfType"));
        }
        return false;
    }

    @NotNull
    public FileType detectFileTypeFromContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileTypeManager", "detectFileTypeFromContent"));
        }
        FileType fileType = UnknownFileType.INSTANCE;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileTypeManager", "detectFileTypeFromContent"));
        }
        return fileType;
    }

    @Nullable
    public FileType findFileTypeByName(String fileTypeName) {
        return null;
    }
}

