/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ModuleStoreImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StateStorageManagerImpl;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.module.impl.ModuleImpl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

class ModuleStateStorageManager
extends StateStorageManagerImpl {
    @NonNls
    private static final String ROOT_TAG_NAME = "module";
    private final ModuleImpl myModule;

    public ModuleStateStorageManager(@Nullable TrackingPathMacroSubstitutor pathMacroManager, @NotNull ModuleImpl module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ROOT_TAG_NAME, "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "<init>"));
        }
        super(pathMacroManager, ROOT_TAG_NAME, (Disposable)module, (PicoContainer)module.getPicoContainer());
        this.myModule = module;
    }

    @Override
    protected StorageData createStorageData(@NotNull String storageSpec) {
        if (storageSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageSpec", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "createStorageData"));
        }
        return new ModuleStoreImpl.ModuleFileData(ROOT_TAG_NAME, this.myModule);
    }

    @Override
    @NotNull
    public StateStorageManager.ExternalizationSession startExternalization() {
        StateStorageManagerImpl.StateStorageManagerExternalizationSession stateStorageManagerExternalizationSession = new StateStorageManagerImpl.StateStorageManagerExternalizationSession(){

            @Override
            @Nullable
            public StateStorage.SaveSession createSaveSession() {
                final ModuleStoreImpl.ModuleFileData data = ((ModuleStoreImpl)ModuleStateStorageManager.this.myModule.getStateStore()).getMainStorageData();
                final StateStorage.SaveSession session = super.createSaveSession();
                if (!data.isDirty()) {
                    return session;
                }
                return new StateStorage.SaveSession(){

                    public void save() {
                        if (session != null) {
                            session.save();
                        }
                        if (data.isDirty()) {
                            ((ModuleStoreImpl)ModuleStateStorageManager.this.myModule.getStateStore()).getMainStorage().forceSave();
                        }
                    }
                };
            }
        };
        if (stateStorageManagerExternalizationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "startExternalization"));
        }
        return stateStorageManagerExternalizationSession;
    }

    @Override
    @Nullable
    protected String getOldStorageSpec(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "getOldStorageSpec"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "getOldStorageSpec"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "getOldStorageSpec"));
        }
        return "$MODULE_FILE$";
    }

    @Override
    protected String getVersionsFilePath() {
        return PathManager.getConfigPath() + "/componentVersions/" + ROOT_TAG_NAME + this.getLocationHash() + ".xml";
    }

    private String getLocationHash() {
        return this.myModule.getName() + Integer.toHexString(this.myModule.getModuleFilePath().hashCode());
    }

    @Override
    @NotNull
    protected StateStorage.Listener createStorageTopicListener() {
        StateStorage.Listener listener = (StateStorage.Listener)this.myModule.getProject().getMessageBus().syncPublisher(StateStorage.PROJECT_STORAGE_TOPIC);
        if (listener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "createStorageTopicListener"));
        }
        return listener;
    }
}

