/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ProjectStoreImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManagerImpl;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.project.impl.ProjectImpl;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

class ProjectStateStorageManager
extends StateStorageManagerImpl {
    protected final ProjectImpl myProject;
    @NonNls
    protected static final String ROOT_TAG_NAME = "project";

    public ProjectStateStorageManager(TrackingPathMacroSubstitutor macroSubstitutor, ProjectImpl project) {
        super(macroSubstitutor, ROOT_TAG_NAME, (Disposable)project, (PicoContainer)project.getPicoContainer());
        this.myProject = project;
    }

    @Override
    protected StorageData createStorageData(@NotNull String storageSpec) {
        if (storageSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageSpec", "com/intellij/openapi/components/impl/stores/ProjectStateStorageManager", "createStorageData"));
        }
        if (storageSpec.equals("$PROJECT_FILE$")) {
            return this.createIprStorageData();
        }
        if (storageSpec.equals("$WORKSPACE_FILE$")) {
            return this.createWsStorageData();
        }
        return new ProjectStoreImpl.ProjectStorageData(ROOT_TAG_NAME, this.myProject);
    }

    public StorageData createWsStorageData() {
        return new ProjectStoreImpl.WsStorageData(ROOT_TAG_NAME, this.myProject);
    }

    public StorageData createIprStorageData() {
        return new ProjectStoreImpl.IprStorageData(ROOT_TAG_NAME, this.myProject);
    }

    @Override
    @Nullable
    protected String getOldStorageSpec(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ProjectStateStorageManager", "getOldStorageSpec"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ProjectStateStorageManager", "getOldStorageSpec"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/components/impl/stores/ProjectStateStorageManager", "getOldStorageSpec"));
        }
        ComponentConfig config = this.myProject.getConfig(component.getClass());
        assert (config != null) : "Couldn't find old storage for " + component.getClass().getName();
        boolean workspace = ProjectStateStorageManager.isWorkspace(config.options);
        String fileSpec = workspace ? "$WORKSPACE_FILE$" : "$PROJECT_FILE$";
        StateStorage storage = this.getStateStorage(fileSpec, workspace ? RoamingType.DISABLED : RoamingType.PER_USER);
        if (operation == StateStorageOperation.READ && storage != null && workspace && !storage.hasState(component, componentName, Element.class, false)) {
            fileSpec = "$PROJECT_FILE$";
        }
        return fileSpec;
    }

    @Override
    protected String getVersionsFilePath() {
        return PathManager.getConfigPath() + "/componentVersions/" + ROOT_TAG_NAME + this.myProject.getLocationHash() + ".xml";
    }

    private static boolean isWorkspace(Map options) {
        return options != null && Boolean.parseBoolean((String)options.get("workspace"));
    }

    @Override
    @NotNull
    protected StateStorage.Listener createStorageTopicListener() {
        StateStorage.Listener listener = (StateStorage.Listener)this.myProject.getMessageBus().syncPublisher(StateStorage.PROJECT_STORAGE_TOPIC);
        if (listener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStateStorageManager", "createStorageTopicListener"));
        }
        return listener;
    }
}

