/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentStoreImpl;
import com.intellij.openapi.components.impl.stores.ModuleStoreImpl;
import com.intellij.openapi.components.impl.stores.ProjectStoreImpl;
import com.intellij.openapi.components.store.ComponentSaveSession;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectWithModulesStoreImpl
extends ProjectStoreImpl {
    public ProjectWithModulesStoreImpl(@NotNull ProjectImpl project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl", "<init>"));
        }
        super(project);
    }

    @Override
    protected boolean reinitComponent(@NotNull String componentName, boolean reloadData) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl", "reinitComponent"));
        }
        if (super.reinitComponent(componentName, reloadData)) {
            return true;
        }
        for (Module module : this.getPersistentModules()) {
            ((ModuleStoreImpl)((ModuleImpl)module).getStateStore()).reinitComponent(componentName, reloadData);
        }
        return true;
    }

    @Override
    public TrackingPathMacroSubstitutor[] getSubstitutors() {
        SmartList result = new SmartList();
        ContainerUtil.addIfNotNull((Collection)result, (Object)this.getStateStorageManager().getMacroSubstitutor());
        for (Module module : this.getPersistentModules()) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)((ModuleImpl)module).getStateStore().getStateStorageManager().getMacroSubstitutor());
        }
        return result.toArray(new TrackingPathMacroSubstitutor[result.size()]);
    }

    @Override
    public boolean isReloadPossible(@NotNull Set<String> componentNames) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl", "isReloadPossible"));
        }
        if (!super.isReloadPossible(componentNames)) {
            return false;
        }
        for (Module module : this.getPersistentModules()) {
            if (((ModuleImpl)module).getStateStore().isReloadPossible(componentNames)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected Module[] getPersistentModules() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] moduleArray = moduleManager == null ? Module.EMPTY_ARRAY : moduleManager.getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl", "getPersistentModules"));
        }
        return moduleArray;
    }

    @Override
    protected ComponentStoreImpl.SaveSessionImpl createSaveSession(@Nullable StateStorage.SaveSession storageManagerSaveSession) {
        SmartList moduleSaveSessions = new SmartList();
        for (Module module : this.getPersistentModules()) {
            ContainerUtil.addIfNotNull((Collection)moduleSaveSessions, (Object)((ModuleImpl)module).getStateStore().startSave());
        }
        if (moduleSaveSessions.isEmpty()) {
            return super.createSaveSession(storageManagerSaveSession);
        }
        return new ProjectWithModulesSaveSession(storageManagerSaveSession, (List<ComponentSaveSession>)moduleSaveSessions);
    }

    private class ProjectWithModulesSaveSession
    extends ProjectStoreImpl.ProjectSaveSession {
        private final List<ComponentSaveSession> myModuleSaveSessions;

        public ProjectWithModulesSaveSession(@NotNull StateStorage.SaveSession storageManagerSaveSession, List<ComponentSaveSession> moduleSaveSessions) {
            if (moduleSaveSessions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleSaveSessions", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl$ProjectWithModulesSaveSession", "<init>"));
            }
            super(ProjectWithModulesStoreImpl.this, storageManagerSaveSession);
            this.myModuleSaveSessions = moduleSaveSessions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishSave() {
            try {
                Throwable first = null;
                for (ComponentSaveSession moduleSaveSession : this.myModuleSaveSessions) {
                    try {
                        moduleSaveSession.finishSave();
                    }
                    catch (Throwable e) {
                        if (first != null) continue;
                        first = e;
                    }
                }
                if (first != null) {
                    throw new RuntimeException(first);
                }
            }
            finally {
                super.finishSave();
            }
        }

        @Override
        protected void beforeSave(@NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
            if (readonlyFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readonlyFiles", "com/intellij/openapi/components/impl/stores/ProjectWithModulesStoreImpl$ProjectWithModulesSaveSession", "beforeSave"));
            }
            super.beforeSave(readonlyFiles);
            for (ComponentSaveSession moduleSaveSession : this.myModuleSaveSessions) {
                moduleSaveSession.save(readonlyFiles);
            }
        }
    }
}

