/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextField;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class KeyboardShortcutDialog
extends DialogWrapper {
    private StrokePanel myFirstStrokePanel;
    private StrokePanel mySecondStrokePanel;
    private final JCheckBox myEnableSecondKeystroke;
    private final JLabel myKeystrokePreview;
    private final JTextArea myConflictInfoArea;
    private Keymap myKeymap;
    private final String myActionId;
    private final Group myMainGroup;

    public KeyboardShortcutDialog(Component component, String actionId, QuickList[] quickLists) {
        super(component, true);
        this.setTitle(KeyMapBundle.message((String)"keyboard.shortcut.dialog.title", (Object[])new Object[0]));
        this.myActionId = actionId;
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(component));
        this.myMainGroup = ActionsTreeUtil.createMainGroup(project, this.myKeymap, quickLists, null, false, null);
        this.myEnableSecondKeystroke = new JCheckBox();
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myEnableSecondKeystroke);
        this.myEnableSecondKeystroke.setBorder(new EmptyBorder(4, 0, 0, 2));
        this.myEnableSecondKeystroke.setFocusable(false);
        this.myKeystrokePreview = new JLabel(" ");
        this.myConflictInfoArea = new JTextArea("");
        this.myConflictInfoArea.setFocusable(false);
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeyboardShortcutDialog", "createActions"));
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.myFirstStrokePanel = new StrokePanel(KeyMapBundle.message((String)"first.stroke.panel.title", (Object[])new Object[0]));
        panel.add((Component)this.myFirstStrokePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.myEnableSecondKeystroke, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mySecondStrokePanel = new StrokePanel(KeyMapBundle.message((String)"second.stroke.panel.title", (Object[])new Object[0]));
        panel.add((Component)this.mySecondStrokePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)KeyMapBundle.message((String)"shortcut.preview.ide.border.factory.title", (Object[])new Object[0]), (boolean)true));
        previewPanel.add(this.myKeystrokePreview);
        panel.add((Component)previewPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel conflictsPanel = new JPanel(new BorderLayout());
        conflictsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)KeyMapBundle.message((String)"conflicts.ide.border.factory.title", (Object[])new Object[0]), (boolean)true));
        this.myConflictInfoArea.setEditable(false);
        this.myConflictInfoArea.setBackground(panel.getBackground());
        this.myConflictInfoArea.setLineWrap(true);
        this.myConflictInfoArea.setWrapStyleWord(true);
        JScrollPane conflictInfoScroll = ScrollPaneFactory.createScrollPane((Component)this.myConflictInfoArea);
        conflictInfoScroll.setPreferredSize(new Dimension(260, 60));
        conflictInfoScroll.setBorder(null);
        conflictsPanel.add(conflictInfoScroll);
        panel.add((Component)conflictsPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myEnableSecondKeystroke.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardShortcutDialog.this.handleSecondKey();
                KeyboardShortcutDialog.this.updateCurrentKeyStrokeInfo();
                if (KeyboardShortcutDialog.this.myEnableSecondKeystroke.isSelected()) {
                    KeyboardShortcutDialog.this.mySecondStrokePanel.getShortcutTextField().requestFocus();
                } else {
                    KeyboardShortcutDialog.this.myFirstStrokePanel.getShortcutTextField().requestFocus();
                }
            }
        });
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myFirstStrokePanel);
    }

    public void setData(Keymap keymap, KeyboardShortcut shortcut) {
        this.myKeymap = keymap;
        this.myEnableSecondKeystroke.setSelected(false);
        if (shortcut != null) {
            this.myFirstStrokePanel.getShortcutTextField().setKeyStroke(shortcut.getFirstKeyStroke());
            if (shortcut.getSecondKeyStroke() != null) {
                this.myEnableSecondKeystroke.setSelected(true);
                this.mySecondStrokePanel.getShortcutTextField().setKeyStroke(shortcut.getSecondKeyStroke());
            }
        }
        this.handleSecondKey();
        this.updateCurrentKeyStrokeInfo();
    }

    private void updateCurrentKeyStrokeInfo() {
        if (this.myConflictInfoArea == null || this.myKeystrokePreview == null) {
            return;
        }
        this.myConflictInfoArea.setText(null);
        this.myKeystrokePreview.setText(" ");
        if (this.myKeymap == null) {
            return;
        }
        KeyboardShortcut keyboardShortcut = this.getKeyboardShortcut();
        if (keyboardShortcut == null) {
            return;
        }
        String strokeText = KeyboardShortcutDialog.getTextByKeyStroke(keyboardShortcut.getFirstKeyStroke());
        String suffixText = KeyboardShortcutDialog.getTextByKeyStroke(keyboardShortcut.getSecondKeyStroke());
        if (suffixText != null && suffixText.length() > 0) {
            strokeText = strokeText + ',' + suffixText;
        }
        this.myKeystrokePreview.setText(strokeText);
        StringBuffer buffer = new StringBuffer();
        Map conflicts = this.myKeymap.getConflicts(this.myActionId, keyboardShortcut);
        Set keys = conflicts.keySet();
        String[] actionIds = ArrayUtil.toStringArray(keys);
        boolean loaded = true;
        for (String actionId : actionIds) {
            String actionPath = this.myMainGroup.getActionQualifiedPath(actionId);
            if (actionPath == null) {
                loaded = false;
            }
            if (buffer.length() > 1) {
                buffer.append('\n');
            }
            buffer.append('[');
            buffer.append(actionPath != null ? actionPath : actionId);
            buffer.append(']');
        }
        if (buffer.length() == 0) {
            this.myConflictInfoArea.setForeground(UIUtil.getTextAreaForeground());
            this.myConflictInfoArea.setText(KeyMapBundle.message((String)"no.conflict.info.message", (Object[])new Object[0]));
        } else {
            this.myConflictInfoArea.setForeground((Color)JBColor.RED);
            if (loaded) {
                this.myConflictInfoArea.setText(KeyMapBundle.message((String)"assigned.to.info.message", (Object[])new Object[]{buffer.toString()}));
            } else {
                this.myConflictInfoArea.setText("Assigned to " + buffer.toString() + " which is now not loaded but may be loaded later");
            }
        }
    }

    private void handleSecondKey() {
        this.mySecondStrokePanel.setEnabled(this.myEnableSecondKeystroke.isSelected());
    }

    public KeyboardShortcut getKeyboardShortcut() {
        KeyStroke firstStroke = this.myFirstStrokePanel.getKeyStroke();
        if (firstStroke == null) {
            return null;
        }
        KeyStroke secondStroke = this.myEnableSecondKeystroke.isSelected() ? this.mySecondStrokePanel.getKeyStroke() : null;
        return new KeyboardShortcut(firstStroke, secondStroke);
    }

    static String getTextByKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "";
        }
        return KeymapUtil.getKeystrokeText((KeyStroke)keyStroke);
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("preferences.keymap.shortcut");
    }

    private class StrokePanel
    extends JPanel {
        private final ShortcutTextField myShortcutTextField;

        public StrokePanel(String borderText) {
            this.setLayout(new BorderLayout());
            this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)borderText, (boolean)false));
            this.myShortcutTextField = new ShortcutTextField(){

                @Override
                protected void updateCurrentKeyStrokeInfo() {
                    KeyboardShortcutDialog.this.updateCurrentKeyStrokeInfo();
                }
            };
            this.add(this.myShortcutTextField);
        }

        public ShortcutTextField getShortcutTextField() {
            return this.myShortcutTextField;
        }

        @Override
        public void setEnabled(boolean state) {
            this.myShortcutTextField.setEnabled(state);
            this.repaint();
        }

        public KeyStroke getKeyStroke() {
            return this.myShortcutTextField.getKeyStroke();
        }
    }
}

