/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.Function;
import com.intellij.util.io.URLUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalPathReferenceProvider
implements PathReferenceProvider {
    @NonNls
    private static final String[] PREFIXES = new String[]{"mailto:", "tel:", "sms:", "skype:", "data:", "xmpp:"};

    public static boolean startsWithAllowedPrefix(String s) {
        for (String prefix : PREFIXES) {
            if (!s.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/openapi/paths/GlobalPathReferenceProvider", "createReferences"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/openapi/paths/GlobalPathReferenceProvider", "createReferences"));
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)psiElement);
        if (manipulator == null) {
            return false;
        }
        TextRange range = manipulator.getRangeInElement(psiElement);
        String s = range.substring(psiElement.getText());
        if (GlobalPathReferenceProvider.isWebReferenceUrl(s)) {
            references.add((PsiReference)new WebReference(psiElement, range));
        } else if (s.contains("://") || s.startsWith("//") || GlobalPathReferenceProvider.startsWithAllowedPrefix(s)) {
            PsiReferenceBase reference = PsiReferenceBase.createSelfReference((PsiElement)psiElement, (PsiElement)psiElement);
            references.add((PsiReference)reference);
            return true;
        }
        return false;
    }

    public static boolean isWebReferenceUrl(String url) {
        return url.startsWith("http://") || url.startsWith("https://") || url.startsWith("about:");
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/paths/GlobalPathReferenceProvider", "getPathReference"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/paths/GlobalPathReferenceProvider", "getPathReference"));
        }
        return URLUtil.containsScheme((String)path) ? new PathReference(path, (Function)PathReference.NULL_ICON) : null;
    }
}

