/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.BlockingProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.impl.DialogWrapperPeerImpl;
import com.intellij.openapi.ui.impl.FocusTrackbackProvider;
import com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressWindow
extends ProgressIndicatorBase
implements BlockingProgressIndicator,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.util.ProgressWindow");
    public static final int DEFAULT_PROGRESS_DIALOG_POSTPONE_TIME_MILLIS = 300;
    private static final int UPDATE_INTERVAL = 50;
    private MyDialog myDialog;
    private final Alarm myUpdateAlarm = new Alarm((Disposable)this);
    private final Project myProject;
    private final boolean myShouldShowCancel;
    private String myCancelText;
    private String myTitle = null;
    private boolean myStoppedAlready = false;
    protected final FocusTrackback myFocusTrackback;
    private boolean myStarted = false;
    protected boolean myBackgrounded = false;
    private boolean myWasShown;
    private String myProcessId = "<unknown>";
    @Nullable
    private volatile Runnable myBackgroundHandler;
    private int myDelayInMillis = 300;

    public ProgressWindow(boolean shouldShowCancel, Project project) {
        this(shouldShowCancel, false, project);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project) {
        this(shouldShowCancel, shouldShowBackground, project, null);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project, String cancelText) {
        this(shouldShowCancel, shouldShowBackground, project, null, cancelText);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project, JComponent parentComponent, String cancelText) {
        this.myProject = project;
        this.myShouldShowCancel = shouldShowCancel;
        this.myCancelText = cancelText;
        this.setModalityProgress(shouldShowBackground ? null : this);
        this.myFocusTrackback = new FocusTrackback((Object)this, WindowManager.getInstance().suggestParentWindow(project), false);
        Container parent = parentComponent;
        if (parent == null && project == null) {
            parent = JOptionPane.getRootFrame();
        }
        this.myDialog = parent != null ? new MyDialog(shouldShowBackground, parent, this.myCancelText) : new MyDialog(shouldShowBackground, this.myProject, this.myCancelText);
        Disposer.register((Disposable)this, (Disposable)this.myDialog);
        this.myFocusTrackback.registerFocusComponent(this.myDialog.getPanel());
        this.addStateDelegate(new AbstractProgressIndicatorExBase(){

            @Override
            public void cancel() {
                super.cancel();
                if (ProgressWindow.this.myDialog != null) {
                    ProgressWindow.this.myDialog.cancel();
                }
            }
        });
    }

    @Override
    public synchronized void start() {
        LOG.assertTrue(!this.isRunning());
        LOG.assertTrue(!this.myStoppedAlready);
        super.start();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.prepareShowDialog();
        }
        this.myStarted = true;
    }

    public void setDelayInMillis(int delayInMillis) {
        this.myDelayInMillis = delayInMillis;
    }

    private synchronized boolean isStarted() {
        return this.myStarted;
    }

    protected void prepareShowDialog() {
        Timer timer = UIUtil.createNamedTimer((String)"Progress window timer", (int)this.myDelayInMillis, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ProgressWindow.this.isRunning()) {
                            DialogWrapper popup;
                            if (ProgressWindow.this.myDialog != null && (popup = ProgressWindow.this.myDialog.myPopup) != null) {
                                ProgressWindow.this.myFocusTrackback.registerFocusComponent(new FocusTrackback.ComponentQuery(){

                                    @Override
                                    public Component getComponent() {
                                        return popup.getPreferredFocusedComponent();
                                    }
                                });
                                if (popup.isShowing()) {
                                    ProgressWindow.this.myWasShown = true;
                                }
                            }
                            ProgressWindow.this.showDialog();
                        } else {
                            Disposer.dispose((Disposable)ProgressWindow.this);
                        }
                    }
                }, ProgressWindow.this.getModalityState());
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startBlocking() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ProgressWindow progressWindow = this;
        synchronized (progressWindow) {
            LOG.assertTrue(!this.isRunning());
            LOG.assertTrue(!this.myStoppedAlready);
        }
        this.enterModality();
        IdeEventQueue.getInstance().pumpEventsForHierarchy(this.myDialog.myPanel, new Condition<AWTEvent>(){

            public boolean value(AWTEvent object) {
                if (ProgressWindow.this.myShouldShowCancel && object instanceof KeyEvent && object.getID() == 401 && ((KeyEvent)object).getKeyCode() == 27 && ((KeyEvent)object).getModifiers() == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProgressWindow.this.cancel();
                        }
                    });
                }
                return ProgressWindow.this.isStarted() && !ProgressWindow.this.isRunning();
            }
        });
        this.exitModality();
    }

    @NotNull
    public String getProcessId() {
        String string = this.myProcessId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWindow", "getProcessId"));
        }
        return string;
    }

    public void setProcessId(@NotNull String processId) {
        if (processId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processId", "com/intellij/openapi/progress/util/ProgressWindow", "setProcessId"));
        }
        this.myProcessId = processId;
    }

    protected void showDialog() {
        if (!this.isRunning() || this.isCanceled()) {
            return;
        }
        this.myWasShown = true;
        this.myDialog.show();
        if (this.myDialog != null) {
            this.myDialog.myRepaintRunnable.run();
        }
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.update();
    }

    @Override
    public synchronized void stop() {
        LOG.assertTrue(!this.myStoppedAlready);
        super.stop();
        if (this.isDialogShowing() && this.myFocusTrackback != null) {
            this.myFocusTrackback.setWillBeSheduledForRestore();
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean wasShowing = ProgressWindow.this.isDialogShowing();
                if (ProgressWindow.this.myDialog != null) {
                    ProgressWindow.this.myDialog.hide();
                }
                if (ProgressWindow.this.myFocusTrackback != null) {
                    if (wasShowing) {
                        ProgressWindow.this.myFocusTrackback.restoreFocus();
                    } else {
                        ProgressWindow.this.myFocusTrackback.consume();
                    }
                }
                ProgressWindow progressWindow = ProgressWindow.this;
                synchronized (progressWindow) {
                    ProgressWindow.this.myStoppedAlready = true;
                }
                Disposer.dispose((Disposable)ProgressWindow.this);
            }
        });
        SwingUtilities.invokeLater(EmptyRunnable.INSTANCE);
    }

    private boolean isDialogShowing() {
        return this.myDialog != null && this.myDialog.getPanel() != null && this.myDialog.getPanel().isShowing();
    }

    public void background() {
        Runnable backgroundHandler = this.myBackgroundHandler;
        if (backgroundHandler != null) {
            backgroundHandler.run();
            return;
        }
        if (this.myDialog != null) {
            this.myBackgrounded = true;
            this.myDialog.background();
            if (this.myDialog.wasShown()) {
                this.myFocusTrackback.restoreFocus();
            } else {
                this.myFocusTrackback.consume();
            }
            this.myDialog = null;
        }
    }

    public boolean isBackgrounded() {
        return this.myBackgrounded;
    }

    @Override
    public void setText(String text) {
        if (!Comparing.equal((String)text, (String)this.getText())) {
            super.setText(text);
            this.update();
        }
    }

    @Override
    public void setFraction(double fraction) {
        if (fraction != this.getFraction()) {
            super.setFraction(fraction);
            this.update();
        }
    }

    @Override
    public void setText2(String text) {
        if (!Comparing.equal((String)text, (String)this.getText2())) {
            super.setText2(text);
            this.update();
        }
    }

    private void update() {
        if (this.myDialog != null) {
            this.myDialog.update();
        }
    }

    public void setTitle(String title) {
        if (!Comparing.equal((String)title, (String)this.myTitle)) {
            this.myTitle = title;
            this.update();
        }
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setBackgroundHandler(@Nullable Runnable backgroundHandler) {
        this.myBackgroundHandler = backgroundHandler;
        this.myDialog.setShouldShowBackground(backgroundHandler != null);
    }

    public void setCancelButtonText(String text) {
        if (this.myDialog != null) {
            this.myDialog.changeCancelButtonText(text);
        } else {
            this.myCancelText = text;
        }
    }

    private IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    public void dispose() {
    }

    @Override
    public boolean isPopupWasShown() {
        return this.myDialog != null && this.myDialog.myPopup != null && this.myDialog.myPopup.isShowing();
    }

    protected class MyDialog
    implements Disposable {
        private long myLastTimeDrawn = -1L;
        private volatile boolean myShouldShowBackground;
        private final Runnable myRepaintRunnable;
        private final Runnable myUpdateRequest;
        private JPanel myPanel;
        private JLabel myTextLabel;
        private JBLabel myText2Label;
        private JButton myCancelButton;
        private JButton myBackgroundButton;
        private JProgressBar myProgressBar;
        private boolean myRepaintedFlag;
        private TitlePanel myTitlePanel;
        private JPanel myInnerPanel;
        private DialogWrapper myPopup;
        private final Window myParentWindow;
        private Point myLastClicked;

        private String getTitle2Text(String fullText, int labelWidth) {
            if (fullText == null || fullText.isEmpty()) {
                return " ";
            }
            while (this.myText2Label.getFontMetrics(this.myText2Label.getFont()).stringWidth(fullText) > labelWidth) {
                int sep = fullText.indexOf(File.separatorChar, 4);
                if (sep < 0) {
                    return fullText;
                }
                fullText = "..." + fullText.substring(sep);
            }
            return fullText;
        }

        public MyDialog(boolean shouldShowBackground, Project project, String cancelText) {
            this.$$$setupUI$$$();
            this.myRepaintRunnable = new Runnable(){

                @Override
                public void run() {
                    String text = ProgressWindow.this.getText();
                    double fraction = ProgressWindow.this.getFraction();
                    String text2 = ProgressWindow.this.getText2();
                    MyDialog.this.myTextLabel.setText(text != null && !text.isEmpty() ? text : " ");
                    if (MyDialog.this.myProgressBar.isShowing()) {
                        int perc = (int)(fraction * 100.0);
                        MyDialog.this.myProgressBar.setIndeterminate(perc == 0 || ProgressWindow.this.isIndeterminate());
                        MyDialog.this.myProgressBar.setValue(perc);
                    }
                    MyDialog.this.myText2Label.setText(MyDialog.this.getTitle2Text(text2, MyDialog.this.myText2Label.getWidth()));
                    MyDialog.this.myTitlePanel.setText(ProgressWindow.this.myTitle != null && !ProgressWindow.this.myTitle.isEmpty() ? ProgressWindow.this.myTitle : " ");
                    MyDialog.this.myLastTimeDrawn = System.currentTimeMillis();
                    MyDialog.this.myRepaintedFlag = true;
                }
            };
            this.myUpdateRequest = new Runnable(){

                @Override
                public void run() {
                    MyDialog.this.update();
                }
            };
            this.myRepaintedFlag = true;
            Window parentWindow = WindowManager.getInstance().suggestParentWindow(project);
            if (parentWindow == null) {
                parentWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
            }
            this.myParentWindow = parentWindow;
            this.initDialog(shouldShowBackground, cancelText);
        }

        public MyDialog(boolean shouldShowBackground, Component parent, String cancelText) {
            this.$$$setupUI$$$();
            this.myRepaintRunnable = new /* invalid duplicate definition of identical inner class */;
            this.myUpdateRequest = new /* invalid duplicate definition of identical inner class */;
            this.myRepaintedFlag = true;
            this.myParentWindow = parent instanceof Window ? (Window)parent : (Window)SwingUtilities.getAncestorOfClass(Window.class, parent);
            this.initDialog(shouldShowBackground, cancelText);
        }

        private void initDialog(boolean shouldShowBackground, String cancelText) {
            if (SystemInfo.isMac) {
                UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myText2Label);
            }
            this.myInnerPanel.setPreferredSize(new Dimension(SystemInfo.isMac ? 350 : 450, -1));
            this.myCancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyDialog.this.doCancelAction();
                }
            });
            this.myCancelButton.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MyDialog.this.myCancelButton.isEnabled()) {
                        MyDialog.this.doCancelAction();
                    }
                }
            }, KeyStroke.getKeyStroke(27, 0), 1);
            this.myShouldShowBackground = shouldShowBackground;
            if (cancelText != null) {
                ProgressWindow.this.setCancelButtonText(cancelText);
            }
            this.myProgressBar.setMaximum(100);
            this.createCenterPanel();
            this.myTitlePanel.setActive(true);
            this.myTitlePanel.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Point titleOffset = RelativePoint.getNorthWestOf((JComponent)MyDialog.this.myTitlePanel).getScreenPoint();
                    MyDialog.this.myLastClicked = new RelativePoint(e).getScreenPoint();
                    ((MyDialog)MyDialog.this).myLastClicked.x -= titleOffset.x;
                    ((MyDialog)MyDialog.this).myLastClicked.y -= titleOffset.y;
                }
            });
            this.myTitlePanel.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (MyDialog.this.myLastClicked == null) {
                        return;
                    }
                    Point draggedTo = new RelativePoint(e).getScreenPoint();
                    draggedTo.x -= ((MyDialog)MyDialog.this).myLastClicked.x;
                    draggedTo.y -= ((MyDialog)MyDialog.this).myLastClicked.y;
                    if (MyDialog.this.myPopup != null) {
                        MyDialog.this.myPopup.setLocation(draggedTo);
                    }
                }
            });
        }

        public void dispose() {
            ActionListener[] listeners;
            UIUtil.disposeProgress((JProgressBar)this.myProgressBar);
            UIUtil.dispose((Component)this.myTitlePanel);
            for (ActionListener listener : listeners = this.myCancelButton.getActionListeners()) {
                this.myCancelButton.removeActionListener(listener);
            }
        }

        public JPanel getPanel() {
            return this.myPanel;
        }

        public void setShouldShowBackground(final boolean shouldShowBackground) {
            this.myShouldShowBackground = shouldShowBackground;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyDialog.this.myBackgroundButton.setVisible(shouldShowBackground);
                    MyDialog.this.myPanel.revalidate();
                }
            });
        }

        public void changeCancelButtonText(String text) {
            this.myCancelButton.setText(text);
        }

        public void doCancelAction() {
            if (ProgressWindow.this.myShouldShowCancel) {
                ProgressWindow.this.cancel();
            }
        }

        public void cancel() {
            if (ProgressWindow.this.myShouldShowCancel) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MyDialog.this.myCancelButton.setEnabled(false);
                    }
                });
            }
        }

        private void createCenterPanel() {
            if (ProgressWindow.this.myCancelText != null) {
                this.myCancelButton.setText(ProgressWindow.this.myCancelText);
            }
            this.myCancelButton.setVisible(ProgressWindow.this.myShouldShowCancel);
            this.myBackgroundButton.setVisible(this.myShouldShowBackground);
            this.myBackgroundButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MyDialog.this.myShouldShowBackground) {
                        ProgressWindow.this.background();
                    }
                }
            });
        }

        private synchronized void update() {
            if (this.myRepaintedFlag) {
                if (System.currentTimeMillis() > this.myLastTimeDrawn + 50L) {
                    this.myRepaintedFlag = false;
                    SwingUtilities.invokeLater(this.myRepaintRunnable);
                } else if (ProgressWindow.this.myUpdateAlarm.getActiveRequestCount() == 0 && !ProgressWindow.this.myUpdateAlarm.isDisposed()) {
                    ProgressWindow.this.myUpdateAlarm.addRequest(this.myUpdateRequest, 500, ProgressWindow.this.getModalityState());
                }
            }
        }

        public synchronized void background() {
            if (this.myShouldShowBackground) {
                this.myBackgroundButton.setEnabled(false);
            }
            this.hide();
        }

        public void hide() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MyDialog.this.myPopup != null) {
                        MyDialog.this.myPopup.close(1);
                        MyDialog.this.myPopup = null;
                    }
                }
            });
        }

        public void show() {
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return;
            }
            if (this.myParentWindow == null) {
                return;
            }
            if (this.myPopup != null) {
                this.myPopup.close(1);
            }
            this.myPopup = this.myParentWindow.isShowing() ? new MyDialogWrapper(this.myParentWindow, ProgressWindow.this.myShouldShowCancel) : new MyDialogWrapper(ProgressWindow.this.myProject, ProgressWindow.this.myShouldShowCancel);
            this.myPopup.setUndecorated(true);
            if (SystemInfo.isAppleJvm) {
                this.myPopup.setTitle(ProgressWindow.this.myTitle);
            }
            if (this.myPopup.getPeer() instanceof DialogWrapperPeerImpl) {
                ((DialogWrapperPeerImpl)this.myPopup.getPeer()).setAutoRequestFocus(false);
            }
            this.myPopup.pack();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MyDialog.this.myPopup != null) {
                        FocusTrackback focusTrackback;
                        if (MyDialog.this.myPopup.getPeer() instanceof FocusTrackbackProvider && (focusTrackback = ((FocusTrackbackProvider)MyDialog.this.myPopup.getPeer()).getFocusTrackback()) != null) {
                            focusTrackback.consume();
                        }
                        ProgressWindow.this.getFocusManager().requestFocus((Component)MyDialog.this.myCancelButton, true);
                    }
                }
            });
            this.myPopup.show();
        }

        public boolean wasShown() {
            return ProgressWindow.this.myWasShown;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            TitlePanel titlePanel;
            JButton jButton;
            JButton jButton2;
            JProgressBar jProgressBar;
            JBLabel jBLabel;
            JLabel jLabel;
            JPanel jPanel;
            JPanel jPanel2;
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(6, 10, 10, 10), -1, -1, false, false));
            jPanel3.setOpaque(false);
            jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myInnerPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 2, null, null, null));
            this.myTextLabel = jLabel = new JLabel();
            jLabel.setText(" ");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, new Dimension(0, -1), null, null));
            this.myText2Label = jBLabel = new JBLabel();
            jBLabel.setText("");
            jBLabel.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
            jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 9, 1, 7, 0, new Dimension(0, -1), null, null));
            this.myProgressBar = jProgressBar = new JProgressBar();
            jProgressBar.putClientProperty("html.disable", Boolean.FALSE);
            jPanel.add((Component)jProgressBar, new GridConstraints(1, 0, 1, 2, 0, 1, 7, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(" ");
            jPanel.add((Component)jLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel3 = new JLabel();
            jLabel3.setText(" ");
            jPanel.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 1, 1, 2, null, null, null));
            this.myCancelButton = jButton2 = new JButton();
            jButton2.setFocusPainted(true);
            this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/CommonBundle").getString("button.cancel"));
            ((Component)jButton2).setEnabled(true);
            jPanel4.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
            this.myBackgroundButton = jButton = new JButton();
            jButton.setFocusPainted(true);
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/CommonBundle").getString("button.background"));
            jPanel4.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
            this.myTitlePanel = titlePanel = new TitlePanel();
            jPanel2.add((Component)titlePanel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }

        private class MyDialogWrapper
        extends DialogWrapper {
            private final boolean myIsCancellable;

            public MyDialogWrapper(Project project, boolean cancellable) {
                super(project, false);
                this.init();
                this.myIsCancellable = cancellable;
            }

            public MyDialogWrapper(Component parent, boolean cancellable) {
                super(parent, false);
                this.init();
                this.myIsCancellable = cancellable;
            }

            public void doCancelAction() {
                if (this.myIsCancellable) {
                    super.doCancelAction();
                }
            }

            @NotNull
            protected DialogWrapperPeer createPeer(@NotNull Component parent, boolean canBeParent) {
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/progress/util/ProgressWindow$MyDialog$MyDialogWrapper", "createPeer"));
                }
                if (System.getProperty("vintage.progress") == null) {
                    GlassPaneDialogWrapperPeer glassPaneDialogWrapperPeer;
                    block6: {
                        try {
                            glassPaneDialogWrapperPeer = new GlassPaneDialogWrapperPeer((DialogWrapper)this, parent, canBeParent);
                            if (glassPaneDialogWrapperPeer != null) break block6;
                        }
                        catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                            DialogWrapperPeer dialogWrapperPeer = super.createPeer(parent, canBeParent);
                            if (dialogWrapperPeer == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWindow$MyDialog$MyDialogWrapper", "createPeer"));
                            }
                            return dialogWrapperPeer;
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWindow$MyDialog$MyDialogWrapper", "createPeer"));
                    }
                    return glassPaneDialogWrapperPeer;
                }
                DialogWrapperPeer dialogWrapperPeer = super.createPeer(parent, canBeParent);
                if (dialogWrapperPeer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWindow$MyDialog$MyDialogWrapper", "createPeer"));
                }
                return dialogWrapperPeer;
            }

            @NotNull
            protected DialogWrapperPeer createPeer(boolean canBeParent, boolean applicationModalIfPossible) {
                DialogWrapperPeer dialogWrapperPeer = this.createPeer(null, canBeParent, applicationModalIfPossible);
                if (dialogWrapperPeer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWindow$MyDialog$MyDialogWrapper", "createPeer"));
                }
                return dialogWrapperPeer;
            }

            @NotNull
            protected DialogWrapperPeer createPeer(Window owner, boolean canBeParent, boolean applicationModalIfPossible) {
                if (System.getProperty("vintage.progress") == null) {
                    GlassPaneDialogWrapperPeer glassPaneDialogWrapperPeer;
                    block5: {
                        try {
                            glassPaneDialogWrapperPeer = new GlassPaneDialogWrapperPeer(this, canBeParent);
                            if (glassPaneDialogWrapperPeer != null) break block5;
                        }
                        catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                            DialogWrapperPeer dialogWrapperPeer = super.createPeer(WindowManager.getInstance().suggestParentWindow(ProgressWindow.this.myProject), canBeParent, applicationModalIfPossible);
                            if (dialogWrapperPeer == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWindow$MyDialog$MyDialogWrapper", "createPeer"));
                            }
                            return dialogWrapperPeer;
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWindow$MyDialog$MyDialogWrapper", "createPeer"));
                    }
                    return glassPaneDialogWrapperPeer;
                }
                DialogWrapperPeer dialogWrapperPeer = super.createPeer(WindowManager.getInstance().suggestParentWindow(ProgressWindow.this.myProject), canBeParent, applicationModalIfPossible);
                if (dialogWrapperPeer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWindow$MyDialog$MyDialogWrapper", "createPeer"));
                }
                return dialogWrapperPeer;
            }

            @NotNull
            protected DialogWrapperPeer createPeer(Project project, boolean canBeParent) {
                if (System.getProperty("vintage.progress") == null) {
                    GlassPaneDialogWrapperPeer glassPaneDialogWrapperPeer;
                    block5: {
                        try {
                            glassPaneDialogWrapperPeer = new GlassPaneDialogWrapperPeer((DialogWrapper)this, project, canBeParent);
                            if (glassPaneDialogWrapperPeer != null) break block5;
                        }
                        catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                            DialogWrapperPeer dialogWrapperPeer = super.createPeer(project, canBeParent);
                            if (dialogWrapperPeer == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWindow$MyDialog$MyDialogWrapper", "createPeer"));
                            }
                            return dialogWrapperPeer;
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWindow$MyDialog$MyDialogWrapper", "createPeer"));
                    }
                    return glassPaneDialogWrapperPeer;
                }
                DialogWrapperPeer dialogWrapperPeer = super.createPeer(project, canBeParent);
                if (dialogWrapperPeer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWindow$MyDialog$MyDialogWrapper", "createPeer"));
                }
                return dialogWrapperPeer;
            }

            protected void init() {
                super.init();
                this.setUndecorated(true);
                MyDialog.this.myPanel.setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
            }

            protected boolean isProgressDialog() {
                return true;
            }

            protected JComponent createCenterPanel() {
                return MyDialog.this.myPanel;
            }

            @Nullable
            protected JComponent createSouthPanel() {
                return null;
            }

            @Nullable
            protected Border createContentPaneBorder() {
                return null;
            }
        }
    }
}

