/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.actions.ActiveAnnotationGutter;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.actions.ShortNameType;
import com.intellij.openapi.vcs.actions.ShowAnnotationColorsAction;
import com.intellij.openapi.vcs.actions.ShowShortenNames;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class AnnotationFieldGutter
implements ActiveAnnotationGutter {
    protected final FileAnnotation myAnnotation;
    private final Editor myEditor;
    protected final LineAnnotationAspect myAspect;
    private final TextAnnotationPresentation myPresentation;
    private final boolean myIsGutterAction;
    private Map<String, Color> myColorScheme;
    private boolean myShowBg = ShowAnnotationColorsAction.isColorsEnabled();
    private boolean myShowAdditionalInfo = false;

    AnnotationFieldGutter(FileAnnotation annotation, Editor editor, LineAnnotationAspect aspect, TextAnnotationPresentation presentation, Map<String, Color> colorScheme) {
        this.myAnnotation = annotation;
        this.myEditor = editor;
        this.myAspect = aspect;
        this.myPresentation = presentation;
        this.myIsGutterAction = this.myAspect instanceof EditorGutterAction;
        this.myColorScheme = colorScheme;
    }

    public boolean isGutterAction() {
        return this.myIsGutterAction;
    }

    public String getLineText(int line, Editor editor) {
        String value;
        String string = value = this.isAvailable() ? this.myAspect.getValue(line) : "";
        if (this.myAspect.getId() == LineAnnotationAspect.AUTHOR && ShowShortenNames.isSet()) {
            return AnnotationFieldGutter.shorten(value, ShowShortenNames.getType());
        }
        return value;
    }

    @Nullable
    public static String shorten(String name, ShortNameType type) {
        if (name != null) {
            int[] ind = new int[]{name.indexOf(60), name.indexOf(64), name.indexOf(62)};
            if (0 < ind[0] && ind[0] < ind[1] && ind[1] < ind[2]) {
                return AnnotationFieldGutter.shorten(name.substring(0, ind[0]).trim(), type);
            }
            if (!name.contains(" ") && name.contains("@")) {
                String firstPart = name.substring(0, name.indexOf(64)).replace('.', ' ').replace('_', ' ').replace('-', ' ');
                if (firstPart.length() < name.length()) {
                    return AnnotationFieldGutter.shorten(firstPart, type);
                }
                return firstPart;
            }
            List strings = StringUtil.split((String)name.replace('.', ' ').replace('_', ' ').replace('-', ' '), (String)" ");
            if (strings.size() > 1) {
                return StringUtil.capitalize((String)(type == ShortNameType.FIRSTNAME ? (String)strings.get(0) : (String)strings.get(strings.size() - 1)));
            }
        }
        return name;
    }

    @Nullable
    public String getToolTip(int line, Editor editor) {
        return this.isAvailable() ? XmlStringUtil.escapeString((String)this.myAnnotation.getToolTip(line)) : null;
    }

    public void doAction(int line) {
        if (this.myIsGutterAction) {
            ((EditorGutterAction)this.myAspect).doAction(line);
        }
    }

    public Cursor getCursor(int line) {
        if (this.myIsGutterAction) {
            return ((EditorGutterAction)this.myAspect).getCursor(line);
        }
        return Cursor.getDefaultCursor();
    }

    public EditorFontType getStyle(int line, Editor editor) {
        return this.myPresentation.getFontType(line);
    }

    @Nullable
    public ColorKey getColor(int line, Editor editor) {
        return this.myPresentation.getColor(line);
    }

    public List<AnAction> getPopupActions(int line, Editor editor) {
        return this.myPresentation.getActions(line);
    }

    public void gutterClosed() {
        this.myAnnotation.unregister();
        this.myAnnotation.dispose();
        Collection gutters = (Collection)this.myEditor.getUserData(AnnotateToggleAction.KEY_IN_EDITOR);
        if (gutters != null) {
            gutters.remove(this);
        }
    }

    @Nullable
    public Color getBgColor(int line, Editor editor) {
        if (this.myColorScheme == null || !this.myShowBg) {
            return null;
        }
        String s = this.getLineText(line, editor);
        VcsRevisionNumber number = this.myAnnotation.getLineRevisionNumber(line);
        if (number == null || s == null) {
            return null;
        }
        Color bg = this.myColorScheme.get(number.asString());
        return bg == null ? this.findBgColor(s) : bg;
    }

    @Nullable
    private Color findBgColor(String s) {
        if (this.myColorScheme != null) {
            for (String key : this.myColorScheme.keySet()) {
                if (!key.startsWith(s)) continue;
                return this.myColorScheme.get(key);
            }
        }
        return null;
    }

    public void setAspectValueToBgColorMap(Map<String, Color> colorScheme) {
        this.myColorScheme = colorScheme;
    }

    public void setShowBg(boolean show) {
        this.myShowBg = show;
    }

    public void setShowAdditionalInfo(boolean show) {
        this.myShowAdditionalInfo = show;
    }

    public boolean isAvailable() {
        return this.myShowAdditionalInfo || VcsUtil.isAspectAvailableByDefault((String)this.getID());
    }

    @Nullable
    public String getID() {
        return this.myAspect == null ? null : this.myAspect.getId();
    }

    public static void main(String[] args) {
        assert (AnnotationFieldGutter.shorten("Vasya Pavlovich Pupkin <asdasd@localhost>", ShortNameType.FIRSTNAME).equals("Vasya"));
        assert (AnnotationFieldGutter.shorten("Vasya Pavlovich Pupkin <asdasd@localhost>", ShortNameType.LASTNAME).equals("Pupkin"));
        assert (AnnotationFieldGutter.shorten("Vasya Pavlovich Pupkin", ShortNameType.FIRSTNAME).equals("Vasya"));
        assert (AnnotationFieldGutter.shorten("Vasya Pavlovich Pupkin", ShortNameType.LASTNAME).equals("Pupkin"));
        assert (AnnotationFieldGutter.shorten("vasya.pupkin@localhost.com", ShortNameType.LASTNAME).equals("Pupkin"));
        assert (AnnotationFieldGutter.shorten("vasya.pupkin@localhost.com", ShortNameType.FIRSTNAME).equals("Vasya"));
    }
}

