/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackLineStatusAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (project == null || editor == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(editor.getDocument());
        if (tracker == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (!RollbackLineStatusAction.isSomeChangeSelected(editor, tracker)) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR);
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(editor.getDocument());
        assert (tracker != null);
        RollbackLineStatusAction.rollback(tracker, editor, null);
    }

    protected static boolean isSomeChangeSelected(@NotNull Editor editor, @NotNull LineStatusTracker tracker) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ex/RollbackLineStatusAction", "isSomeChangeSelected"));
        }
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/RollbackLineStatusAction", "isSomeChangeSelected"));
        }
        List carets = editor.getCaretModel().getAllCarets();
        if (carets.size() != 1) {
            return true;
        }
        Caret caret = (Caret)carets.get(0);
        if (caret.hasSelection()) {
            return true;
        }
        return tracker.getRangeForLine(caret.getLogicalPosition().line) != null;
    }

    protected static void rollback(@NotNull LineStatusTracker tracker, @Nullable Editor editor, @Nullable Range range) {
        Caret caret;
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/RollbackLineStatusAction", "rollback"));
        }
        assert (editor != null || range != null);
        if (range != null) {
            RollbackLineStatusAction.doRollback(tracker, range);
            return;
        }
        Document document = editor.getDocument();
        int totalLines = RollbackLineStatusAction.getLineCount(document);
        BitSet lines = new BitSet(totalLines + 1);
        List carets = editor.getCaretModel().getAllCarets();
        if (carets.size() == 1 && (caret = (Caret)carets.get(0)).getSelectionStart() == 0 && caret.getSelectionEnd() == document.getTextLength()) {
            RollbackLineStatusAction.doRollback(tracker);
            return;
        }
        for (Caret caret2 : carets) {
            if (caret2.hasSelection()) {
                int line1 = editor.offsetToLogicalPosition((int)caret2.getSelectionStart()).line;
                int line2 = editor.offsetToLogicalPosition((int)caret2.getSelectionEnd()).line;
                lines.set(line1, line2 + 1);
                if (caret2.getSelectionEnd() != document.getTextLength()) continue;
                lines.set(totalLines);
                continue;
            }
            lines.set(caret2.getLogicalPosition().line);
            if (caret2.getOffset() != document.getTextLength()) continue;
            lines.set(totalLines);
        }
        RollbackLineStatusAction.doRollback(tracker, lines);
    }

    private static void doRollback(final @NotNull LineStatusTracker tracker, final @NotNull Range range) {
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/RollbackLineStatusAction", "doRollback"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/RollbackLineStatusAction", "doRollback"));
        }
        RollbackLineStatusAction.execute(tracker, new Runnable(){

            @Override
            public void run() {
                tracker.rollbackChanges(range);
            }
        });
    }

    private static void doRollback(final @NotNull LineStatusTracker tracker, final @NotNull BitSet lines) {
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/RollbackLineStatusAction", "doRollback"));
        }
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/openapi/vcs/ex/RollbackLineStatusAction", "doRollback"));
        }
        RollbackLineStatusAction.execute(tracker, new Runnable(){

            @Override
            public void run() {
                tracker.rollbackChanges(lines);
            }
        });
    }

    private static void doRollback(final @NotNull LineStatusTracker tracker) {
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/RollbackLineStatusAction", "doRollback"));
        }
        RollbackLineStatusAction.execute(tracker, new Runnable(){

            @Override
            public void run() {
                tracker.rollbackAllChanges();
            }
        });
    }

    private static void execute(final @NotNull LineStatusTracker tracker, final @NotNull Runnable task) {
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/RollbackLineStatusAction", "execute"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/vcs/ex/RollbackLineStatusAction", "execute"));
        }
        CommandProcessor.getInstance().executeCommand(tracker.getProject(), new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        ReadonlyStatusHandler.OperationStatus operationStatus;
                        if (!tracker.getDocument().isWritable() && (operationStatus = ReadonlyStatusHandler.getInstance((Project)tracker.getProject()).ensureFilesWritable(new VirtualFile[]{tracker.getVirtualFile()})).hasReadonlyFiles()) {
                            return;
                        }
                        task.run();
                    }
                });
            }
        }, VcsBundle.message((String)"command.name.rollback.change", (Object[])new Object[0]), null);
    }

    private static int getLineCount(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ex/RollbackLineStatusAction", "getLineCount"));
        }
        return Math.max(document.getLineCount(), 1);
    }
}

