/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassOwnerEx;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.JavaDummyHolderFactory;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiFacadeImpl
extends JavaPsiFacadeEx {
    private volatile PsiElementFinder[] myElementFinders;
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private volatile SoftReference<ConcurrentMap<String, PsiPackage>> myPackageCache;
    private final Project myProject;
    private final JavaFileManager myFileManager;

    public JavaPsiFacadeImpl(Project project, PsiManagerImpl psiManager, JavaFileManager javaFileManager, MessageBus bus) {
        this.myProject = project;
        this.myFileManager = javaFileManager;
        this.myConstantEvaluationHelper = new PsiConstantEvaluationHelperImpl();
        final PsiModificationTracker modificationTracker = psiManager.getModificationTracker();
        if (bus != null) {
            bus.connect().subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){
                private long lastTimeSeen = -1L;

                public void modificationCountChanged() {
                    long now = modificationTracker.getJavaStructureModificationCount();
                    if (this.lastTimeSeen != now) {
                        this.lastTimeSeen = now;
                        JavaPsiFacadeImpl.this.myPackageCache = null;
                    }
                }
            });
        }
        DummyHolderFactory.setFactory(new JavaDummyHolderFactory());
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClass"));
        }
        ProgressIndicatorProvider.checkCanceled();
        if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
            PsiClass[] classes = this.findClassesInDumbMode(qualifiedName, scope);
            if (classes.length != 0) {
                return classes[0];
            }
            return null;
        }
        for (PsiElementFinder finder : this.finders()) {
            PsiClass aClass = finder.findClass(qualifiedName, scope);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    @NotNull
    private PsiClass[] findClassesInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
        }
        String packageName = StringUtil.getPackageName((String)qualifiedName);
        PsiPackage pkg = this.findPackage(packageName);
        String className = StringUtil.getShortName((String)qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName((String)className, (PsiClass[])containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null || !pkg.containsClassNamed(className)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
        }
        if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
            PsiClass[] psiClassArray = this.findClassesInDumbMode(qualifiedName, scope);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
            }
            return psiClassArray;
        }
        SmartList classes = new SmartList();
        for (PsiElementFinder finder : this.finders()) {
            Object[] finderClasses = finder.findClasses(qualifiedName, scope);
            ContainerUtil.addAll((Collection)classes, (Object[])finderClasses);
        }
        PsiClass[] psiClassArray = classes.toArray(new PsiClass[classes.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    private PsiElementFinder[] finders() {
        PsiElementFinder[] answer = this.myElementFinders;
        if (answer == null) {
            this.myElementFinders = answer = this.calcFinders();
        }
        if (answer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "finders"));
        }
        return answer;
    }

    @NotNull
    private PsiElementFinder[] calcFinders() {
        ArrayList<PsiElementFinderImpl> elementFinders = new ArrayList<PsiElementFinderImpl>();
        elementFinders.add(new PsiElementFinderImpl());
        ContainerUtil.addAll(elementFinders, (Object[])this.myProject.getExtensions(PsiElementFinder.EP_NAME));
        PsiElementFinder[] psiElementFinderArray = elementFinders.toArray(new PsiElementFinder[elementFinders.size()]);
        if (psiElementFinderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "calcFinders"));
        }
        return psiElementFinderArray;
    }

    @NotNull
    public PsiConstantEvaluationHelper getConstantEvaluationHelper() {
        PsiConstantEvaluationHelper psiConstantEvaluationHelper = this.myConstantEvaluationHelper;
        if (psiConstantEvaluationHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getConstantEvaluationHelper"));
        }
        return psiConstantEvaluationHelper;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        PsiPackage aPackage;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findPackage"));
        }
        ConcurrentMap cache = (ConcurrentMap)SoftReference.dereference(this.myPackageCache);
        if (cache == null) {
            cache = new ConcurrentHashMap();
            this.myPackageCache = new SoftReference((Object)cache);
        }
        if ((aPackage = (PsiPackage)cache.get(qualifiedName)) != null) {
            return aPackage;
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            aPackage = finder.findPackage(qualifiedName);
            if (aPackage == null) continue;
            return (PsiPackage)ConcurrencyUtil.cacheOrGet((ConcurrentMap)cache, (Object)qualifiedName, (Object)aPackage);
        }
        return null;
    }

    @NotNull
    private PsiElementFinder[] filteredFinders() {
        DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        PsiElementFinder[] finders = this.finders();
        if (dumbService.isDumb()) {
            List list = dumbService.filterByDumbAwareness(Arrays.asList(finders));
            finders = list.toArray(new PsiElementFinder[list.size()]);
        }
        if (finders == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "filteredFinders"));
        }
        return finders;
    }

    @NotNull
    public PsiJavaParserFacade getParserFacade() {
        PsiElementFactory psiElementFactory = this.getElementFactory();
        if (psiElementFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getParserFacade"));
        }
        return psiElementFactory;
    }

    @NotNull
    public PsiResolveHelper getResolveHelper() {
        PsiResolveHelper psiResolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)this.myProject);
        if (psiResolveHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getResolveHelper"));
        }
        return psiResolveHelper;
    }

    @NotNull
    public PsiNameHelper getNameHelper() {
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)this.myProject);
        if (psiNameHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getNameHelper"));
        }
        return psiNameHelper;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClassNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClassNames"));
        }
        THashSet result = new THashSet();
        for (PsiElementFinder finder : this.filteredFinders()) {
            result.addAll(finder.getClassNames(psiPackage, scope));
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClassNames"));
        }
        return tHashSet;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClasses"));
        }
        ArrayList result = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            Object[] classes = finder.getClasses(psiPackage, scope);
            if (classes.length == 0) continue;
            if (result == null) {
                result = new ArrayList();
            }
            ContainerUtil.addAll((Collection)result, (Object[])classes);
        }
        PsiClass[] psiClassArray = result == null ? PsiClass.EMPTY_ARRAY : result.toArray(new PsiClass[result.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClasses"));
        }
        return psiClassArray;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "processPackageDirectories"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "processPackageDirectories"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/JavaPsiFacadeImpl", "processPackageDirectories"));
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            if (finder.processPackageDirectories(psiPackage, scope, consumer, includeLibrarySources)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getSubPackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getSubPackages"));
        }
        LinkedHashMap<String, PsiPackage> result = new LinkedHashMap<String, PsiPackage>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            PsiPackage[] packages;
            for (PsiPackage aPackage : packages = finder.getSubPackages(psiPackage, scope)) {
                if (result.get(aPackage.getName()) != null) continue;
                result.put(aPackage.getName(), aPackage);
            }
        }
        PsiPackage[] psiPackageArray = result.values().toArray(new PsiPackage[result.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    public PsiClass[] findClassByShortName(String name, PsiPackage psiPackage, GlobalSearchScope scope) {
        ArrayList result = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            Object[] classes = finder.getClasses(name, psiPackage, scope);
            if (classes.length == 0) continue;
            if (result == null) {
                result = new ArrayList();
            }
            ContainerUtil.addAll((Collection)result, (Object[])classes);
        }
        return result == null ? PsiClass.EMPTY_ARRAY : result.toArray(new PsiClass[result.size()]);
    }

    public boolean isPartOfPackagePrefix(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "isPartOfPackagePrefix"));
        }
        Collection<String> packagePrefixes = this.myFileManager.getNonTrivialPackagePrefixes();
        for (String subpackageName : packagePrefixes) {
            if (!PsiNameHelper.isSubpackageOf((String)subpackageName, (String)packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean isInPackage(@NotNull PsiElement element, @NotNull PsiPackage aPackage) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/JavaPsiFacadeImpl", "isInPackage"));
        }
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "isInPackage"));
        }
        PsiFile file = FileContextUtil.getContextFile(element);
        if (file instanceof JavaDummyHolder) {
            return ((JavaDummyHolder)file).isInPackage(aPackage);
        }
        if (file instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file).getPackageName();
            return packageName.equals(aPackage.getQualifiedName());
        }
        return false;
    }

    public boolean arePackagesTheSame(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiFile file2;
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/psi/impl/JavaPsiFacadeImpl", "arePackagesTheSame"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/psi/impl/JavaPsiFacadeImpl", "arePackagesTheSame"));
        }
        PsiFile file1 = FileContextUtil.getContextFile(element1);
        if (Comparing.equal((Object)file1, (Object)(file2 = FileContextUtil.getContextFile(element2)))) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder && file2 instanceof JavaDummyHolder) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder || file2 instanceof JavaDummyHolder) {
            JavaDummyHolder dummyHolder = (JavaDummyHolder)(file1 instanceof JavaDummyHolder ? file1 : file2);
            PsiFile other = file1 instanceof JavaDummyHolder ? file2 : file1;
            return dummyHolder.isSamePackage((PsiElement)other);
        }
        if (!(file1 instanceof PsiClassOwner)) {
            return false;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            return false;
        }
        String package1 = ((PsiClassOwner)file1).getPackageName();
        String package2 = ((PsiClassOwner)file2).getPackageName();
        return Comparing.equal((String)package1, (String)package2);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getProject"));
        }
        return project;
    }

    @NotNull
    public PsiElementFactory getElementFactory() {
        PsiElementFactory psiElementFactory = PsiElementFactory.SERVICE.getInstance((Project)this.myProject);
        if (psiElementFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getElementFactory"));
        }
        return psiElementFactory;
    }

    @Override
    public void setAssertOnFileLoadingFilter(@NotNull VirtualFileFilter filter, Disposable parentDisposable) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/impl/JavaPsiFacadeImpl", "setAssertOnFileLoadingFilter"));
        }
        ((PsiManagerImpl)PsiManager.getInstance((Project)this.myProject)).setAssertOnFileLoadingFilter(filter, parentDisposable);
    }

    private class PsiElementFinderImpl
    extends PsiElementFinder
    implements DumbAware {
        private PsiElementFinderImpl() {
        }

        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "findClass"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "findClass"));
            }
            return JavaPsiFacadeImpl.this.myFileManager.findClass(qualifiedName, scope);
        }

        @NotNull
        public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "findClasses"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "findClasses"));
            }
            PsiClass[] psiClassArray = JavaPsiFacadeImpl.this.myFileManager.findClasses(qualifiedName, scope);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "findClasses"));
            }
            return psiClassArray;
        }

        public PsiPackage findPackage(@NotNull String qualifiedName) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "findPackage"));
            }
            return JavaPsiFacadeImpl.this.myFileManager.findPackage(qualifiedName);
        }

        @NotNull
        public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
            if (psiPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getSubPackages"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getSubPackages"));
            }
            HashMap packagesMap = new HashMap();
            String qualifiedName = psiPackage.getQualifiedName();
            for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
                PsiDirectory[] subDirs;
                for (PsiDirectory subDir : subDirs = dir.getSubdirectories()) {
                    String subQualifiedName;
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subDir);
                    if (aPackage == null || !(subQualifiedName = aPackage.getQualifiedName()).startsWith(qualifiedName) || packagesMap.containsKey(subQualifiedName)) continue;
                    packagesMap.put(aPackage.getQualifiedName(), aPackage);
                }
            }
            packagesMap.remove(qualifiedName);
            PsiPackage[] psiPackageArray = packagesMap.values().toArray(new PsiPackage[packagesMap.size()]);
            if (psiPackageArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getSubPackages"));
            }
            return psiPackageArray;
        }

        @NotNull
        public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
            if (psiPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
            }
            PsiClass[] psiClassArray = this.getClasses(null, psiPackage, scope);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
            }
            return psiClassArray;
        }

        @NotNull
        public PsiClass[] getClasses(@Nullable String shortName, @NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope) {
            if (psiPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
            }
            ArrayList<PsiClass> list = null;
            String packageName = psiPackage.getQualifiedName();
            for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
                PsiClass[] classes = JavaDirectoryService.getInstance().getClasses(dir);
                if (classes.length == 0) continue;
                if (list == null) {
                    list = new ArrayList<PsiClass>();
                }
                for (PsiClass aClass : classes) {
                    String qualifiedName = aClass.getQualifiedName();
                    if (qualifiedName != null) {
                        qualifiedName = StringUtil.getPackageName((String)qualifiedName);
                    }
                    if (!Comparing.strEqual((String)qualifiedName, (String)packageName) || shortName != null && !shortName.equals(aClass.getName())) continue;
                    list.add(aClass);
                }
            }
            if (list == null) {
                if (PsiClass.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
                }
                return PsiClass.EMPTY_ARRAY;
            }
            if (list.size() > 1) {
                ContainerUtil.quickSort((List)list, (Comparator)new Comparator<PsiClass>(){

                    @Override
                    public int compare(PsiClass o1, PsiClass o2) {
                        VirtualFile file1 = PsiUtilCore.getVirtualFile((PsiElement)o1);
                        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)o2);
                        return file1 == null ? (file2 == null ? 0 : -1) : (file2 == null ? 1 : scope.compare(file2, file1));
                    }
                });
            }
            PsiClass[] psiClassArray = list.toArray(new PsiClass[list.size()]);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
            }
            return psiClassArray;
        }

        @NotNull
        public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
            if (psiPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClassNames"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClassNames"));
            }
            HashSet names = null;
            FileIndexFacade facade = FileIndexFacade.getInstance((Project)JavaPsiFacadeImpl.this.myProject);
            for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
                for (PsiFile file : dir.getFiles()) {
                    Set inFile;
                    VirtualFile vFile;
                    if (!(file instanceof PsiClassOwner) || file.getViewProvider().getLanguages().size() != 1 || (vFile = file.getVirtualFile()) != null && !(file instanceof PsiCompiledElement) && !facade.isInSourceContent(vFile) && (!scope.isForceSearchingInLibrarySources() || !StubTreeLoader.getInstance().canHaveStub(vFile))) continue;
                    Set set = inFile = file instanceof PsiClassOwnerEx ? ((PsiClassOwnerEx)file).getClassNames() : PsiElementFinderImpl.getClassNames((PsiClass[])((PsiClassOwner)file).getClasses());
                    if (inFile.isEmpty()) continue;
                    if (names == null) {
                        names = new HashSet();
                    }
                    names.addAll(inFile);
                }
            }
            Set<String> set = names == null ? Collections.emptySet() : names;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClassNames"));
            }
            return set;
        }

        public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope, final @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
            if (psiPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "processPackageDirectories"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "processPackageDirectories"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "processPackageDirectories"));
            }
            final PsiManager psiManager = PsiManager.getInstance((Project)JavaPsiFacadeImpl.this.getProject());
            return PackageIndex.getInstance((Project)JavaPsiFacadeImpl.this.getProject()).getDirsByPackageName(psiPackage.getQualifiedName(), includeLibrarySources).forEach((Processor)new ReadActionProcessor<VirtualFile>(){

                public boolean processInReadAction(VirtualFile dir) {
                    if (!scope.contains(dir)) {
                        return true;
                    }
                    PsiDirectory psiDir = psiManager.findDirectory(dir);
                    return psiDir == null || consumer.process((Object)psiDir);
                }
            });
        }
    }
}

